/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.metrics;

import org.apache.heron.api.metric.CountMetric;
import org.apache.heron.api.metric.CumulativeCountMetric;
import org.apache.heron.api.metric.MeanReducer;
import org.apache.heron.api.metric.MeanReducerState;
import org.apache.heron.api.metric.ReducedMetric;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.ISpoutMetrics;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.common.utils.topology.TopologyContextImpl;

public class SpoutMetrics
implements ISpoutMetrics {
    private final CountMetric ackCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> completeLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final ReducedMetric<MeanReducerState, Number, Double> failLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final CountMetric failCount = new CountMetric();
    private final CountMetric timeoutCount = new CountMetric();
    private final CountMetric emitCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> nextTupleLatency = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final CountMetric nextTupleCount = new CountMetric();
    private final CountMetric tupleAddedToQueue;
    private final CountMetric outQueueFullCount = new CountMetric();
    private final ReducedMetric<MeanReducerState, Number, Double> pendingTuplesCount = new ReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private CumulativeCountMetric taskRunCount;
    private CumulativeCountMetric produceTupleCount;
    private CumulativeCountMetric continueWorkCount;

    public SpoutMetrics() {
        this.tupleAddedToQueue = new CountMetric();
        this.taskRunCount = new CumulativeCountMetric();
        this.produceTupleCount = new CumulativeCountMetric();
        this.continueWorkCount = new CumulativeCountMetric();
    }

    @Override
    public void registerMetrics(TopologyContextImpl topologyContext) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int interval = (int)systemConfig.getHeronMetricsExportInterval().getSeconds();
        topologyContext.registerMetric("__ack-count/default", this.ackCount, interval);
        topologyContext.registerMetric("__complete-latency/default", this.completeLatency, interval);
        topologyContext.registerMetric("__fail-latency/default", this.failLatency, interval);
        topologyContext.registerMetric("__fail-count/default", this.failCount, interval);
        topologyContext.registerMetric("__timeout-count/default", this.timeoutCount, interval);
        topologyContext.registerMetric("__emit-count/default", this.emitCount, interval);
        topologyContext.registerMetric("__next-tuple-latency", this.nextTupleLatency, interval);
        topologyContext.registerMetric("__next-tuple-count", this.nextTupleCount, interval);
        topologyContext.registerMetric("__out-queue-full-count", this.outQueueFullCount, interval);
        topologyContext.registerMetric("__pending-acked-count", this.pendingTuplesCount, interval);
        topologyContext.registerMetric("__data-tuple-added-to-outgoing-queue/default", this.tupleAddedToQueue, interval);
        topologyContext.registerMetric("__task-run-count", this.taskRunCount, interval);
        topologyContext.registerMetric("__produce-tuple-count", this.produceTupleCount, interval);
        topologyContext.registerMetric("__continue-work-count", this.continueWorkCount, interval);
    }

    @Override
    public void initMultiCountMetrics(PhysicalPlanHelper helper) {
    }

    @Override
    public void ackedTuple(String streamId, long latency) {
        this.ackCount.incr();
        this.completeLatency.update(latency);
    }

    @Override
    public void failedTuple(String streamId, long latency) {
        this.failCount.incr();
        this.failLatency.update(latency);
    }

    @Override
    public void timeoutTuple(String streamId) {
        this.timeoutCount.incr();
    }

    @Override
    public void emittedTuple(String streamId) {
        this.emitCount.incr();
    }

    @Override
    public void addTupleToQueue(int size) {
        this.tupleAddedToQueue.incr();
    }

    @Override
    public void nextTuple(long latency) {
        this.nextTupleLatency.update(latency);
        this.nextTupleCount.incr();
    }

    @Override
    public void updateOutQueueFullCount() {
        this.outQueueFullCount.incr();
    }

    @Override
    public void updatePendingTuplesCount(long count) {
        this.pendingTuplesCount.update(count);
    }

    @Override
    public void serializeDataTuple(String streamId, long latency) {
    }

    @Override
    public void updateTaskRunCount() {
        this.taskRunCount.incr();
    }

    @Override
    public void updateProduceTupleCount() {
        this.produceTupleCount.incr();
    }

    @Override
    public void updateContinueWorkCount() {
        this.continueWorkCount.incr();
    }
}

