/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.heron.api.grouping.CustomStreamGrouping;
import org.apache.heron.api.topology.TopologyContext;

class CustomStreamGroupingHelper {
    private final Map<String, List<Target>> targets = new HashMap<String, List<Target>>();

    CustomStreamGroupingHelper() {
    }

    public void add(String streamId, List<Integer> taskIds, CustomStreamGrouping grouping, String sourceComponentName) {
        if (!this.targets.containsKey(streamId)) {
            this.targets.put(streamId, new ArrayList());
        }
        this.targets.get(streamId).add(new Target(taskIds, grouping, sourceComponentName));
    }

    void prepare(TopologyContext context) {
        for (String streamId : this.targets.keySet()) {
            for (Target target : this.targets.get(streamId)) {
                target.prepare(context, streamId);
            }
        }
    }

    List<Integer> chooseTasks(String streamId, List<Object> values) {
        List<Target> targetList = this.targets.get(streamId);
        if (targetList != null) {
            ArrayList<Integer> res = new ArrayList<Integer>();
            for (Target target : targetList) {
                res.addAll(target.chooseTasks(values));
            }
            return res;
        }
        return null;
    }

    boolean isCustomGroupingEmpty() {
        return this.targets.isEmpty();
    }

    private static class Target {
        private final String componentName;
        private final List<Integer> taskIds;
        private final CustomStreamGrouping grouping;

        Target(List<Integer> taskIds, CustomStreamGrouping grouping, String componentName) {
            this.taskIds = taskIds;
            this.grouping = grouping;
            this.componentName = componentName;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public List<Integer> getTaskIds() {
            return this.taskIds;
        }

        public CustomStreamGrouping getGrouping() {
            return this.grouping;
        }

        public void prepare(TopologyContext context, String streamId) {
            this.grouping.prepare(context, this.componentName, streamId, this.taskIds);
        }

        private List<Integer> chooseTasks(List<Object> values) {
            return this.grouping.chooseTasks(values);
        }
    }
}

