/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.executors;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.heron.common.basics.Communicator;
import org.apache.heron.common.basics.SlaveLooper;
import org.apache.heron.common.basics.WakeableLooper;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.JVMMetrics;
import org.apache.heron.common.utils.metrics.MetricsCollector;
import org.apache.heron.proto.system.Metrics;
import org.apache.heron.simulator.executors.InstanceExecutor;

public class MetricsExecutor
implements Runnable {
    private static final Logger LOG = Logger.getLogger(InstanceExecutor.class.getName());
    private final List<InstanceExecutor> instanceExecutors = new LinkedList<InstanceExecutor>();
    private final WakeableLooper looper = this.createWakeableLooper();
    private final MetricsCollector metricsCollector;
    private final Communicator<Metrics.MetricPublisherPublishMessage> metricsQueue = new Communicator(null, this.looper);
    private final SystemConfig systemConfig;
    private final String executorId = "Simulator_Metrics_Executor";

    public MetricsExecutor(SystemConfig systemConfig) {
        this.metricsCollector = new MetricsCollector(this.looper, this.metricsQueue);
        this.systemConfig = systemConfig;
    }

    public void addInstanceExecutor(InstanceExecutor instanceExecutor) {
        instanceExecutor.getMetricsOutQueue().setConsumer(this.looper);
        this.instanceExecutors.add(instanceExecutor);
    }

    private void setupJVMMetrics() {
        JVMMetrics jvmMetrics = new JVMMetrics();
        jvmMetrics.registerMetrics(this.metricsCollector);
        this.metricsCollector.registerMetricSampleRunnable(jvmMetrics.getJVMSampleRunnable(), this.systemConfig.getHeronMetricsExportInterval().dividedBy(2L));
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Simulator_Metrics_Executor");
        LOG.info("Metrics_Executor starts");
        this.setupJVMMetrics();
        this.addMetricsExecutorTasks();
        this.looper.loop();
    }

    public void stop() {
        this.looper.exitLoop();
    }

    protected void addMetricsExecutorTasks() {
        Runnable metricsExecutorsTasks = new Runnable(){

            @Override
            public void run() {
                for (InstanceExecutor instance : MetricsExecutor.this.instanceExecutors) {
                    MetricsExecutor.this.handleExecutorsMetrics(instance);
                }
                while (!MetricsExecutor.this.metricsQueue.isEmpty()) {
                    MetricsExecutor.this.handleMetricPublisherPublishMessage("Simulator_Metrics_Executor", (Metrics.MetricPublisherPublishMessage)MetricsExecutor.this.metricsQueue.poll());
                }
            }
        };
        this.looper.addTasksOnWakeup(metricsExecutorsTasks);
    }

    protected void handleExecutorsMetrics(InstanceExecutor instance) {
        while (!instance.getMetricsOutQueue().isEmpty()) {
            this.handleMetricPublisherPublishMessage(instance.getInstanceId(), instance.getMetricsOutQueue().poll());
        }
    }

    protected void handleMetricPublisherPublishMessage(String instanceId, Metrics.MetricPublisherPublishMessage message) {
        LOG.info(String.format("Metrics from %s at time %s:\n%s", instanceId, System.currentTimeMillis(), message.toString()));
    }

    protected WakeableLooper createWakeableLooper() {
        return new SlaveLooper();
    }
}

