/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.grouping;

import java.util.LinkedList;
import java.util.List;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.utils.Utils;
import org.apache.heron.proto.system.HeronTuples;
import org.apache.heron.simulator.grouping.Grouping;

public class FieldsGrouping
extends Grouping {
    private final List<Integer> fieldsGroupingIndices = new LinkedList<Integer>();

    public FieldsGrouping(TopologyAPI.InputStream inputStream, TopologyAPI.StreamSchema schema, List<Integer> taskIds) {
        super(taskIds);
        block0: for (int i = 0; i < schema.getKeysCount(); ++i) {
            for (int j = 0; j < inputStream.getGroupingFields().getKeysCount(); ++j) {
                Boolean keysEqual = schema.getKeys(i).getKey().equals(inputStream.getGroupingFields().getKeys(j).getKey());
                if (!keysEqual.booleanValue()) continue;
                this.fieldsGroupingIndices.add(i);
                continue block0;
            }
        }
    }

    @Override
    public List<Integer> getListToSend(HeronTuples.HeronDataTuple tuple) {
        LinkedList<Integer> res = new LinkedList<Integer>();
        int taskIndex = 0;
        int primeNumber = 633910111;
        for (Integer indices : this.fieldsGroupingIndices) {
            taskIndex += this.getHashCode(tuple.getValues(indices)) % primeNumber;
        }
        res.add(Utils.assignKeyToTask(taskIndex, this.taskIds));
        return res;
    }

    protected int getHashCode(Object o) {
        return o.hashCode();
    }
}

