/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.grouping;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.heron.proto.system.HeronTuples;
import org.apache.heron.simulator.grouping.Grouping;

public class ShuffleGrouping
extends Grouping {
    private final int taskIdsSize;
    private int nextTaskIndex;

    public ShuffleGrouping(List<Integer> taskIds) {
        super(taskIds);
        this.taskIdsSize = taskIds.size();
        this.nextTaskIndex = new Random().nextInt(taskIds.size());
    }

    @Override
    public List<Integer> getListToSend(HeronTuples.HeronDataTuple tuple) {
        ArrayList<Integer> res = new ArrayList<Integer>(1);
        res.add((Integer)this.taskIds.get(this.nextTaskIndex));
        this.nextTaskIndex = this.getNextTaskIndex(this.nextTaskIndex);
        return res;
    }

    private int getNextTaskIndex(int index) {
        int dupIndex = index + 1;
        if (dupIndex == this.taskIdsSize) {
            dupIndex = 0;
        }
        return dupIndex;
    }
}

