/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.common.basics.TypeUtils;
import org.apache.heron.proto.system.HeronTuples;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.simulator.grouping.Grouping;

public class TopologyManager {
    private TopologyAPI.Topology topology;
    private Map<String, List<Integer>> componentToTaskIds;
    private PhysicalPlans.PhysicalPlan physicalPlan;
    private HashMap<TopologyAPI.StreamId, List<Grouping>> streamConsumers;
    private ArrayList<Integer> spoutTasks;

    public TopologyManager(TopologyAPI.Topology topology) {
        this.topology = topology;
    }

    public TopologyAPI.Topology getTopology() {
        return this.topology;
    }

    public PhysicalPlans.PhysicalPlan getPhysicalPlan() {
        if (this.physicalPlan == null) {
            PhysicalPlans.PhysicalPlan.Builder pPlanBuilder = PhysicalPlans.PhysicalPlan.newBuilder();
            pPlanBuilder.setTopology(this.getTopology());
            PhysicalPlans.StMgr stMgr = PhysicalPlans.StMgr.newBuilder().setId("").setHostName("").setDataPort(-1).setLocalEndpoint("").setCwd("").build();
            pPlanBuilder.addStmgrs(stMgr);
            int globalTaskIndex = 1;
            for (Map.Entry<String, Integer> componentParallelism : this.getComponentParallelism().entrySet()) {
                String componentName = componentParallelism.getKey();
                int parallelism = componentParallelism.getValue();
                int componentIndex = 1;
                for (int i = 0; i < parallelism; ++i) {
                    PhysicalPlans.InstanceInfo instanceInfo = PhysicalPlans.InstanceInfo.newBuilder().setComponentName(componentName).setTaskId(globalTaskIndex).setComponentIndex(componentIndex).build();
                    PhysicalPlans.Instance instance = PhysicalPlans.Instance.newBuilder().setStmgrId("").setInstanceId(String.format("%s_%s", componentName, componentIndex)).setInfo(instanceInfo).build();
                    pPlanBuilder.addInstances(instance);
                    ++componentIndex;
                    ++globalTaskIndex;
                }
            }
            this.physicalPlan = pPlanBuilder.build();
        }
        return this.physicalPlan;
    }

    public Map<String, List<Integer>> getComponentToTaskIds() {
        if (this.componentToTaskIds == null) {
            this.componentToTaskIds = new HashMap<String, List<Integer>>();
            for (PhysicalPlans.Instance instance : this.getPhysicalPlan().getInstancesList()) {
                int taskId = instance.getInfo().getTaskId();
                String componentName = instance.getInfo().getComponentName();
                if (!this.componentToTaskIds.containsKey(componentName)) {
                    this.componentToTaskIds.put(componentName, new ArrayList());
                }
                this.componentToTaskIds.get(componentName).add(taskId);
            }
        }
        return this.componentToTaskIds;
    }

    public Duration extractTopologyTimeout() {
        for (TopologyAPI.Config.KeyValue keyValue : this.getTopology().getTopologyConfig().getKvsList()) {
            if (!keyValue.getKey().equals("topology.message.timeout.secs")) continue;
            return TypeUtils.getDuration(keyValue.getValue(), ChronoUnit.SECONDS);
        }
        throw new IllegalArgumentException("topology.message.timeout.secs does not exist");
    }

    private Map<String, Integer> getComponentParallelism() {
        String parallelism;
        String componentName;
        HashMap<String, Integer> parallelismMap = new HashMap<String, Integer>();
        for (TopologyAPI.Spout spout : this.getTopology().getSpoutsList()) {
            componentName = spout.getComp().getName();
            parallelism = TopologyManager.getConfigWithException(spout.getComp().getConfig().getKvsList(), "topology.component.parallelism").trim();
            parallelismMap.put(componentName, Integer.parseInt(parallelism));
        }
        for (TopologyAPI.Bolt bolt : this.getTopology().getBoltsList()) {
            componentName = bolt.getComp().getName();
            parallelism = TopologyManager.getConfigWithException(bolt.getComp().getConfig().getKvsList(), "topology.component.parallelism").trim();
            parallelismMap.put(componentName, Integer.parseInt(parallelism));
        }
        return parallelismMap;
    }

    public HashMap<TopologyAPI.StreamId, List<Grouping>> getStreamConsumers() {
        if (this.streamConsumers == null) {
            this.streamConsumers = new HashMap();
            HashMap<TopologyAPI.StreamId, TopologyAPI.StreamSchema> streamToSchema = new HashMap<TopologyAPI.StreamId, TopologyAPI.StreamSchema>();
            for (TopologyAPI.Spout spout : this.getTopology().getSpoutsList()) {
                for (TopologyAPI.OutputStream outputStream : spout.getOutputsList()) {
                    streamToSchema.put(outputStream.getStream(), outputStream.getSchema());
                }
            }
            for (TopologyAPI.Bolt bolt : this.getTopology().getBoltsList()) {
                for (TopologyAPI.OutputStream outputStream : bolt.getOutputsList()) {
                    streamToSchema.put(outputStream.getStream(), outputStream.getSchema());
                }
            }
            for (TopologyAPI.Bolt bolt : this.getTopology().getBoltsList()) {
                for (TopologyAPI.InputStream inputStream : bolt.getInputsList()) {
                    TopologyAPI.StreamSchema schema = (TopologyAPI.StreamSchema)streamToSchema.get(inputStream.getStream());
                    String componentName = bolt.getComp().getName();
                    List<Integer> taskIds = this.getComponentToTaskIds().get(componentName);
                    if (!this.streamConsumers.containsKey(inputStream.getStream())) {
                        this.streamConsumers.put(inputStream.getStream(), new ArrayList());
                    }
                    this.streamConsumers.get(inputStream.getStream()).add(Grouping.create(inputStream.getGtype(), inputStream, schema, taskIds));
                }
            }
        }
        return this.streamConsumers;
    }

    public List<Integer> getSpoutTasks() {
        if (this.spoutTasks == null) {
            this.spoutTasks = new ArrayList();
            for (TopologyAPI.Spout spout : this.getTopology().getSpoutsList()) {
                for (TopologyAPI.OutputStream outputStream : spout.getOutputsList()) {
                    List<Integer> spoutTaskIds = this.getComponentToTaskIds().get(outputStream.getStream().getComponentName());
                    this.spoutTasks.addAll(spoutTaskIds);
                }
            }
        }
        return this.spoutTasks;
    }

    public List<Integer> getListToSend(TopologyAPI.StreamId streamId, HeronTuples.HeronDataTuple tuple) {
        ArrayList<Integer> toReturn = new ArrayList<Integer>();
        List consumers = this.getStreamConsumers().getOrDefault(streamId, new ArrayList());
        for (Grouping consumer : consumers) {
            toReturn.addAll(consumer.getListToSend(tuple));
        }
        return toReturn;
    }

    private static String getConfigWithException(List<TopologyAPI.Config.KeyValue> config, String key) {
        for (TopologyAPI.Config.KeyValue kv : config) {
            if (!kv.getKey().equals(key)) continue;
            return kv.getValue();
        }
        throw new RuntimeException("Missing config for required key " + key);
    }
}

