/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.heron.common.basics.WakeableLooper;
import org.apache.heron.simulator.utils.RotatingMap;
import org.apache.heron.simulator.utils.TopologyManager;

public class XORManager {
    private final WakeableLooper looper;
    private final Map<Integer, RotatingMap> spoutTasksToRotatingMap;
    private final Duration rotateInterval;

    public XORManager(WakeableLooper looper, TopologyManager topologyManager, int nBuckets) {
        this.looper = looper;
        this.spoutTasksToRotatingMap = new HashMap<Integer, RotatingMap>();
        for (Integer taskId : topologyManager.getSpoutTasks()) {
            this.spoutTasksToRotatingMap.put(taskId, new RotatingMap(nBuckets));
        }
        Duration timeout = topologyManager.extractTopologyTimeout();
        this.rotateInterval = timeout.dividedBy(nBuckets).plusNanos(timeout.getNano());
        looper.registerTimerEvent(timeout, this::rotate);
    }

    public void create(int taskId, long key, long value) {
        this.spoutTasksToRotatingMap.get(taskId).create(key, value);
    }

    public boolean anchor(int taskId, long key, long value) {
        return this.spoutTasksToRotatingMap.get(taskId).anchor(key, value);
    }

    public boolean remove(int taskId, long key) {
        return this.spoutTasksToRotatingMap.get(taskId).remove(key);
    }

    protected void rotate() {
        for (RotatingMap map : this.spoutTasksToRotatingMap.values()) {
            map.rotate();
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                XORManager.this.rotate();
            }
        };
        this.looper.registerTimerEvent(this.rotateInterval, r);
    }

    protected Map<Integer, RotatingMap> getSpoutTasksToRotatingMap() {
        return this.spoutTasksToRotatingMap;
    }
}

