/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api;

import com.esotericsoftware.kryo.Serializer;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.apache.heron.api.Pair;
import org.apache.heron.api.serializer.IKryoDecorator;
import org.apache.heron.api.serializer.IKryoFactory;
import org.apache.heron.common.basics.ByteAmount;

public class Config
extends HashMap<String, Object> {
    public static final String TOPOLOGY_WORKER_CHILDOPTS = "topology.worker.childopts";
    public static final String TOPOLOGY_COMPONENT_JVMOPTS = "topology.component.jvmopts";
    public static final String TOPOLOGY_TICK_TUPLE_FREQ_MS = "topology.tick.tuple.freq.ms";
    public static final String TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS = "topology.enable.message.timeouts";
    public static final String TOPOLOGY_DEBUG = "topology.debug";
    public static final String TOPOLOGY_STMGRS = "topology.stmgrs";
    public static final String TOPOLOGY_MESSAGE_TIMEOUT_SECS = "topology.message.timeout.secs";
    public static final String TOPOLOGY_COMPONENT_PARALLELISM = "topology.component.parallelism";
    public static final String TOPOLOGY_MAX_SPOUT_PENDING = "topology.max.spout.pending";
    public static final String TOPOLOGY_AUTO_TASK_HOOKS = "topology.auto.task.hooks";
    public static final String TOPOLOGY_SERIALIZER_CLASSNAME = "topology.serializer.classname";
    public static final String HERON_JAVA_SERIALIZER_CLASS_NAME = "org.apache.heron.api.serializer.JavaSerializer";
    public static final String HERON_KRYO_SERIALIZER_CLASS_NAME = "org.apache.heron.api.serializer.KryoSerializer";
    public static final String TOPOLOGY_KRYO_FACTORY = "topology.kryo.factory";
    public static final String TOPOLOGY_KRYO_REGISTER = "topology.kryo.register";
    public static final String TOPOLOGY_KRYO_DECORATORS = "topology.kryo.decorators";
    public static final String TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS = "topology.skip.missing.kryo.registrations";
    public static final String TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION = "topology.fall.back.on.java.serialization";
    @Deprecated
    public static final String TOPOLOGY_ENABLE_ACKING = "topology.acking";
    public static final String TOPOLOGY_RELIABILITY_MODE = "topology.reliability.mode";
    public static final String TOPOLOGY_CONTAINER_CPU_REQUESTED = "topology.container.cpu";
    public static final String TOPOLOGY_CONTAINER_RAM_REQUESTED = "topology.container.ram";
    public static final String TOPOLOGY_CONTAINER_DISK_REQUESTED = "topology.container.disk";
    public static final String TOPOLOGY_CONTAINER_MAX_CPU_HINT = "topology.container.max.cpu.hint";
    public static final String TOPOLOGY_CONTAINER_MAX_RAM_HINT = "topology.container.max.ram.hint";
    public static final String TOPOLOGY_CONTAINER_MAX_DISK_HINT = "topology.container.max.disk.hint";
    public static final String TOPOLOGY_CONTAINER_MAX_NUM_INSTANCES = "topology.container.max.instances";
    public static final String TOPOLOGY_CONTAINER_PADDING_PERCENTAGE = "topology.container.padding.percentage";
    public static final String TOPOLOGY_CONTAINER_RAM_PADDING = "topology.container.ram.padding";
    public static final String TOPOLOGY_CONTAINER_CPU_PADDING = "topology.container.cpu.padding";
    public static final String TOPOLOGY_COMPONENT_CPUMAP = "topology.component.cpumap";
    public static final String TOPOLOGY_COMPONENT_RAMMAP = "topology.component.rammap";
    public static final String TOPOLOGY_COMPONENT_DISKMAP = "topology.component.diskmap";
    public static final String TOPOLOGY_PACKING_FFD_SORTING_STRATEGY = "topology.packing.ffd.sorting.strategy";
    public static final String TOPOLOGY_STATEFUL_CHECKPOINT_INTERVAL_SECONDS = "topology.stateful.checkpoint.interval.seconds";
    public static final String TOPOLOGY_STATEFUL_START_CLEAN = "topology.stateful.start.clean";
    public static final String TOPOLOGY_STATEFUL_CKPTMGR_RAM = "topology.stateful.checkpointmanager.ram";
    public static final String TOPOLOGY_STATEFUL_SPILL_STATE = "topology.stateful.spill.state";
    public static final String TOPOLOGY_STATEFUL_SPILL_STATE_LOCATION = "topology.stateful.spill.state.location";
    public static final String TOPOLOGY_STMGR_RAM = "topology.stmgr.ram";
    public static final String TOPOLOGY_METRICSMGR_RAM = "topology.metricsmgr.ram";
    public static final String TOPOLOGY_NAME = "topology.name";
    public static final String TOPOLOGY_TEAM_NAME = "topology.team.name";
    public static final String TOPOLOGY_TEAM_EMAIL = "topology.team.email";
    public static final String TOPOLOGY_TEAM_ENVIRONMENT = "topology.team.environment";
    public static final String TOPOLOGY_CAP_TICKET = "topology.cap.ticket";
    public static final String TOPOLOGY_PROJECT_NAME = "topology.project.name";
    public static final String TOPOLOGY_ADDITIONAL_CLASSPATH = "topology.additional.classpath";
    public static final String TOPOLOGY_UPDATE_DEACTIVATE_WAIT_SECS = "topology.update.deactivate.wait.secs";
    public static final String TOPOLOGY_UPDATE_REACTIVATE_WAIT_SECS = "topology.update.reactivate.wait.secs";
    public static final String TOPOLOGY_ENVIRONMENT = "topology.environment";
    public static final String TOPOLOGY_TIMER_EVENTS = "topology.timer.events";
    public static final String TOPOLOGY_REMOTE_DEBUGGING_ENABLE = "topology.remote.debugging.enable";
    public static final String TOPOLOGY_DROPTUPLES_UPON_BACKPRESSURE = "topology.droptuples.upon.backpressure";
    public static final String TOPOLOGY_COMPONENT_OUTPUT_BPS = "topology.component.output.bps";
    private static final long serialVersionUID = 2550967708478837032L;
    private static Set<String> apiVars = new HashSet<String>();

    public Config() {
    }

    public Config(Map<String, Object> map) {
        super(map);
    }

    public static void setDebug(Map<String, Object> conf, boolean isOn) {
        conf.put(TOPOLOGY_DEBUG, String.valueOf(isOn));
    }

    public static void setTeamName(Map<String, Object> conf, String teamName) {
        conf.put(TOPOLOGY_TEAM_NAME, teamName);
    }

    public static void setTeamEmail(Map<String, Object> conf, String teamEmail) {
        conf.put(TOPOLOGY_TEAM_EMAIL, teamEmail);
    }

    public static void setTopologyCapTicket(Map<String, Object> conf, String ticket) {
        conf.put(TOPOLOGY_CAP_TICKET, ticket);
    }

    public static void setTopologyProjectName(Map<String, Object> conf, String project) {
        conf.put(TOPOLOGY_PROJECT_NAME, project);
    }

    public static void setNumStmgrs(Map<String, Object> conf, int stmgrs) {
        conf.put(TOPOLOGY_STMGRS, Integer.toString(stmgrs));
    }

    public static void setSerializationClassName(Map<String, Object> conf, String className) {
        conf.put(TOPOLOGY_SERIALIZER_CLASSNAME, className);
    }

    public static void setKryoFactory(Map conf, Class<? extends IKryoFactory> klass) {
        conf.put(TOPOLOGY_KRYO_FACTORY, klass.getName());
    }

    public static void setSkipMissingKryoRegistrations(Map conf, boolean skip) {
        conf.put(TOPOLOGY_SKIP_MISSING_KRYO_REGISTRATIONS, skip);
    }

    private static List getRegisteredKryoSerializations(Map<String, Object> conf) {
        ArrayList ret = !conf.containsKey(TOPOLOGY_KRYO_REGISTER) ? new ArrayList() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_REGISTER));
        conf.put(TOPOLOGY_KRYO_REGISTER, ret);
        return ret;
    }

    public static void registerKryoSerialization(Map<String, Object> conf, Class klass) {
        Config.setSerializationClassName(conf, HERON_KRYO_SERIALIZER_CLASS_NAME);
        Config.getRegisteredKryoSerializations(conf).add(klass.getName());
    }

    public static void registerKryoSerialization(Map<String, Object> conf, Class klass, Class<? extends Serializer> serializerClass) {
        Config.setSerializationClassName(conf, HERON_KRYO_SERIALIZER_CLASS_NAME);
        HashMap<String, String> register = new HashMap<String, String>();
        register.put(klass.getName(), serializerClass.getName());
        Config.getRegisteredKryoSerializations(conf).add(register);
    }

    private static List<String> getRegisteredDecorators(Map conf) {
        ArrayList<String> ret = !conf.containsKey(TOPOLOGY_KRYO_DECORATORS) ? new ArrayList<String>() : new ArrayList((List)conf.get(TOPOLOGY_KRYO_DECORATORS));
        conf.put(TOPOLOGY_KRYO_DECORATORS, ret);
        return ret;
    }

    public static void registerDecorator(Map conf, Class<? extends IKryoDecorator> klass) {
        Config.getRegisteredDecorators(conf).add(klass.getName());
    }

    public static void setFallBackOnJavaSerialization(Map conf, boolean fallback) {
        conf.put(TOPOLOGY_FALL_BACK_ON_JAVA_SERIALIZATION, fallback);
    }

    @Deprecated
    public static void setEnableAcking(Map<String, Object> conf, boolean acking) {
        if (acking) {
            Config.setTopologyReliabilityMode(conf, TopologyReliabilityMode.ATLEAST_ONCE);
        } else {
            Config.setTopologyReliabilityMode(conf, TopologyReliabilityMode.ATMOST_ONCE);
        }
    }

    public static void setMessageTimeoutSecs(Map<String, Object> conf, int secs) {
        conf.put(TOPOLOGY_MESSAGE_TIMEOUT_SECS, Integer.toString(secs));
    }

    public static void setComponentParallelism(Map<String, Object> conf, int parallelism) {
        conf.put(TOPOLOGY_COMPONENT_PARALLELISM, Integer.toString(parallelism));
    }

    public static void setMaxSpoutPending(Map<String, Object> conf, int max) {
        conf.put(TOPOLOGY_MAX_SPOUT_PENDING, Integer.toString(max));
    }

    public static void setTickTupleFrequency(Map<String, Object> conf, int seconds) {
        Config.setTickTupleFrequencyMs(conf, seconds * 1000);
    }

    public static void setTickTupleFrequencyMs(Map<String, Object> conf, long millis) {
        conf.put(TOPOLOGY_TICK_TUPLE_FREQ_MS, millis);
    }

    public static void setTopologyReliabilityMode(Map<String, Object> conf, TopologyReliabilityMode mode) {
        conf.put(TOPOLOGY_RELIABILITY_MODE, String.valueOf((Object)mode));
    }

    public static void setContainerCpuRequested(Map<String, Object> conf, double ncpus) {
        conf.put(TOPOLOGY_CONTAINER_CPU_REQUESTED, Double.toString(ncpus));
    }

    @Deprecated
    public static void setContainerDiskRequested(Map<String, Object> conf, long nbytes) {
        Config.setContainerDiskRequested(conf, ByteAmount.fromBytes(nbytes));
    }

    public static void setContainerDiskRequested(Map<String, Object> conf, ByteAmount nbytes) {
        conf.put(TOPOLOGY_CONTAINER_DISK_REQUESTED, Long.toString(nbytes.asBytes()));
    }

    @Deprecated
    public static void setContainerRamRequested(Map<String, Object> conf, long nbytes) {
        Config.setContainerRamRequested(conf, ByteAmount.fromBytes(nbytes));
    }

    public static void setContainerRamRequested(Map<String, Object> conf, ByteAmount nbytes) {
        conf.put(TOPOLOGY_CONTAINER_RAM_REQUESTED, Long.toString(nbytes.asBytes()));
    }

    public static void setContainerMaxCpuHint(Map<String, Object> conf, double ncpus) {
        conf.put(TOPOLOGY_CONTAINER_MAX_CPU_HINT, Double.toString(ncpus));
    }

    public static void setContainerMaxDiskHint(Map<String, Object> conf, ByteAmount nbytes) {
        conf.put(TOPOLOGY_CONTAINER_MAX_DISK_HINT, Long.toString(nbytes.asBytes()));
    }

    public static void setContainerMaxRamHint(Map<String, Object> conf, ByteAmount nbytes) {
        conf.put(TOPOLOGY_CONTAINER_MAX_RAM_HINT, Long.toString(nbytes.asBytes()));
    }

    public static void setContainerPaddingPercentage(Map<String, Object> conf, int percentage) {
        conf.put(TOPOLOGY_CONTAINER_PADDING_PERCENTAGE, Integer.toString(percentage));
    }

    public static void setContainerRamPadding(Map<String, Object> conf, ByteAmount nbytes) {
        conf.put(TOPOLOGY_CONTAINER_RAM_PADDING, Long.toString(nbytes.asBytes()));
    }

    public static void setContainerCpuPadding(Map<String, Object> conf, double ncpus) {
        conf.put(TOPOLOGY_CONTAINER_CPU_PADDING, Double.toString(ncpus));
    }

    public static void setMaxNumInstancesPerContainer(Map<String, Object> conf, int n) {
        conf.put(TOPOLOGY_CONTAINER_MAX_NUM_INSTANCES, Integer.toString(n));
    }

    public static void setComponentCpuMap(Map<String, Object> conf, String cpuMap) {
        conf.put(TOPOLOGY_COMPONENT_CPUMAP, cpuMap);
    }

    public static void setComponentRamMap(Map<String, Object> conf, String ramMap) {
        conf.put(TOPOLOGY_COMPONENT_RAMMAP, ramMap);
    }

    public static void setComponentDiskMap(Map<String, Object> conf, String diskMap) {
        conf.put(TOPOLOGY_COMPONENT_DISKMAP, diskMap);
    }

    public static void setFFDSortingStrategy(Map<String, Object> conf, String sortingStrategy) {
        conf.put(TOPOLOGY_PACKING_FFD_SORTING_STRATEGY, sortingStrategy);
    }

    public static void setAutoTaskHooks(Map<String, Object> conf, List<String> hooks) {
        conf.put(TOPOLOGY_AUTO_TASK_HOOKS, hooks);
    }

    public static void setTopologyComponentOutputBPS(Map<String, Object> conf, long bps) {
        conf.put(TOPOLOGY_COMPONENT_OUTPUT_BPS, String.valueOf(bps));
    }

    public static List<String> getAutoTaskHooks(Map<String, Object> conf) {
        return (List)conf.get(TOPOLOGY_AUTO_TASK_HOOKS);
    }

    @Deprecated
    public static void setComponentRam(Map<String, Object> conf, String component, long ramInBytes) {
        Config.setComponentRam(conf, component, ByteAmount.fromBytes(ramInBytes));
    }

    public static void setComponentCpu(Map<String, Object> conf, String component, double cpu) {
        String key = TOPOLOGY_COMPONENT_CPUMAP;
        if (conf.containsKey(key)) {
            String oldEntry = (String)conf.get(key);
            String newEntry = String.format("%s,%s:%f", oldEntry, component, cpu);
            conf.put(key, newEntry);
        } else {
            String newEntry = String.format("%s:%f", component, cpu);
            conf.put(key, newEntry);
        }
    }

    public static void setComponentRam(Map<String, Object> conf, String component, ByteAmount ramInBytes) {
        String key = TOPOLOGY_COMPONENT_RAMMAP;
        if (conf.containsKey(key)) {
            String oldEntry = (String)conf.get(key);
            String newEntry = String.format("%s,%s:%d", oldEntry, component, ramInBytes.asBytes());
            conf.put(key, newEntry);
        } else {
            String newEntry = String.format("%s:%d", component, ramInBytes.asBytes());
            conf.put(key, newEntry);
        }
    }

    public static void setComponentDisk(Map<String, Object> conf, String component, ByteAmount diskInBytes) {
        String key = TOPOLOGY_COMPONENT_DISKMAP;
        if (conf.containsKey(key)) {
            String oldEntry = (String)conf.get(key);
            String newEntry = String.format("%s,%s:%d", oldEntry, component, diskInBytes.asBytes());
            conf.put(key, newEntry);
        } else {
            String newEntry = String.format("%s:%d", component, diskInBytes.asBytes());
            conf.put(key, newEntry);
        }
    }

    public static void setComponentJvmOptions(Map<String, Object> conf, String component, String jvmOptions) {
        String newEntry;
        String optsBase64 = DatatypeConverter.printBase64Binary((byte[])jvmOptions.getBytes(StandardCharsets.UTF_8));
        String componentBase64 = DatatypeConverter.printBase64Binary((byte[])component.getBytes(StandardCharsets.UTF_8));
        String oldEntry = (String)conf.get(TOPOLOGY_COMPONENT_JVMOPTS);
        if (oldEntry == null) {
            newEntry = String.format("{\"%s\":\"%s\"}", componentBase64, optsBase64);
        } else {
            oldEntry = oldEntry.substring(1, oldEntry.length() - 1);
            newEntry = String.format("{%s,\"%s\":\"%s\"}", oldEntry, componentBase64, optsBase64);
        }
        conf.put(TOPOLOGY_COMPONENT_JVMOPTS, newEntry);
    }

    public static void setTopologyStatefulCheckpointIntervalSecs(Map<String, Object> conf, int secs) {
        conf.put(TOPOLOGY_STATEFUL_CHECKPOINT_INTERVAL_SECONDS, Integer.toString(secs));
    }

    public static void setTopologyStatefulStartClean(Map<String, Object> conf, boolean clean) {
        conf.put(TOPOLOGY_STATEFUL_START_CLEAN, String.valueOf(clean));
    }

    public static void setCheckpointManagerRam(Map<String, Object> conf, ByteAmount ramInBytes) {
        conf.put(TOPOLOGY_STATEFUL_CKPTMGR_RAM, ramInBytes.asBytes());
    }

    public static void setTopologyStatefulSpillState(Map<String, Object> conf, String spillState) {
        conf.put(TOPOLOGY_STATEFUL_SPILL_STATE, spillState);
    }

    public static void setTopologyStatefulSpillStateLocation(Map<String, Object> conf, String location) {
        conf.put(TOPOLOGY_STATEFUL_SPILL_STATE_LOCATION, location);
    }

    public static void setStreamManagerRam(Map<String, Object> conf, ByteAmount ramInBytes) {
        conf.put(TOPOLOGY_STMGR_RAM, ramInBytes.asBytes());
    }

    public static void setMetricsmgrRam(Map<String, Object> conf, ByteAmount ramInBytes) {
        conf.put(TOPOLOGY_METRICSMGR_RAM, ramInBytes.asBytes());
    }

    public static void setEnvironment(Map<String, Object> conf, Map env) {
        conf.put(TOPOLOGY_ENVIRONMENT, env);
    }

    public static void registerTopologyTimerEvents(Map<String, Object> conf, String name, Duration interval, Runnable task) {
        Map timers;
        if (interval.isZero() || interval.isNegative()) {
            throw new IllegalArgumentException("Timer duration needs to be positive");
        }
        if (!conf.containsKey(TOPOLOGY_TIMER_EVENTS)) {
            conf.put(TOPOLOGY_TIMER_EVENTS, new HashMap());
        }
        if ((timers = (Map)conf.get(TOPOLOGY_TIMER_EVENTS)).containsKey(name)) {
            throw new IllegalArgumentException("Timer with name " + name + " already exists");
        }
        timers.put(name, Pair.of(interval, task));
    }

    public void setDebug(boolean isOn) {
        Config.setDebug(this, isOn);
    }

    public void setTeamName(String teamName) {
        Config.setTeamName(this, teamName);
    }

    public void setTeamEmail(String teamEmail) {
        Config.setTeamEmail(this, teamEmail);
    }

    public void setTopologyCapTicket(String ticket) {
        Config.setTopologyCapTicket(this, ticket);
    }

    public void setTopologyProjectName(String project) {
        Config.setTopologyProjectName(this, project);
    }

    public void setNumStmgrs(int stmgrs) {
        Config.setNumStmgrs(this, stmgrs);
    }

    public void setSerializationClassName(String className) {
        Config.setSerializationClassName(this, className);
    }

    public void setKryoFactory(Class<? extends IKryoFactory> klass) {
        Config.setKryoFactory(this, klass);
    }

    public void setSkipMissingKryoRegistrations(boolean skip) {
        Config.setSkipMissingKryoRegistrations(this, skip);
    }

    public void registerKryoSerialization(Class klass) {
        Config.registerKryoSerialization(this, klass);
    }

    public void registerKryoSerialization(Class klass, Class<? extends Serializer> serializerClass) {
        Config.registerKryoSerialization(this, klass, serializerClass);
    }

    public void registerDecorator(Class<? extends IKryoDecorator> klass) {
        Config.registerDecorator(this, klass);
    }

    public void setFallBackOnJavaSerialization(boolean fallback) {
        Config.setFallBackOnJavaSerialization(this, fallback);
    }

    @Deprecated
    public void setEnableAcking(boolean acking) {
        Config.setEnableAcking(this, acking);
    }

    public void setMessageTimeoutSecs(int secs) {
        Config.setMessageTimeoutSecs(this, secs);
    }

    public void setTopologyReliabilityMode(TopologyReliabilityMode mode) {
        Config.setTopologyReliabilityMode(this, mode);
    }

    public void setComponentParallelism(int parallelism) {
        Config.setComponentParallelism(this, parallelism);
    }

    public void setMaxSpoutPending(int max) {
        Config.setMaxSpoutPending(this, max);
    }

    public void setTickTupleFrequency(int seconds) {
        Config.setTickTupleFrequency(this, seconds);
    }

    public void setContainerCpuRequested(double ncpus) {
        Config.setContainerCpuRequested(this, ncpus);
    }

    public void setContainerDiskRequested(ByteAmount nbytes) {
        Config.setContainerDiskRequested((Map<String, Object>)this, nbytes);
    }

    public void setContainerRamRequested(ByteAmount nbytes) {
        Config.setContainerRamRequested((Map<String, Object>)this, nbytes);
    }

    public void setContainerMaxCpuHint(double ncpus) {
        Config.setContainerMaxCpuHint(this, ncpus);
    }

    public void setContainerMaxDiskHint(ByteAmount nbytes) {
        Config.setContainerMaxDiskHint(this, nbytes);
    }

    public void setContainerMaxRamHint(ByteAmount nbytes) {
        Config.setContainerMaxRamHint(this, nbytes);
    }

    public void setContainerPaddingPercentage(int percentage) {
        Config.setContainerPaddingPercentage(this, percentage);
    }

    public void setContainerRamPadding(ByteAmount nbytes) {
        Config.setContainerRamPadding(this, nbytes);
    }

    public void setContainerCpuPadding(double ncpus) {
        Config.setContainerCpuPadding(this, ncpus);
    }

    public void setTopologyContainerMaxNumInstances(int n) {
        Config.setMaxNumInstancesPerContainer(this, n);
    }

    public void setComponentCpuMap(String cpuMap) {
        Config.setComponentCpuMap(this, cpuMap);
    }

    public void setComponentRamMap(String ramMap) {
        Config.setComponentRamMap(this, ramMap);
    }

    public void setComponentDiskMap(String diskMap) {
        Config.setComponentDiskMap(this, diskMap);
    }

    public void setComponentCpu(String component, double cpu) {
        Config.setComponentCpu(this, component, cpu);
    }

    public void setComponentRam(String component, ByteAmount ramInBytes) {
        Config.setComponentRam((Map<String, Object>)this, component, ramInBytes);
    }

    public void setComponentDisk(String component, ByteAmount diskInBytes) {
        Config.setComponentDisk(this, component, diskInBytes);
    }

    public void setFFDSortingStrategy(String sortingStrategy) {
        Config.setFFDSortingStrategy(this, sortingStrategy);
    }

    public void setUpdateDeactivateWaitDuration(int seconds) {
        this.put(TOPOLOGY_UPDATE_DEACTIVATE_WAIT_SECS, Integer.toString(seconds));
    }

    public void setUpdateReactivateWaitDuration(int seconds) {
        this.put(TOPOLOGY_UPDATE_REACTIVATE_WAIT_SECS, Integer.toString(seconds));
    }

    public List<String> getAutoTaskHooks() {
        return Config.getAutoTaskHooks(this);
    }

    public void setAutoTaskHooks(List<String> hooks) {
        Config.setAutoTaskHooks(this, hooks);
    }

    public void addClasspath(Map<String, Object> conf, String classpath) {
        String cpKey = TOPOLOGY_ADDITIONAL_CLASSPATH;
        if (conf.containsKey(cpKey)) {
            String newEntry = String.format("%s:%s", conf.get(cpKey), classpath);
            conf.put(cpKey, newEntry);
        } else {
            conf.put(cpKey, classpath);
        }
    }

    public void setComponentJvmOptions(String component, String jvmOptions) {
        Config.setComponentJvmOptions(this, component, jvmOptions);
    }

    public Set<String> getApiVars() {
        return apiVars;
    }

    public void setTopologyStatefulCheckpointIntervalSecs(int secs) {
        Config.setTopologyStatefulCheckpointIntervalSecs(this, secs);
    }

    public void setTopologyStatefulStartClean(boolean clean) {
        Config.setTopologyStatefulStartClean(this, clean);
    }

    public void setCheckpointManagerRam(ByteAmount ramInBytes) {
        Config.setCheckpointManagerRam(this, ramInBytes);
    }

    public void setTopologyStatefulSpillState(String spillState) {
        Config.setTopologyStatefulSpillState(this, spillState);
    }

    public void setTopologyStatefulSpillStateLocation(String location) {
        Config.setTopologyStatefulSpillStateLocation(this, location);
    }

    public void setStreamManagerRam(ByteAmount ramInBytes) {
        Config.setStreamManagerRam(this, ramInBytes);
    }

    public void setMetricsmgrRam(ByteAmount ramInBytes) {
        Config.setMetricsmgrRam(this, ramInBytes);
    }

    public void registerTopologyTimerEvents(String name, Duration interval, Runnable task) {
        Config.registerTopologyTimerEvents(this, name, interval, task);
    }

    public void setTopologyRemoteDebugging(boolean isOn) {
        this.put(TOPOLOGY_REMOTE_DEBUGGING_ENABLE, String.valueOf(isOn));
    }

    public void setTopologyDropTuplesUponBackpressure(boolean dropTuples) {
        this.put(TOPOLOGY_DROPTUPLES_UPON_BACKPRESSURE, String.valueOf(dropTuples));
    }

    public void setTopologyComponentOutputBPS(long bps) {
        this.put(TOPOLOGY_COMPONENT_OUTPUT_BPS, String.valueOf(bps));
    }

    static {
        apiVars.add(TOPOLOGY_DEBUG);
        apiVars.add(TOPOLOGY_STMGRS);
        apiVars.add(TOPOLOGY_MESSAGE_TIMEOUT_SECS);
        apiVars.add(TOPOLOGY_COMPONENT_PARALLELISM);
        apiVars.add(TOPOLOGY_MAX_SPOUT_PENDING);
        apiVars.add(TOPOLOGY_WORKER_CHILDOPTS);
        apiVars.add(TOPOLOGY_COMPONENT_JVMOPTS);
        apiVars.add(TOPOLOGY_SERIALIZER_CLASSNAME);
        apiVars.add(TOPOLOGY_TICK_TUPLE_FREQ_MS);
        apiVars.add(TOPOLOGY_ENABLE_MESSAGE_TIMEOUTS);
        apiVars.add(TOPOLOGY_CONTAINER_CPU_REQUESTED);
        apiVars.add(TOPOLOGY_CONTAINER_DISK_REQUESTED);
        apiVars.add(TOPOLOGY_CONTAINER_RAM_REQUESTED);
        apiVars.add(TOPOLOGY_CONTAINER_MAX_CPU_HINT);
        apiVars.add(TOPOLOGY_CONTAINER_MAX_DISK_HINT);
        apiVars.add(TOPOLOGY_CONTAINER_MAX_RAM_HINT);
        apiVars.add(TOPOLOGY_CONTAINER_MAX_NUM_INSTANCES);
        apiVars.add(TOPOLOGY_CONTAINER_PADDING_PERCENTAGE);
        apiVars.add(TOPOLOGY_CONTAINER_RAM_PADDING);
        apiVars.add(TOPOLOGY_CONTAINER_CPU_PADDING);
        apiVars.add(TOPOLOGY_COMPONENT_CPUMAP);
        apiVars.add(TOPOLOGY_COMPONENT_RAMMAP);
        apiVars.add(TOPOLOGY_COMPONENT_DISKMAP);
        apiVars.add(TOPOLOGY_PACKING_FFD_SORTING_STRATEGY);
        apiVars.add(TOPOLOGY_STATEFUL_START_CLEAN);
        apiVars.add(TOPOLOGY_STATEFUL_CHECKPOINT_INTERVAL_SECONDS);
        apiVars.add(TOPOLOGY_STATEFUL_CKPTMGR_RAM);
        apiVars.add(TOPOLOGY_STATEFUL_SPILL_STATE);
        apiVars.add(TOPOLOGY_STATEFUL_SPILL_STATE_LOCATION);
        apiVars.add(TOPOLOGY_STMGR_RAM);
        apiVars.add(TOPOLOGY_METRICSMGR_RAM);
        apiVars.add(TOPOLOGY_RELIABILITY_MODE);
        apiVars.add(TOPOLOGY_NAME);
        apiVars.add(TOPOLOGY_TEAM_NAME);
        apiVars.add(TOPOLOGY_TEAM_EMAIL);
        apiVars.add(TOPOLOGY_CAP_TICKET);
        apiVars.add(TOPOLOGY_PROJECT_NAME);
        apiVars.add(TOPOLOGY_ADDITIONAL_CLASSPATH);
        apiVars.add(TOPOLOGY_UPDATE_DEACTIVATE_WAIT_SECS);
        apiVars.add(TOPOLOGY_UPDATE_REACTIVATE_WAIT_SECS);
        apiVars.add(TOPOLOGY_REMOTE_DEBUGGING_ENABLE);
        apiVars.add(TOPOLOGY_DROPTUPLES_UPON_BACKPRESSURE);
        apiVars.add(TOPOLOGY_COMPONENT_OUTPUT_BPS);
    }

    public static enum TopologyReliabilityMode {
        ATMOST_ONCE,
        ATLEAST_ONCE,
        EFFECTIVELY_ONCE;

    }
}

