/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.yaml.snakeyaml.Yaml;

public final class ConfigReader {
    private static final Logger LOG = Logger.getLogger(ConfigReader.class.getName());

    private ConfigReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadFile(String fileName) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (fileName == null) {
            LOG.warning("Config file name cannot be null");
            return props;
        }
        if (fileName.isEmpty()) {
            LOG.warning("Config file name is empty");
            return props;
        }
        Path path = Paths.get(fileName, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.fine("Config file " + fileName + " does not exist");
            return props;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            LOG.warning("Config file " + fileName + " might be a directory.");
            return props;
        }
        LOG.log(Level.FINE, "Reading config file {0}", fileName);
        Map<String, Object> propsYaml = null;
        try (FileInputStream fin = new FileInputStream(new File(fileName));){
            Yaml yaml = new Yaml();
            propsYaml = (Map)yaml.load(fin);
            LOG.log(Level.FINE, "Successfully read config file {0}", fileName);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to load config file: " + fileName, e);
        }
        return propsYaml != null ? propsYaml : props;
    }

    public static Map<String, Object> loadStream(InputStream inputStream) {
        LOG.fine("Reading config stream");
        Yaml yaml = new Yaml();
        Map propsYaml = (Map)yaml.load(inputStream);
        LOG.fine("Successfully read config");
        HashMap<String, Object> typedMap = new HashMap<String, Object>();
        for (Object key : propsYaml.keySet()) {
            typedMap.put(key.toString(), propsYaml.get(key));
        }
        return typedMap;
    }
}

