/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.Map;
import org.apache.heron.common.basics.ByteAmount;

public enum SystemConfigKey {
    HERON_LOGGING_DIRECTORY("heron.logging.directory", Type.STRING),
    HERON_LOGGING_MAXIMUM_SIZE_MB("heron.logging.maximum.size.mb", Type.INTEGER),
    HERON_LOGGING_MAXIMUM_FILES("heron.logging.maximum.files", Type.INTEGER),
    HERON_LOGGING_ERR_THRESHOLD("heron.logging.err.threshold", Type.INTEGER),
    HERON_METRICS_EXPORT_INTERVAL("heron.metrics.export.interval.sec", ChronoUnit.SECONDS),
    HERON_METRICS_MAX_EXCEPTIONS_PER_MESSAGE_COUNT("heron.metrics.max.exceptions.per.message.count", Integer.MAX_VALUE),
    INSTANCE_NETWORK_OPTIONS_MAXIMUM_PACKETSIZE_BYTES("heron.instance.network.options.maximum.packetsize.bytes", Type.BYTE_AMOUNT),
    INSTANCE_INTERNAL_BOLT_READ_QUEUE_CAPACITY("heron.instance.internal.bolt.read.queue.capacity", Type.INTEGER),
    INSTANCE_INTERNAL_BOLT_WRITE_QUEUE_CAPACITY("heron.instance.internal.bolt.write.queue.capacity", Type.INTEGER),
    INSTANCE_INTERNAL_SPOUT_READ_QUEUE_CAPACITY("heron.instance.internal.spout.read.queue.capacity", Type.INTEGER),
    INSTANCE_INTERNAL_SPOUT_WRITE_QUEUE_CAPACITY("heron.instance.internal.spout.write.queue.capacity", Type.INTEGER),
    INSTANCE_INTERNAL_METRICS_WRITE_QUEUE_CAPACITY("heron.instance.internal.metrics.write.queue.capacity", Type.INTEGER),
    INSTANCE_NETWORK_READ_BATCH_TIME("heron.instance.network.read.batch.time.ms", ChronoUnit.MILLIS),
    INSTANCE_NETWORK_READ_BATCH_SIZE("heron.instance.network.read.batch.size.bytes", Type.BYTE_AMOUNT),
    INSTANCE_NETWORK_WRITE_BATCH_TIME("heron.instance.network.write.batch.time.ms", ChronoUnit.MILLIS),
    INSTANCE_NETWORK_WRITE_BATCH_SIZE("heron.instance.network.write.batch.size.bytes", Type.BYTE_AMOUNT),
    INSTANCE_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE("heron.instance.network.options.socket.received.buffer.size.bytes", Type.BYTE_AMOUNT),
    INSTANCE_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE("heron.instance.network.options.socket.send.buffer.size.bytes", Type.BYTE_AMOUNT),
    INSTANCE_SET_DATA_TUPLE_CAPACITY("heron.instance.set.data.tuple.capacity", Type.INTEGER),
    INSTANCE_SET_DATA_TUPLE_SIZE("heron.instance.set.data.tuple.size.bytes", ByteAmount.fromBytes(Long.MAX_VALUE)),
    INSTANCE_SET_CONTROL_TUPLE_CAPACITY("heron.instance.set.control.tuple.capacity", Type.INTEGER),
    INSTANCE_ACK_BATCH_TIME("heron.instance.ack.batch.time.ms", ChronoUnit.MILLIS),
    INSTANCE_EMIT_BATCH_TIME("heron.instance.emit.batch.time.ms", ChronoUnit.MILLIS),
    INSTANCE_EMIT_BATCH_SIZE("heron.instance.emit.batch.size.bytes", Type.BYTE_AMOUNT),
    INSTANCE_EXECUTE_BATCH_TIME("heron.instance.execute.batch.time.ms", ChronoUnit.MILLIS),
    INSTANCE_EXECUTE_BATCH_SIZE("heron.instance.execute.batch.size.bytes", Type.BYTE_AMOUNT),
    INSTANCE_FORCE_EXIT_TIMEOUT("heron.instance.force.exit.timeout.ms", ChronoUnit.MILLIS),
    INSTANCE_RECONNECT_STREAMMGR_INTERVAL("heron.instance.reconnect.streammgr.interval.sec", ChronoUnit.SECONDS),
    INSTANCE_RECONNECT_METRICSMGR_INTERVAL("heron.instance.reconnect.metricsmgr.interval.sec", ChronoUnit.SECONDS),
    INSTANCE_METRICS_SYSTEM_SAMPLE_INTERVAL("heron.instance.metrics.system.sample.interval.sec", ChronoUnit.SECONDS),
    INSTANCE_ACKNOWLEDGEMENT_NBUCKETS("heron.instance.acknowledgement.nbuckets", Type.INTEGER),
    INSTANCE_TUNING_EXPECTED_BOLT_READ_QUEUE_SIZE("heron.instance.tuning.expected.bolt.read.queue.size", Type.INTEGER),
    INSTANCE_TUNING_EXPECTED_BOLT_WRITE_QUEUE_SIZE("heron.instance.tuning.expected.bolt.write.queue.size", Type.INTEGER),
    INSTANCE_TUNING_EXPECTED_SPOUT_READ_QUEUE_SIZE("heron.instance.tuning.expected.spout.read.queue.size", Type.INTEGER),
    INSTANCE_TUNING_EXPECTED_SPOUT_WRITE_QUEUE_SIZE("heron.instance.tuning.expected.spout.write.queue.size", Type.INTEGER),
    INSTANCE_TUNING_EXPECTED_METRICS_WRITE_QUEUE_SIZE("heron.instance.tuning.expected.metrics.write.queue.size", Type.INTEGER),
    INSTANCE_TUNING_CURRENT_SAMPLE_WEIGHT("heron.instance.tuning.current.sample.weight", Type.DOUBLE),
    INSTANCE_TUNING_INTERVAL("heron.instance.tuning.interval.ms", ChronoUnit.MILLIS),
    METRICSMGR_NETWORK_READ_BATCH_TIME("heron.metricsmgr.network.read.batch.time.ms", ChronoUnit.MILLIS),
    METRICSMGR_NETWORK_READ_BATCH_SIZE("heron.metricsmgr.network.read.batch.size.bytes", Type.BYTE_AMOUNT),
    METRICSMGR_NETWORK_WRITE_BATCH_TIME("heron.metricsmgr.network.write.batch.time.ms", ChronoUnit.MILLIS),
    METRICSMGR_NETWORK_WRITE_BATCH_SIZE("heron.metricsmgr.network.write.batch.size.bytes", Type.BYTE_AMOUNT),
    METRICSMGR_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE("heron.metricsmgr.network.options.socket.received.buffer.size.bytes", Type.BYTE_AMOUNT),
    METRICSMGR_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE("heron.metricsmgr.network.options.socket.send.buffer.size.bytes", Type.BYTE_AMOUNT),
    METRICSMGR_NETWORK_OPTIONS_MAXIMUM_PACKETSIZE_BYTES("heron.metricsmgr.network.options.maximum.packetsize.bytes", Type.BYTE_AMOUNT),
    TMASTER_METRICS_COLLECTOR_MAXIMUM_EXCEPTION("heron.tmaster.metrics.collector.maximum.exception", Type.LONG),
    TMASTER_METRICS_COLLECTOR_MAXIMUM_INTERVAL("heron.tmaster.metrics.collector.maximum.interval.min", ChronoUnit.MINUTES, Duration.ofHours(3L)),
    TMASTER_METRICS_COLLECTOR_PURGE_INTERVAL("heron.tmaster.metrics.collector.purge.interval.sec", ChronoUnit.SECONDS, Duration.ofMinutes(1L));

    private final String value;
    private final Object defaultValue;
    private final Type type;
    private final TemporalUnit temporalUnit;
    private static final Map<String, SystemConfigKey> VALUE_MAP;

    private SystemConfigKey(String value, Type type) {
        if (type == Type.DURATION) {
            throw new IllegalArgumentException("DURATION types are created by passing a temporalUnit");
        }
        this.value = value;
        this.type = type;
        this.defaultValue = null;
        this.temporalUnit = null;
    }

    private SystemConfigKey(String value, TemporalUnit temporalUnit) {
        this(value, temporalUnit, null);
    }

    private SystemConfigKey(String value, String defaultValue) {
        this.value = value;
        this.type = Type.STRING;
        this.defaultValue = defaultValue;
        this.temporalUnit = null;
    }

    private SystemConfigKey(String value, Integer defaultValue) {
        this.value = value;
        this.type = Type.INTEGER;
        this.defaultValue = defaultValue;
        this.temporalUnit = null;
    }

    private SystemConfigKey(String value, Long defaultValue) {
        this.value = value;
        this.type = Type.LONG;
        this.defaultValue = defaultValue;
        this.temporalUnit = null;
    }

    private SystemConfigKey(String value, Double defaultValue) {
        this.value = value;
        this.type = Type.DOUBLE;
        this.defaultValue = defaultValue;
        this.temporalUnit = null;
    }

    private SystemConfigKey(String value, TemporalUnit temporalUnit, Duration defaultValue) {
        this.value = value;
        this.type = Type.DURATION;
        this.defaultValue = defaultValue;
        this.temporalUnit = temporalUnit;
    }

    private SystemConfigKey(String value, Boolean defaultValue) {
        this.value = value;
        this.type = Type.BOOLEAN;
        this.defaultValue = defaultValue;
        this.temporalUnit = null;
    }

    private SystemConfigKey(String value, ByteAmount defaultValue) {
        this.value = value;
        this.type = Type.BYTE_AMOUNT;
        this.defaultValue = defaultValue;
        this.temporalUnit = null;
    }

    static SystemConfigKey toSystemConfigKey(String value) {
        return VALUE_MAP.get(value);
    }

    String value() {
        return this.value;
    }

    Type getType() {
        return this.type;
    }

    TemporalUnit getTemporalUnit() {
        return this.temporalUnit;
    }

    Object getDefault() {
        return this.defaultValue;
    }

    public String getDefaultString() {
        if (this.type != Type.STRING) {
            throw new IllegalAccessError(String.format("Config Key %s is type %s, getDefaultString() not supported", new Object[]{this.name(), this.type}));
        }
        return (String)this.defaultValue;
    }

    static {
        VALUE_MAP = new HashMap<String, SystemConfigKey>();
        for (SystemConfigKey key : SystemConfigKey.values()) {
            VALUE_MAP.put(key.value(), key);
        }
    }

    public static enum Type {
        BOOLEAN,
        BYTE_AMOUNT,
        DOUBLE,
        DURATION,
        INTEGER,
        LONG,
        STRING;

    }
}

