/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.common.basics.ISelectHandler;
import org.apache.heron.common.basics.NIOLooper;
import org.apache.heron.common.network.HeronSocketOptions;
import org.apache.heron.common.network.IncomingPacket;
import org.apache.heron.common.network.OutgoingPacket;
import org.apache.heron.common.network.REQID;
import org.apache.heron.common.network.SocketChannelHelper;
import org.apache.heron.shaded.com.google.protobuf.Message;

public abstract class HeronServer
implements ISelectHandler {
    private static final Logger LOG = Logger.getLogger(HeronServer.class.getName());
    private ServerSocketChannel acceptChannel;
    private InetSocketAddress endpoint;
    private HeronSocketOptions socketOptions;
    private NIOLooper nioLooper;
    private Map<SocketChannel, SocketChannelHelper> activeConnections;
    private Map<String, Message.Builder> requestMap;
    private Map<String, Message.Builder> messageMap;

    public HeronServer(NIOLooper s, String host, int port, HeronSocketOptions options) {
        this.nioLooper = s;
        this.endpoint = new InetSocketAddress(host, port);
        this.socketOptions = options;
        this.requestMap = new HashMap<String, Message.Builder>();
        this.messageMap = new HashMap<String, Message.Builder>();
        this.activeConnections = new HashMap<SocketChannel, SocketChannelHelper>();
    }

    public InetSocketAddress getEndpoint() {
        return this.endpoint;
    }

    public void registerOnMessage(Message.Builder builder) {
        this.messageMap.put(builder.getDescriptorForType().getFullName(), builder);
    }

    public void registerOnRequest(Message.Builder builder) {
        this.requestMap.put(builder.getDescriptorForType().getFullName(), builder);
    }

    public boolean start() {
        try {
            this.acceptChannel = ServerSocketChannel.open();
            this.acceptChannel.configureBlocking(false);
            this.acceptChannel.socket().bind(this.endpoint);
            this.nioLooper.registerAccept(this.acceptChannel, this);
            return true;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to start server", e);
            return false;
        }
    }

    public void stop() {
        if (this.acceptChannel == null || !this.acceptChannel.isOpen()) {
            LOG.info("Fail to stop server; not yet open.");
            return;
        }
        for (Map.Entry<SocketChannel, SocketChannelHelper> connections : this.activeConnections.entrySet()) {
            SocketChannel channel = connections.getKey();
            SocketAddress channelAddress = channel.socket().getRemoteSocketAddress();
            LOG.info("Closing connected channel from client: " + channelAddress);
            LOG.info("Removing all interest on channel: " + channelAddress);
            this.nioLooper.removeAllInterest(channel);
            this.onClose(channel);
            connections.getValue().clear();
        }
        this.activeConnections.clear();
        this.requestMap.clear();
        this.messageMap.clear();
        try {
            this.acceptChannel.close();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to close server", e);
        }
    }

    @Override
    public void handleAccept(SelectableChannel channel) {
        try {
            SocketChannel socketChannel = this.acceptChannel.accept();
            if (socketChannel != null) {
                socketChannel.configureBlocking(false);
                socketChannel.socket().setSendBufferSize((int)this.socketOptions.getSocketSendBufferSize().asBytes());
                socketChannel.socket().setReceiveBufferSize((int)this.socketOptions.getSocketReceivedBufferSize().asBytes());
                socketChannel.socket().setTcpNoDelay(true);
                SocketChannelHelper helper = new SocketChannelHelper(this.nioLooper, this, socketChannel, this.socketOptions);
                this.activeConnections.put(socketChannel, helper);
                this.onConnect(socketChannel);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error while accepting a new connection ", e);
        }
    }

    @Override
    public void handleRead(SelectableChannel channel) {
        SocketChannelHelper helper = this.activeConnections.get(channel);
        if (helper == null) {
            LOG.severe("Unknown connection is ready for read");
            return;
        }
        List<IncomingPacket> packets = helper.read();
        for (IncomingPacket ipt : packets) {
            this.handlePacket(channel, ipt);
        }
    }

    @Override
    public void handleWrite(SelectableChannel channel) {
        SocketChannelHelper helper = this.activeConnections.get(channel);
        if (helper == null) {
            LOG.severe("Unknown connection is ready for read");
            return;
        }
        helper.write();
    }

    @Override
    public void handleConnect(SelectableChannel channel) {
        throw new RuntimeException("Server cannot have handleConnect");
    }

    private void handlePacket(SelectableChannel channel, IncomingPacket incomingPacket) {
        String typeName = incomingPacket.unpackString();
        REQID rid = incomingPacket.unpackREQID();
        Message.Builder bldr = this.requestMap.get(typeName);
        boolean isRequest = false;
        if (bldr != null) {
            isRequest = true;
        } else {
            bldr = this.messageMap.get(typeName);
        }
        if (bldr != null) {
            bldr.clear();
            incomingPacket.unpackMessage(bldr);
            if (bldr.isInitialized()) {
                Message msg = bldr.build();
                if (isRequest) {
                    this.onRequest(rid, (SocketChannel)channel, msg);
                } else {
                    this.onMessage((SocketChannel)channel, msg);
                }
            } else {
                LOG.severe("Could not deserialize protobuf of type " + typeName);
                this.handleError(channel);
            }
            return;
        }
        LOG.severe("Unexpected protobuf type received " + typeName);
        this.handleError(channel);
    }

    @Override
    public void handleError(SelectableChannel channel) {
        SocketAddress channelAddress = ((SocketChannel)channel).socket().getRemoteSocketAddress();
        LOG.info("Handling error from channel: " + channelAddress);
        SocketChannelHelper helper = this.activeConnections.get(channel);
        if (helper == null) {
            LOG.severe("Inactive channel had error?");
            return;
        }
        helper.clear();
        LOG.info("Removing all interest on channel: " + channelAddress);
        this.nioLooper.removeAllInterest(channel);
        try {
            channel.close();
        }
        catch (IOException e) {
            LOG.severe("Error closing connection in handleError");
        }
        this.activeConnections.remove(channel);
        this.onClose((SocketChannel)channel);
    }

    public boolean sendResponse(REQID rid, SocketChannel channel, Message response) {
        SocketChannelHelper helper = this.activeConnections.get(channel);
        if (helper == null) {
            LOG.severe("Trying to send a response on an unknown connection");
            return false;
        }
        OutgoingPacket opk = new OutgoingPacket(rid, response);
        helper.sendPacket(opk);
        return true;
    }

    public boolean sendMessage(SocketChannel channel, Message message) {
        return this.sendResponse(REQID.zeroREQID, channel, message);
    }

    public NIOLooper getNIOLooper() {
        return this.nioLooper;
    }

    public void registerTimerEvent(Duration timer, Runnable task) {
        this.nioLooper.registerTimerEvent(timer, task);
    }

    public abstract void onConnect(SocketChannel var1);

    public abstract void onRequest(REQID var1, SocketChannel var2, Message var3);

    public abstract void onMessage(SocketChannel var1, Message var2);

    public abstract void onClose(SocketChannel var1);

    public Map<String, Message.Builder> getMessageMap() {
        return this.messageMap;
    }

    public Map<String, Message.Builder> getRequestMap() {
        return this.requestMap;
    }

    public ServerSocketChannel getAcceptChannel() {
        return this.acceptChannel;
    }

    public Map<SocketChannel, SocketChannelHelper> getActiveConnections() {
        return this.activeConnections;
    }
}

