/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.common.network.REQID;
import org.apache.heron.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.heron.shaded.com.google.protobuf.Message;

public class IncomingPacket {
    private static final Logger LOG = Logger.getLogger(IncomingPacket.class.getName());
    private ByteBuffer header = ByteBuffer.allocate(4);
    private ByteBuffer data;
    private boolean headerRead = false;

    public int readFromChannel(SocketChannel channel) {
        return this.readFromChannel(channel, Integer.MAX_VALUE);
    }

    public int readFromChannel(SocketChannel channel, long limit) {
        int retval;
        if (!this.headerRead) {
            retval = this.readFromChannel(channel, this.header);
            if (retval != 0) {
                return retval;
            }
            this.headerRead = true;
            this.header.flip();
            int size = this.header.getInt();
            if ((long)size > limit) {
                LOG.log(Level.SEVERE, "packet size " + size + " exceeds limit " + limit);
                return -1;
            }
            this.data = ByteBuffer.allocate(size);
        }
        if ((retval = this.readFromChannel(channel, this.data)) == 0) {
            this.data.flip();
        }
        return retval;
    }

    private int readFromChannel(SocketChannel channel, ByteBuffer buffer) {
        int remaining = buffer.remaining();
        int wrote = 0;
        try {
            wrote = channel.read(buffer);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error in channel.read ", e);
            return -1;
        }
        if (wrote < 0) {
            LOG.severe("channel.read returned negative " + wrote);
            return wrote;
        }
        return remaining - wrote;
    }

    public String unpackString() {
        int size = this.data.getInt();
        byte[] bytes = new byte[size];
        this.data.get(bytes);
        return new String(bytes);
    }

    public REQID unpackREQID() {
        return new REQID(this.data);
    }

    public void unpackMessage(Message.Builder builder) {
        int size = this.data.getInt();
        byte[] bytes = new byte[size];
        this.data.get(bytes);
        try {
            builder.mergeFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.log(Level.SEVERE, "InvalidProtocolBufferException: ", e);
        }
    }

    public int size() {
        return this.data == null ? 0 : this.data.capacity();
    }
}

