/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.common.network.REQID;
import org.apache.heron.shaded.com.google.protobuf.Message;

public class OutgoingPacket {
    private static final Logger LOG = Logger.getLogger(OutgoingPacket.class.getName());
    private ByteBuffer buffer;

    public OutgoingPacket(REQID reqid, Message message) {
        assert (message.isInitialized());
        int headerSize = 4;
        String typename = message.getDescriptorForType().getFullName();
        int dataSize = OutgoingPacket.sizeRequiredToPackString(typename) + 32 + OutgoingPacket.sizeRequiredToPackMessage(message);
        this.buffer = ByteBuffer.allocate(headerSize + dataSize);
        this.buffer.putInt(dataSize);
        this.buffer.putInt(typename.length());
        this.buffer.put(typename.getBytes());
        reqid.pack(this.buffer);
        this.buffer.putInt(message.getSerializedSize());
        this.buffer.put(message.toByteArray());
        this.buffer.flip();
    }

    public static int sizeRequiredToPackString(String str) {
        return 4 + str.length();
    }

    public static int sizeRequiredToPackMessage(Message msg) {
        return 4 + msg.getSerializedSize();
    }

    public int writeToChannel(SocketChannel channel) {
        int remaining = this.buffer.remaining();
        assert (remaining > 0);
        int wrote = 0;
        try {
            wrote = channel.write(this.buffer);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error writing to channel ", e);
            return -1;
        }
        return remaining - wrote;
    }

    public int size() {
        return this.buffer.capacity();
    }
}

