/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.metrics;

import java.util.List;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.metric.CountMetric;
import org.apache.heron.api.metric.CumulativeCountMetric;
import org.apache.heron.api.metric.MeanReducer;
import org.apache.heron.api.metric.MeanReducerState;
import org.apache.heron.api.metric.MultiCountMetric;
import org.apache.heron.api.metric.MultiReducedMetric;
import org.apache.heron.common.basics.SingletonRegistry;
import org.apache.heron.common.config.SystemConfig;
import org.apache.heron.common.utils.metrics.IBoltMetrics;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.common.utils.topology.TopologyContextImpl;

public class FullBoltMetrics
implements IBoltMetrics {
    private final MultiCountMetric ackCount = new MultiCountMetric();
    private final MultiReducedMetric<MeanReducerState, Number, Double> processLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiReducedMetric<MeanReducerState, Number, Double> failLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiCountMetric failCount = new MultiCountMetric();
    private final MultiCountMetric executeCount = new MultiCountMetric();
    private final MultiReducedMetric<MeanReducerState, Number, Double> executeLatency = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    private final MultiCountMetric executeTimeNs = new MultiCountMetric();
    private final MultiCountMetric emitCount = new MultiCountMetric();
    private final CountMetric tupleAddedToQueue;
    private final MultiCountMetric totalDeserializationTimeNs;
    private final MultiCountMetric totalSerializationTimeNs;
    private final MultiReducedMetric<MeanReducerState, Number, Double> averageSerializationTimeNs;
    private final MultiReducedMetric<MeanReducerState, Number, Double> averageDeserializationTimeNs;
    private final CountMetric outQueueFullCount = new CountMetric();
    private CumulativeCountMetric taskRunCount;
    private CumulativeCountMetric executionCount;
    private CumulativeCountMetric continueWorkCount;

    public FullBoltMetrics() {
        this.tupleAddedToQueue = new CountMetric();
        this.taskRunCount = new CumulativeCountMetric();
        this.executionCount = new CumulativeCountMetric();
        this.continueWorkCount = new CumulativeCountMetric();
        this.totalDeserializationTimeNs = new MultiCountMetric();
        this.totalSerializationTimeNs = new MultiCountMetric();
        this.averageSerializationTimeNs = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
        this.averageDeserializationTimeNs = new MultiReducedMetric<MeanReducerState, Number, Double>(new MeanReducer());
    }

    @Override
    public void registerMetrics(TopologyContextImpl topologyContext) {
        SystemConfig systemConfig = (SystemConfig)SingletonRegistry.INSTANCE.getSingleton(SystemConfig.HERON_SYSTEM_CONFIG);
        int interval = (int)systemConfig.getHeronMetricsExportInterval().getSeconds();
        topologyContext.registerMetric("__ack-count", this.ackCount, interval);
        topologyContext.registerMetric("__process-latency", this.processLatency, interval);
        topologyContext.registerMetric("__fail-latency", this.failLatency, interval);
        topologyContext.registerMetric("__fail-count", this.failCount, interval);
        topologyContext.registerMetric("__execute-count", this.executeCount, interval);
        topologyContext.registerMetric("__execute-latency", this.executeLatency, interval);
        topologyContext.registerMetric("__execute-time-ns", this.executeTimeNs, interval);
        topologyContext.registerMetric("__emit-count", this.emitCount, interval);
        topologyContext.registerMetric("__out-queue-full-count", this.outQueueFullCount, interval);
        topologyContext.registerMetric("__task-run-count", this.taskRunCount, interval);
        topologyContext.registerMetric("__execution-count", this.executionCount, interval);
        topologyContext.registerMetric("__continue-work-count", this.continueWorkCount, interval);
        topologyContext.registerMetric("__tuple-deserialization-time-ns", this.totalDeserializationTimeNs, interval);
        topologyContext.registerMetric("__tuple-serialization-time-ns", this.totalSerializationTimeNs, interval);
        topologyContext.registerMetric("__av-tuple-deserialization-time-ns", this.totalDeserializationTimeNs, interval);
        topologyContext.registerMetric("__av-tuple-serialization-time-ns", this.totalSerializationTimeNs, interval);
        topologyContext.registerMetric("__data-tuple-added-to-outgoing-queue/default", this.tupleAddedToQueue, interval);
    }

    @Override
    public void initMultiCountMetrics(PhysicalPlanHelper helper) {
        List<TopologyAPI.InputStream> inputs = helper.getMyBolt().getInputsList();
        for (TopologyAPI.InputStream inputStream : inputs) {
            String streamId = inputStream.getStream().getId();
            String globalStreamId = inputStream.getStream().getComponentName() + "/" + streamId;
            this.ackCount.scope(streamId);
            this.failCount.scope(streamId);
            this.executeCount.scope(streamId);
            this.executeTimeNs.scope(streamId);
            this.ackCount.scope(globalStreamId);
            this.failCount.scope(globalStreamId);
            this.executeCount.scope(globalStreamId);
            this.executeTimeNs.scope(globalStreamId);
        }
        List<TopologyAPI.OutputStream> outputs = helper.getMyBolt().getOutputsList();
        for (TopologyAPI.OutputStream outputStream : outputs) {
            String streamId = outputStream.getStream().getId();
            this.emitCount.scope(streamId);
        }
    }

    @Override
    public void ackedTuple(String streamId, String sourceComponent, long latency) {
        this.ackCount.scope(streamId).incr();
        this.processLatency.scope(streamId).update(latency);
        String globalStreamId = sourceComponent + "/" + streamId;
        this.ackCount.scope(globalStreamId).incr();
        this.processLatency.scope(globalStreamId).update(latency);
    }

    @Override
    public void failedTuple(String streamId, String sourceComponent, long latency) {
        this.failCount.scope(streamId).incr();
        this.failLatency.scope(streamId).update(latency);
        String globalStreamId = sourceComponent + "/" + streamId;
        this.failCount.scope(globalStreamId).incr();
        this.failLatency.scope(globalStreamId).update(latency);
    }

    @Override
    public void executeTuple(String streamId, String sourceComponent, long latency) {
        this.executeCount.scope(streamId).incr();
        this.executeLatency.scope(streamId).update(latency);
        this.executeTimeNs.scope(streamId).incrBy(latency);
        String globalStreamId = sourceComponent + "/" + streamId;
        this.executeCount.scope(globalStreamId).incr();
        this.executeLatency.scope(globalStreamId).update(latency);
        this.executeTimeNs.scope(globalStreamId).incrBy(latency);
    }

    @Override
    public void emittedTuple(String streamId) {
        this.emitCount.scope(streamId).incr();
    }

    @Override
    public void addTupleToQueue(int size) {
        this.tupleAddedToQueue.incr();
    }

    @Override
    public void updateOutQueueFullCount() {
        this.outQueueFullCount.incr();
    }

    @Override
    public void deserializeDataTuple(String streamId, String sourceComponent, long latency) {
        this.totalDeserializationTimeNs.scope(streamId).incrBy(latency);
        this.averageDeserializationTimeNs.scope(streamId).update(latency);
        String globalStreamId = sourceComponent + "/" + streamId;
        this.totalDeserializationTimeNs.scope(globalStreamId).incrBy(latency);
        this.averageDeserializationTimeNs.scope(globalStreamId).update(latency);
    }

    @Override
    public void serializeDataTuple(String streamId, long latency) {
        this.totalSerializationTimeNs.scope(streamId).incrBy(latency);
        this.averageSerializationTimeNs.scope(streamId).update(latency);
    }

    @Override
    public void updateTaskRunCount() {
        this.taskRunCount.incr();
    }

    @Override
    public void updateExecutionCount() {
        this.executionCount.incr();
    }

    @Override
    public void updateContinueWorkCount() {
        this.continueWorkCount.incr();
    }
}

