/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.misc;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.serializer.IPluggableSerializer;
import org.apache.heron.api.serializer.JavaSerializer;

public final class SerializeDeSerializeHelper {
    private static final Logger LOG = Logger.getLogger(SerializeDeSerializeHelper.class.getName());

    private SerializeDeSerializeHelper() {
    }

    public static IPluggableSerializer getSerializer(Map<String, Object> config) {
        try {
            IPluggableSerializer serializer;
            String serializerClassName = (String)config.get("topology.serializer.classname");
            if (serializerClassName == null) {
                LOG.log(Level.WARNING, "Serializer class name not provided. Fall back to Java serializer. This could cause serious performance degradation. You can specify to use Kryo as serializer. See https://apache.github.io/incubator-heron/docs/developers/serialization/ for details");
                serializer = new JavaSerializer();
            } else {
                serializer = (IPluggableSerializer)Class.forName(serializerClassName).newInstance();
            }
            serializer.initialize(config);
            return serializer;
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Serializer class must be in class path " + ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Serializer class must be concrete and have a nullary constructor " + ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Serializer class constructor must be public " + ex);
        }
    }
}

