/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.instance;

import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.proto.ckptmgr.CheckpointManager;

public final class InstanceControlMsg {
    private PhysicalPlanHelper newPhysicalPlanHelper;
    private CheckpointManager.RestoreInstanceStateRequest restoreInstanceStateRequest;
    private CheckpointManager.StartInstanceStatefulProcessing startInstanceStatefulProcessing;

    private InstanceControlMsg(Builder builder) {
        this.newPhysicalPlanHelper = builder.newPhysicalPlanHelper;
        this.restoreInstanceStateRequest = builder.restoreInstanceStateRequest;
        this.startInstanceStatefulProcessing = builder.startInstanceStatefulProcessing;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public PhysicalPlanHelper getNewPhysicalPlanHelper() {
        return this.newPhysicalPlanHelper;
    }

    public boolean isNewPhysicalPlanHelper() {
        return this.newPhysicalPlanHelper != null;
    }

    public CheckpointManager.RestoreInstanceStateRequest getRestoreInstanceStateRequest() {
        return this.restoreInstanceStateRequest;
    }

    public boolean isRestoreInstanceStateRequest() {
        return this.restoreInstanceStateRequest != null;
    }

    public CheckpointManager.StartInstanceStatefulProcessing getStartInstanceStatefulProcessing() {
        return this.startInstanceStatefulProcessing;
    }

    public boolean isStartInstanceStatefulProcessing() {
        return this.startInstanceStatefulProcessing != null;
    }

    public static final class Builder {
        private PhysicalPlanHelper newPhysicalPlanHelper;
        private CheckpointManager.RestoreInstanceStateRequest restoreInstanceStateRequest;
        private CheckpointManager.StartInstanceStatefulProcessing startInstanceStatefulProcessing;

        private Builder() {
        }

        public Builder setNewPhysicalPlanHelper(PhysicalPlanHelper physicalPlanHelper) {
            this.newPhysicalPlanHelper = physicalPlanHelper;
            return this;
        }

        public Builder setRestoreInstanceStateRequest(CheckpointManager.RestoreInstanceStateRequest request) {
            this.restoreInstanceStateRequest = request;
            return this;
        }

        public Builder setStartInstanceStatefulProcessing(CheckpointManager.StartInstanceStatefulProcessing request) {
            this.startInstanceStatefulProcessing = request;
            return this;
        }

        public InstanceControlMsg build() {
            return new InstanceControlMsg(this);
        }
    }
}

