/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.topology;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.topology.GeneralTopologyContext;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.common.basics.TypeUtils;

public class GeneralTopologyContextImpl
implements GeneralTopologyContext {
    private final TopologyAPI.Topology topology;
    private final Map<String, Object> topologyConfig;
    private final Map<Integer, String> taskToComponentMap;
    private final Map<String, List<TopologyAPI.InputStream>> inputs;
    private final Map<String, List<TopologyAPI.OutputStream>> outputs;
    private final Map<String, Map<String, Fields>> componentsOutputFields;

    public GeneralTopologyContextImpl(Map<String, Object> clusterConfig, TopologyAPI.Topology topology, Map<Integer, String> taskToComponentMap) {
        int i;
        this.topology = topology;
        this.topologyConfig = new HashMap<String, Object>(clusterConfig);
        this.taskToComponentMap = taskToComponentMap;
        this.inputs = new ConcurrentHashMap<String, List<TopologyAPI.InputStream>>();
        this.outputs = new ConcurrentHashMap<String, List<TopologyAPI.OutputStream>>();
        this.componentsOutputFields = new HashMap<String, Map<String, Fields>>();
        for (i = 0; i < this.topology.getSpoutsCount(); ++i) {
            TopologyAPI.Spout spout = this.topology.getSpouts(i);
            this.inputs.put(spout.getComp().getName(), new LinkedList());
            this.outputs.put(spout.getComp().getName(), spout.getOutputsList());
            this.componentsOutputFields.putAll(GeneralTopologyContextImpl.getOutputToComponentsFields(spout.getOutputsList()));
        }
        for (i = 0; i < this.topology.getBoltsCount(); ++i) {
            TopologyAPI.Bolt bolt = this.topology.getBolts(i);
            this.inputs.put(bolt.getComp().getName(), bolt.getInputsList());
            this.outputs.put(bolt.getComp().getName(), bolt.getOutputsList());
            this.componentsOutputFields.putAll(GeneralTopologyContextImpl.getOutputToComponentsFields(bolt.getOutputsList()));
        }
    }

    public static Map<String, Map<String, Fields>> getOutputToComponentsFields(List<TopologyAPI.OutputStream> outputs) {
        HashMap<String, Map<String, Fields>> outputFields = new HashMap<String, Map<String, Fields>>();
        for (TopologyAPI.OutputStream outputStream : outputs) {
            String componentName = outputStream.getStream().getComponentName();
            String streamId = outputStream.getStream().getId();
            HashMap<String, Fields> componentFields = (HashMap<String, Fields>)outputFields.get(componentName);
            if (componentFields == null) {
                componentFields = new HashMap<String, Fields>();
            }
            ArrayList<String> retval = new ArrayList<String>();
            for (TopologyAPI.StreamSchema.KeyType kt : outputStream.getSchema().getKeysList()) {
                retval.add(kt.getKey());
            }
            componentFields.put(streamId, new Fields(retval));
            outputFields.put(componentName, componentFields);
        }
        return outputFields;
    }

    public Map<String, Object> getTopologyConfig() {
        return this.topologyConfig;
    }

    @Override
    public String getTopologyId() {
        return this.topology.getId();
    }

    @Override
    public TopologyAPI.Topology getRawTopology() {
        return this.topology;
    }

    @Override
    public String getComponentId(int taskId) {
        if (this.taskToComponentMap.containsKey(taskId)) {
            return this.taskToComponentMap.get(taskId);
        }
        return null;
    }

    @Override
    public Set<String> getComponentStreams(String componentId) {
        if (this.outputs.containsKey(componentId)) {
            HashSet<String> streams = new HashSet<String>();
            List<TopologyAPI.OutputStream> olist = this.outputs.get(componentId);
            for (TopologyAPI.OutputStream ostream : olist) {
                streams.add(ostream.getStream().getId());
            }
            return streams;
        }
        return null;
    }

    @Override
    public List<Integer> getComponentTasks(String componentId) {
        LinkedList<Integer> retVal = new LinkedList<Integer>();
        for (Map.Entry<Integer, String> entry : this.taskToComponentMap.entrySet()) {
            if (!entry.getValue().equals(componentId)) continue;
            retVal.add(entry.getKey());
        }
        return retVal;
    }

    @Override
    public Fields getComponentOutputFields(String componentId, String streamId) {
        Map<String, Fields> componentFields = this.componentsOutputFields.get(componentId);
        if (componentFields != null) {
            return componentFields.get(streamId);
        }
        return null;
    }

    @Override
    public Map<TopologyAPI.StreamId, TopologyAPI.Grouping> getSources(String componentId) {
        if (this.inputs.containsKey(componentId)) {
            HashMap<TopologyAPI.StreamId, TopologyAPI.Grouping> retVal = new HashMap<TopologyAPI.StreamId, TopologyAPI.Grouping>();
            for (TopologyAPI.InputStream istream : this.inputs.get(componentId)) {
                retVal.put(istream.getStream(), istream.getGtype());
            }
            return retVal;
        }
        return null;
    }

    @Override
    public Map<String, Map<String, TopologyAPI.Grouping>> getTargets(String componentId) {
        HashMap<String, Map<String, TopologyAPI.Grouping>> retVal = new HashMap<String, Map<String, TopologyAPI.Grouping>>();
        if (!this.outputs.containsKey(componentId)) {
            return retVal;
        }
        for (TopologyAPI.OutputStream ostream : this.outputs.get(componentId)) {
            HashMap<String, TopologyAPI.Grouping> targetMap = new HashMap<String, TopologyAPI.Grouping>();
            for (Map.Entry<String, List<TopologyAPI.InputStream>> e : this.inputs.entrySet()) {
                String targetComponentId = e.getKey();
                for (TopologyAPI.InputStream is : e.getValue()) {
                    if (!this.areStreamsEqual(ostream.getStream(), is.getStream())) continue;
                    targetMap.put(targetComponentId, is.getGtype());
                }
            }
            retVal.put(ostream.getStream().getId(), targetMap);
        }
        return retVal;
    }

    @Override
    public Map<Integer, String> getTaskToComponent() {
        return this.taskToComponentMap;
    }

    @Override
    public Set<String> getComponentIds() {
        return this.inputs.keySet();
    }

    @Override
    public int maxTopologyMessageTimeout() {
        return TypeUtils.getInteger(this.topologyConfig.get("topology.message.timeout.secs"));
    }

    private boolean areStreamsEqual(TopologyAPI.StreamId a, TopologyAPI.StreamId b) {
        return a.getId().equals(b.getId()) && a.getComponentName().equals(b.getComponentName());
    }
}

