/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.executors;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.common.basics.Communicator;
import org.apache.heron.common.basics.ExecutorLooper;
import org.apache.heron.common.utils.metrics.MetricsCollector;
import org.apache.heron.common.utils.misc.PhysicalPlanHelper;
import org.apache.heron.instance.IInstance;
import org.apache.heron.proto.system.Metrics;
import org.apache.heron.proto.system.PhysicalPlans;
import org.apache.heron.shaded.com.google.protobuf.Message;
import org.apache.heron.simulator.instance.BoltInstance;
import org.apache.heron.simulator.instance.SpoutInstance;

public class InstanceExecutor
implements Runnable {
    public static final int CAPACITY = 5;
    public static final double CURRENT_SAMPLE_WEIGHT = 0.5;
    private static final Logger LOG = Logger.getLogger(InstanceExecutor.class.getName());
    private final PhysicalPlanHelper physicalPlanHelper;
    private final ExecutorLooper looper;
    private final Communicator<Message> streamInQueue = new Communicator();
    private final Communicator<Message> streamOutQueue = new Communicator();
    private final Communicator<Metrics.MetricPublisherPublishMessage> metricsOutQueue = new Communicator();
    private IInstance instance;
    private volatile boolean toStop = false;
    private volatile boolean toActivate = false;
    private volatile boolean toDeactivate = false;
    private boolean isInstanceStarted = false;

    public InstanceExecutor(PhysicalPlans.PhysicalPlan physicalPlan, String instanceId) {
        this.looper = new ExecutorLooper();
        MetricsCollector metricsCollector = new MetricsCollector(this.looper, this.metricsOutQueue);
        this.physicalPlanHelper = this.createPhysicalPlanHelper(physicalPlan, instanceId, metricsCollector);
        this.initInstanceManager();
        LOG.log(Level.INFO, "Incarnating ourselves as {0} with task id {1}", new Object[]{this.physicalPlanHelper.getMyComponent(), this.physicalPlanHelper.getMyTaskId()});
    }

    public Communicator<Message> getStreamInQueue() {
        return this.streamInQueue;
    }

    public Communicator<Message> getStreamOutQueue() {
        return this.streamOutQueue;
    }

    public Communicator<Metrics.MetricPublisherPublishMessage> getMetricsOutQueue() {
        return this.metricsOutQueue;
    }

    public String getInstanceId() {
        return this.physicalPlanHelper.getMyInstanceId();
    }

    public String getComponentName() {
        return this.physicalPlanHelper.getMyComponent();
    }

    public int getTaskId() {
        return this.physicalPlanHelper.getMyTaskId();
    }

    protected IInstance createInstance() {
        return this.physicalPlanHelper.getMySpout() != null ? new SpoutInstance(this.physicalPlanHelper, this.streamInQueue, this.streamOutQueue, this.looper) : new BoltInstance(this.physicalPlanHelper, this.streamInQueue, this.streamOutQueue, this.looper);
    }

    protected PhysicalPlanHelper createPhysicalPlanHelper(PhysicalPlans.PhysicalPlan physicalPlan, String instanceId, MetricsCollector metricsCollector) {
        PhysicalPlanHelper localPhysicalPlanHelper = new PhysicalPlanHelper(physicalPlan, instanceId);
        localPhysicalPlanHelper.setTopologyContext(metricsCollector);
        return localPhysicalPlanHelper;
    }

    protected void initInstanceManager() {
        this.streamInQueue.setConsumer(this.looper);
        this.streamInQueue.init(5, 5, 0.5);
        this.streamOutQueue.setProducer(this.looper);
        this.streamOutQueue.init(5, 5, 0.5);
        this.metricsOutQueue.setProducer(this.looper);
    }

    protected void handleControlSignal() {
        if (this.toActivate) {
            if (!this.isInstanceStarted) {
                this.startInstance();
            }
            this.instance.activate();
            LOG.info("Activated instance: " + this.physicalPlanHelper.getMyInstanceId());
            this.toActivate = false;
        }
        if (this.toDeactivate) {
            this.instance.deactivate();
            LOG.info("Deactivated instance: " + this.physicalPlanHelper.getMyInstanceId());
            this.toDeactivate = false;
        }
        if (this.toStop) {
            this.instance.shutdown();
            LOG.info("Stopped instance: " + this.physicalPlanHelper.getMyInstanceId());
            this.toStop = false;
        }
    }

    @Override
    public void run() {
        Thread.currentThread().setName(String.format("%s_%s", this.physicalPlanHelper.getMyComponent(), this.physicalPlanHelper.getMyInstanceId()));
        this.instance = this.createInstance();
        if (this.physicalPlanHelper.getTopologyState().equals(TopologyAPI.TopologyState.RUNNING)) {
            this.startInstance();
        }
        Runnable handleControlTask = new Runnable(){

            @Override
            public void run() {
                InstanceExecutor.this.handleControlSignal();
            }
        };
        this.looper.addTasksOnWakeup(handleControlTask);
        this.looper.loop();
    }

    public void stop() {
        this.toStop = true;
        this.looper.wakeUp();
    }

    public void activate() {
        this.toActivate = true;
        this.looper.wakeUp();
    }

    public void deactivate() {
        this.toDeactivate = true;
        this.looper.wakeUp();
    }

    private void startInstance() {
        this.instance.init(null);
        this.instance.start();
        this.isInstanceStarted = true;
        LOG.info("Started instance.");
    }
}

