/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.config;

import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.apache.heron.common.basics.ByteAmount;
import org.apache.heron.common.basics.TypeUtils;
import org.apache.heron.common.config.ConfigReader;
import org.apache.heron.common.config.SystemConfigKey;

public final class SystemConfig {
    public static final String HERON_SYSTEM_CONFIG = SystemConfig.class.getName();
    private Map<String, Object> config = new HashMap<String, Object>();

    private SystemConfig(Builder build) {
        this.config = new HashMap<String, Object>(build.keyValues);
    }

    public static Builder newBuilder(boolean loadDefaults) {
        return Builder.create(loadDefaults);
    }

    public String toString() {
        return this.config.toString();
    }

    public ByteAmount getInstanceNetworkOptionsMaximumPacketSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_NETWORK_OPTIONS_MAXIMUM_PACKETSIZE_BYTES);
    }

    public int getInstanceInternalMetricsWriteQueueCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_INTERNAL_METRICS_WRITE_QUEUE_CAPACITY);
    }

    public int getInstanceTuningExpectedMetricsWriteQueueSize() {
        return this.getInteger(SystemConfigKey.INSTANCE_TUNING_EXPECTED_METRICS_WRITE_QUEUE_SIZE);
    }

    public int getInstanceSetDataTupleCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_SET_DATA_TUPLE_CAPACITY);
    }

    public ByteAmount getInstanceSetDataTupleSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_SET_DATA_TUPLE_SIZE);
    }

    public int getInstanceSetControlTupleCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_SET_CONTROL_TUPLE_CAPACITY);
    }

    public Duration getInstanceForceExitTimeout() {
        return this.getDuration(SystemConfigKey.INSTANCE_FORCE_EXIT_TIMEOUT);
    }

    public int getInstanceInternalBoltReadQueueCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_INTERNAL_BOLT_READ_QUEUE_CAPACITY);
    }

    public int getInstanceInternalBoltWriteQueueCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_INTERNAL_BOLT_WRITE_QUEUE_CAPACITY);
    }

    public int getInstanceInternalSpoutReadQueueCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_INTERNAL_SPOUT_READ_QUEUE_CAPACITY);
    }

    public int getInstanceInternalSpoutWriteQueueCapacity() {
        return this.getInteger(SystemConfigKey.INSTANCE_INTERNAL_SPOUT_WRITE_QUEUE_CAPACITY);
    }

    public Duration getInstanceAckBatchTime() {
        return this.getDuration(SystemConfigKey.INSTANCE_ACK_BATCH_TIME);
    }

    public int getInstanceTuningExpectedBoltReadQueueSize() {
        return this.getInteger(SystemConfigKey.INSTANCE_TUNING_EXPECTED_BOLT_READ_QUEUE_SIZE);
    }

    public int getInstanceTuningExpectedBoltWriteQueueSize() {
        return this.getInteger(SystemConfigKey.INSTANCE_TUNING_EXPECTED_BOLT_WRITE_QUEUE_SIZE);
    }

    public int getInstanceTuningExpectedSpoutReadQueueSize() {
        return this.getInteger(SystemConfigKey.INSTANCE_TUNING_EXPECTED_SPOUT_READ_QUEUE_SIZE);
    }

    public int getInstanceTuningExpectedSpoutWriteQueueSize() {
        return this.getInteger(SystemConfigKey.INSTANCE_TUNING_EXPECTED_SPOUT_WRITE_QUEUE_SIZE);
    }

    public String getHeronLoggingDirectory() {
        return this.getString(SystemConfigKey.HERON_LOGGING_DIRECTORY);
    }

    public ByteAmount getHeronLoggingMaximumSize() {
        return ByteAmount.fromMegabytes(this.getInteger(SystemConfigKey.HERON_LOGGING_MAXIMUM_SIZE_MB).intValue());
    }

    public int getHeronLoggingMaximumFiles() {
        return this.getInteger(SystemConfigKey.HERON_LOGGING_MAXIMUM_FILES);
    }

    public Duration getHeronMetricsExportInterval() {
        return this.getDuration(SystemConfigKey.HERON_METRICS_EXPORT_INTERVAL);
    }

    public Duration getInstanceNetworkReadBatchTime() {
        return this.getDuration(SystemConfigKey.INSTANCE_NETWORK_READ_BATCH_TIME);
    }

    public ByteAmount getInstanceNetworkReadBatchSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_NETWORK_READ_BATCH_SIZE);
    }

    public Duration getInstanceNetworkWriteBatchTime() {
        return this.getDuration(SystemConfigKey.INSTANCE_NETWORK_WRITE_BATCH_TIME);
    }

    public ByteAmount getInstanceNetworkWriteBatchSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_NETWORK_WRITE_BATCH_SIZE);
    }

    public ByteAmount getInstanceNetworkOptionsSocketReceivedBufferSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE);
    }

    public ByteAmount getInstanceNetworkOptionsSocketSendBufferSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE);
    }

    public Duration getInstanceEmitBatchTime() {
        return this.getDuration(SystemConfigKey.INSTANCE_EMIT_BATCH_TIME);
    }

    public ByteAmount getInstanceEmitBatchSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_EMIT_BATCH_SIZE);
    }

    public Duration getInstanceExecuteBatchTime() {
        return this.getDuration(SystemConfigKey.INSTANCE_EXECUTE_BATCH_TIME);
    }

    public ByteAmount getInstanceExecuteBatchSize() {
        return this.getByteAmount(SystemConfigKey.INSTANCE_EXECUTE_BATCH_SIZE);
    }

    public Duration getInstanceReconnectStreammgrInterval() {
        return this.getDuration(SystemConfigKey.INSTANCE_RECONNECT_STREAMMGR_INTERVAL);
    }

    public Duration getInstanceReconnectMetricsmgrInterval() {
        return this.getDuration(SystemConfigKey.INSTANCE_RECONNECT_METRICSMGR_INTERVAL);
    }

    public Duration getInstanceMetricsSystemSampleInterval() {
        return this.getDuration(SystemConfigKey.INSTANCE_METRICS_SYSTEM_SAMPLE_INTERVAL);
    }

    public int getInstanceAcknowledgementNbuckets() {
        return this.getInteger(SystemConfigKey.INSTANCE_ACKNOWLEDGEMENT_NBUCKETS);
    }

    public Duration getInstanceTuningInterval() {
        return this.getDuration(SystemConfigKey.INSTANCE_TUNING_INTERVAL);
    }

    public double getInstanceTuningCurrentSampleWeight() {
        return this.getDouble(SystemConfigKey.INSTANCE_TUNING_CURRENT_SAMPLE_WEIGHT);
    }

    public Duration getMetricsMgrNetworkReadBatchTime() {
        return this.getDuration(SystemConfigKey.METRICSMGR_NETWORK_READ_BATCH_TIME);
    }

    public ByteAmount getMetricsMgrNetworkReadBatchSize() {
        return this.getByteAmount(SystemConfigKey.METRICSMGR_NETWORK_READ_BATCH_SIZE);
    }

    public Duration getMetricsMgrNetworkWriteBatchTime() {
        return this.getDuration(SystemConfigKey.METRICSMGR_NETWORK_WRITE_BATCH_TIME);
    }

    public ByteAmount getMetricsMgrNetworkWriteBatchSize() {
        return this.getByteAmount(SystemConfigKey.METRICSMGR_NETWORK_WRITE_BATCH_SIZE);
    }

    public ByteAmount getMetricsMgrNetworkOptionsSocketReceivedBufferSize() {
        return this.getByteAmount(SystemConfigKey.METRICSMGR_NETWORK_OPTIONS_SOCKET_RECEIVED_BUFFER_SIZE);
    }

    public ByteAmount getMetricsMgrNetworkOptionsSocketSendBufferSize() {
        return this.getByteAmount(SystemConfigKey.METRICSMGR_NETWORK_OPTIONS_SOCKET_SEND_BUFFER_SIZE);
    }

    public ByteAmount getMetricsMgrNetworkOptionsMaximumPacketSize() {
        return this.getByteAmount(SystemConfigKey.METRICSMGR_NETWORK_OPTIONS_MAXIMUM_PACKETSIZE_BYTES);
    }

    public int getHeronMetricsMaxExceptionsPerMessageCount() {
        return this.getInteger(SystemConfigKey.HERON_METRICS_MAX_EXCEPTIONS_PER_MESSAGE_COUNT);
    }

    public long getTmanagerMetricsCollectorMaximumException() {
        try {
            return this.getLong(SystemConfigKey.TMANAGER_METRICS_COLLECTOR_MAXIMUM_EXCEPTION);
        }
        catch (IllegalArgumentException e) {
            return 256L;
        }
    }

    public Duration getTmanagerMetricsCollectorMaximumInterval() {
        return this.getDuration(SystemConfigKey.TMANAGER_METRICS_COLLECTOR_MAXIMUM_INTERVAL);
    }

    public Duration getTmanagerMetricsCollectorPurgeInterval() {
        return this.getDuration(SystemConfigKey.TMANAGER_METRICS_COLLECTOR_PURGE_INTERVAL);
    }

    private String getString(SystemConfigKey key) {
        this.assertType(key, SystemConfigKey.Type.STRING);
        return (String)this.get(key);
    }

    private Integer getInteger(SystemConfigKey key) {
        this.assertType(key, SystemConfigKey.Type.INTEGER);
        return TypeUtils.getInteger(this.get(key));
    }

    private Long getLong(SystemConfigKey key) {
        this.assertType(key, SystemConfigKey.Type.LONG);
        return TypeUtils.getLong(this.get(key));
    }

    private Double getDouble(SystemConfigKey key) {
        this.assertType(key, SystemConfigKey.Type.DOUBLE);
        return TypeUtils.getDouble(this.get(key));
    }

    private Duration getDuration(SystemConfigKey key) {
        this.assertType(key, SystemConfigKey.Type.DURATION);
        return TypeUtils.getDuration(this.get(key), key.getTemporalUnit());
    }

    private ByteAmount getByteAmount(SystemConfigKey key) {
        this.assertType(key, SystemConfigKey.Type.BYTE_AMOUNT);
        return TypeUtils.getByteAmount(this.get(key));
    }

    private Object get(SystemConfigKey key) {
        return this.config.get(key.value());
    }

    private void assertType(SystemConfigKey key, SystemConfigKey.Type type) {
        if (key.getType() != type) {
            throw new IllegalArgumentException(String.format("config key %s is of type %s instead of expected type %s", new Object[]{key, key.getType(), type}));
        }
    }

    public static class Builder {
        private final Map<String, Object> keyValues = new HashMap<String, Object>();

        private static Builder create(boolean loadDefaults) {
            Builder cb = new Builder();
            if (loadDefaults) {
                Builder.loadDefaults(cb, SystemConfigKey.values());
            }
            return cb;
        }

        private static void loadDefaults(Builder cb, SystemConfigKey ... keys) {
            for (SystemConfigKey key : keys) {
                if (key.getDefault() == null) continue;
                cb.put(key, key.getDefault());
            }
        }

        public Builder put(SystemConfigKey key, Object value) {
            Builder.convertAndAdd(this.keyValues, key, value);
            return this;
        }

        public Builder putAll(String fileName, boolean mustExist) {
            File file = new File(fileName);
            if (!file.exists() && mustExist) {
                throw new IllegalArgumentException(String.format("Config file %s does not exist", fileName));
            }
            Map<String, Object> configValues = ConfigReader.loadFile(fileName);
            for (String keyValue : configValues.keySet()) {
                SystemConfigKey key = SystemConfigKey.toSystemConfigKey(keyValue);
                if (key == null) continue;
                Builder.convertAndAdd(configValues, key, configValues.get(keyValue));
            }
            this.keyValues.putAll(configValues);
            return this;
        }

        private static void convertAndAdd(Map<String, Object> config, SystemConfigKey key, Object value) {
            if (key != null) {
                switch (key.getType()) {
                    case BOOLEAN: {
                        config.put(key.value(), TypeUtils.getBoolean(value));
                        break;
                    }
                    case BYTE_AMOUNT: {
                        config.put(key.value(), TypeUtils.getByteAmount(value));
                        break;
                    }
                    case DOUBLE: {
                        config.put(key.value(), TypeUtils.getDouble(value));
                        break;
                    }
                    case DURATION: {
                        config.put(key.value(), TypeUtils.getDuration(value, key.getTemporalUnit()));
                        break;
                    }
                    case INTEGER: {
                        config.put(key.value(), TypeUtils.getInteger(value));
                        break;
                    }
                    case LONG: {
                        config.put(key.value(), TypeUtils.getLong(value));
                        break;
                    }
                    case STRING: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("config key %s is of type %s which is not yet supported", new Object[]{key, key.getType()}));
                    }
                }
            }
        }

        public SystemConfig build() {
            return new SystemConfig(this);
        }
    }
}

