/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.apache.heron.api.metric.ConcurrentCountMetric;
import org.apache.heron.api.metric.IMetric;
import org.apache.heron.common.utils.metrics.MetricsCollector;
import org.apache.heron.proto.system.Metrics;

public class ErrorReportLoggingHandler
extends Handler {
    public static final String NO_TRACE = "No Trace";
    private static volatile boolean initialized = false;
    private static volatile int exceptionsLimit = Integer.MAX_VALUE;
    private static volatile ConcurrentCountMetric droppedExceptionsCount = new ConcurrentCountMetric();

    public static String getExceptionLocation(String trace) {
        if (trace == null) {
            return NO_TRACE;
        }
        String[] firstLine = trace.split("\n");
        if (firstLine.length == 0) {
            return NO_TRACE;
        }
        if (firstLine.length == 1) {
            return firstLine[0];
        }
        return firstLine[0] + "\n" + firstLine[1];
    }

    public static synchronized void init(MetricsCollector collector, Duration interval, int maxExceptions) {
        if (!initialized) {
            collector.registerMetric("exception_info", ExceptionRepositoryAsMetrics.INSTANCE, (int)interval.getSeconds());
            collector.registerMetric("dropped_exceptions_count", droppedExceptionsCount, (int)interval.getSeconds());
            exceptionsLimit = maxExceptions;
        }
        initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        Throwable throwable = record.getThrown();
        if (throwable != null) {
            ExceptionRepositoryAsMetrics exceptionRepositoryAsMetrics = ExceptionRepositoryAsMetrics.INSTANCE;
            synchronized (exceptionRepositoryAsMetrics) {
                if (ExceptionRepositoryAsMetrics.INSTANCE.getExceptionsCount() >= exceptionsLimit) {
                    droppedExceptionsCount.incr();
                    return;
                }
                StringWriter sink = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)sink, true));
                String trace = sink.toString();
                Metrics.ExceptionData.Builder exceptionDataBuilder = ExceptionRepositoryAsMetrics.INSTANCE.getExceptionInfo(trace);
                exceptionDataBuilder.setCount(exceptionDataBuilder.getCount() + 1);
                exceptionDataBuilder.setLasttime(new Date().toString());
                exceptionDataBuilder.setStacktrace(trace);
                if (record.getMessage() == null) {
                    exceptionDataBuilder.setLogging("");
                } else {
                    exceptionDataBuilder.setLogging(record.getMessage());
                }
            }
        }
    }

    @Override
    public void close() {
        this.flush();
    }

    @Override
    public void flush() {
        System.out.print(ExceptionRepositoryAsMetrics.INSTANCE.getValue().toString());
    }

    public static enum ExceptionRepositoryAsMetrics implements IMetric<Collection<Metrics.ExceptionData.Builder>>
    {
        INSTANCE;

        private HashMap<String, Metrics.ExceptionData.Builder> exceptionStore = new HashMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<Metrics.ExceptionData.Builder> getValueAndReset() {
            ExceptionRepositoryAsMetrics exceptionRepositoryAsMetrics = INSTANCE;
            synchronized (exceptionRepositoryAsMetrics) {
                Collection<Metrics.ExceptionData.Builder> metricsValue = this.exceptionStore.values();
                this.exceptionStore = new HashMap();
                return metricsValue;
            }
        }

        protected int getExceptionsCount() {
            return this.exceptionStore.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue() {
            ExceptionRepositoryAsMetrics exceptionRepositoryAsMetrics = INSTANCE;
            synchronized (exceptionRepositoryAsMetrics) {
                return this.exceptionStore.values();
            }
        }

        protected Metrics.ExceptionData.Builder getExceptionInfo(String trace) {
            Metrics.ExceptionData.Builder exceptionDataBuilder = this.exceptionStore.get(ErrorReportLoggingHandler.getExceptionLocation(trace));
            if (exceptionDataBuilder == null) {
                exceptionDataBuilder = Metrics.ExceptionData.newBuilder();
                exceptionDataBuilder.setFirsttime(new Date().toString());
                exceptionDataBuilder.setCount(0);
                exceptionDataBuilder.setStacktrace(ErrorReportLoggingHandler.NO_TRACE);
                this.exceptionStore.put(ErrorReportLoggingHandler.getExceptionLocation(trace), exceptionDataBuilder);
            }
            return exceptionDataBuilder;
        }
    }
}

