/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.api.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.DefaultSerializers;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.heron.api.serializer.IKryoDecorator;
import org.apache.heron.api.serializer.IKryoFactory;
import org.apache.heron.api.serializer.IPluggableSerializer;
import org.apache.heron.api.tuple.Values;
import org.apache.heron.api.utils.Utils;

public class KryoSerializer
implements IPluggableSerializer {
    private static final Logger LOG = Logger.getLogger(KryoSerializer.class.getName());
    private static final String DEFAULT_FACTORY = "org.apache.heron.api.serializer.DefaultKryoFactory";
    private IKryoFactory kryoFactory;
    private Kryo kryo;
    private Output kryoOut;
    private Input kryoIn;

    @Override
    public void initialize(Map<String, Object> config) {
        String factoryClassName = (String)config.getOrDefault("topology.kryo.factory", DEFAULT_FACTORY);
        this.kryoFactory = (IKryoFactory)Utils.newInstance(factoryClassName);
        this.kryo = this.kryoFactory.getKryo(config);
        this.kryoOut = new Output(2000, 2000000000);
        this.kryoIn = new Input(1);
        boolean skipMissing = (Boolean)config.getOrDefault("topology.skip.missing.kryo.registrations", false);
        KryoSerializer.registerDefaultSerializers(this.kryo);
        this.kryoFactory.preRegister(this.kryo, config);
        KryoSerializer.registerUserSerializers(this.kryo, config, skipMissing);
        this.kryoFactory.postRegister(this.kryo, config);
        KryoSerializer.applyUserDecorators(this.kryo, config, skipMissing);
        this.kryoFactory.postDecorate(this.kryo, config);
    }

    @Override
    public byte[] serialize(Object object) {
        this.kryoOut.reset();
        this.kryo.writeClassAndObject(this.kryoOut, object);
        return this.kryoOut.toBytes();
    }

    @Override
    public Object deserialize(byte[] input) {
        this.kryoIn.setBuffer(input);
        return this.kryo.readClassAndObject(this.kryoIn);
    }

    private static void registerDefaultSerializers(Kryo k) {
        k.register(byte[].class);
        k.register(ArrayList.class);
        k.register(HashMap.class);
        k.register(HashSet.class);
        k.register(BigInteger.class, (Serializer)new DefaultSerializers.BigIntegerSerializer());
        k.register(Values.class);
    }

    private static void registerUserSerializers(Kryo k, Map<String, Object> config, boolean skipMissing) {
        Map<String, String> registrations = KryoSerializer.normalizeKryoRegister(config);
        for (String klassName : registrations.keySet()) {
            String serializerClassName = registrations.get(klassName);
            try {
                Class<?> klass = Class.forName(klassName);
                Class<?> serializerClass = null;
                if (serializerClassName != null) {
                    serializerClass = Class.forName(serializerClassName);
                }
                LOG.info("Doing kryo.register for class " + klass);
                if (serializerClass == null) {
                    k.register(klass);
                    continue;
                }
                k.register(klass, KryoSerializer.resolveSerializerInstance(k, klass, serializerClass));
            }
            catch (ClassNotFoundException e) {
                if (skipMissing) {
                    LOG.info("Could not find serialization or class for " + serializerClassName + ". Skipping registration...");
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static void applyUserDecorators(Kryo k, Map<String, Object> config, boolean skipMissing) {
        if (config.containsKey("topology.kryo.decorators")) {
            for (String klassName : (List)config.get("topology.kryo.decorators")) {
                try {
                    Class<?> klass = Class.forName(klassName);
                    IKryoDecorator decorator = (IKryoDecorator)klass.newInstance();
                    decorator.decorate(k);
                }
                catch (ClassNotFoundException e) {
                    if (skipMissing) {
                        LOG.info("Could not find kryo decorator named " + klassName + ". Skipping registration...");
                        continue;
                    }
                    throw new RuntimeException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static Map<String, String> normalizeKryoRegister(Map<String, Object> config) {
        Object res = config.get("topology.kryo.register");
        if (res == null) {
            return new TreeMap<String, String>();
        }
        HashMap ret = new HashMap();
        for (Object o : (List)res) {
            if (o instanceof Map) {
                ret.putAll((Map)o);
                continue;
            }
            ret.put((String)o, null);
        }
        return new TreeMap<String, String>(ret);
    }

    private static Serializer resolveSerializerInstance(Kryo k, Class superClass, Class<? extends Serializer> serializerClass) {
        try {
            Constructor<? extends Serializer> ctor = serializerClass.getConstructor(Kryo.class, Class.class);
            return ctor.newInstance(k, superClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            try {
                Constructor<? extends Serializer> ctor = serializerClass.getConstructor(Kryo.class);
                return ctor.newInstance(k);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException2) {
                try {
                    Constructor<? extends Serializer> ctor = serializerClass.getConstructor(Class.class);
                    return ctor.newInstance(k);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException3) {
                    try {
                        return serializerClass.newInstance();
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException4) {
                        throw new IllegalArgumentException(String.format("Unable to create serializer \"%s\" for class: %s", serializerClass.getName(), superClass.getName()));
                    }
                }
            }
        }
    }
}

