/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.network;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;

public class REQID {
    public static final int REQID_SIZE = 32;
    public static REQID zeroREQID = REQID.generateZero();
    private static Random randomGenerator = new Random(System.nanoTime());
    private byte[] bytes;

    public REQID(byte[] dataBytes) {
        assert (dataBytes.length == 32);
        this.bytes = new byte[32];
        System.arraycopy(dataBytes, 0, this.bytes, 0, dataBytes.length);
    }

    public REQID(ByteBuffer buffer) {
        this.bytes = new byte[32];
        buffer.get(this.bytes);
    }

    public static REQID generate() {
        byte[] dataBytes = new byte[32];
        randomGenerator.nextBytes(dataBytes);
        return new REQID(dataBytes);
    }

    private static REQID generateZero() {
        byte[] dataBytes = new byte[32];
        Arrays.fill(dataBytes, (byte)0);
        return new REQID(dataBytes);
    }

    public void pack(ByteBuffer buffer) {
        buffer.put(this.bytes);
    }

    public byte[] value() {
        return this.bytes;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!(other instanceof REQID)) {
            return false;
        }
        REQID rother = (REQID)other;
        return Arrays.equals(this.bytes, rother.value());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        for (int j = 0; j < this.bytes.length; ++j) {
            bldr.append(String.format("%02X ", this.bytes[j]));
        }
        return bldr.toString();
    }
}

