/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.metrics;

import java.time.Duration;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.apache.heron.api.metric.CumulativeCountMetric;
import org.apache.heron.api.metric.IMetric;
import org.apache.heron.api.metric.IMetricsRegister;
import org.apache.heron.common.basics.Communicator;
import org.apache.heron.common.basics.WakeableLooper;
import org.apache.heron.proto.system.Metrics;

public class MetricsCollector
implements IMetricsRegister {
    private static final Logger LOG = Logger.getLogger(MetricsCollector.class.getName());
    private static final String COLLECTION_COUNT_NAME = "__collector-collection-count";
    private Map<String, IMetric<?>> metrics = new ConcurrentHashMap();
    private Map<Integer, List<String>> timeBucketToMetricNames = new ConcurrentHashMap<Integer, List<String>>();
    private WakeableLooper runnableToGatherMetrics;
    private CumulativeCountMetric metricCollectionCount;
    private Communicator<Metrics.MetricPublisherPublishMessage> queue;

    public MetricsCollector(WakeableLooper runnableToGatherMetrics, Communicator<Metrics.MetricPublisherPublishMessage> queue) {
        this.queue = queue;
        this.runnableToGatherMetrics = runnableToGatherMetrics;
        this.metricCollectionCount = new CumulativeCountMetric();
    }

    @Override
    public <T extends IMetric<U>, U> T registerMetric(String name, T metric, final int timeBucketSizeInSecs) {
        if (this.metrics.containsKey(name)) {
            throw new RuntimeException("Another metric has already been registered with name: " + name);
        }
        this.metrics.put(name, metric);
        if (this.timeBucketToMetricNames.containsKey(timeBucketSizeInSecs)) {
            this.timeBucketToMetricNames.get(timeBucketSizeInSecs).add(name);
        } else {
            this.timeBucketToMetricNames.put(timeBucketSizeInSecs, new LinkedList());
            this.timeBucketToMetricNames.get(timeBucketSizeInSecs).add(name);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MetricsCollector.this.gatherMetrics(timeBucketSizeInSecs);
                }
            };
            this.runnableToGatherMetrics.registerTimerEvent(Duration.ofSeconds(timeBucketSizeInSecs), r);
        }
        return metric;
    }

    public void registerMetricSampleRunnable(final Runnable sampleRunnable, final Duration sampleInterval) {
        Runnable sampleTimer = new Runnable(){

            @Override
            public void run() {
                sampleRunnable.run();
                MetricsCollector.this.runnableToGatherMetrics.registerTimerEvent(sampleInterval, this);
            }
        };
        this.runnableToGatherMetrics.registerTimerEvent(sampleInterval, sampleTimer);
    }

    public void forceGatherAllMetrics() {
        LOG.info("Forcing to gather all metrics and flush out.");
        Metrics.MetricPublisherPublishMessage.Builder builder = Metrics.MetricPublisherPublishMessage.newBuilder();
        for (List<String> metricNames : this.timeBucketToMetricNames.values()) {
            for (String metricName : metricNames) {
                this.gatherOneMetric(metricName, builder);
            }
        }
        this.metricCollectionCount.incr();
        this.addDataToMetricPublisher(builder, COLLECTION_COUNT_NAME, this.metricCollectionCount);
        Metrics.MetricPublisherPublishMessage msg = builder.build();
        this.queue.offer(msg);
    }

    private void addDataToMetricPublisher(Metrics.MetricPublisherPublishMessage.Builder builder, String metricName, Object metricValue) {
        if (metricValue instanceof Metrics.MetricDatum.Builder) {
            builder.addMetrics((Metrics.MetricDatum.Builder)metricValue);
        } else if (metricValue instanceof Metrics.ExceptionData.Builder) {
            builder.addExceptions((Metrics.ExceptionData.Builder)metricValue);
        } else {
            assert (metricName != null);
            Metrics.MetricDatum.Builder d = Metrics.MetricDatum.newBuilder();
            d.setName(metricName).setValue(metricValue.toString());
            builder.addMetrics(d);
        }
    }

    private void gatherMetrics(final int timeBucketSizeInSecs) {
        if (this.timeBucketToMetricNames.containsKey(timeBucketSizeInSecs)) {
            Metrics.MetricPublisherPublishMessage.Builder builder = Metrics.MetricPublisherPublishMessage.newBuilder();
            for (String metricName : this.timeBucketToMetricNames.get(timeBucketSizeInSecs)) {
                this.gatherOneMetric(metricName, builder);
            }
            this.metricCollectionCount.incr();
            this.addDataToMetricPublisher(builder, COLLECTION_COUNT_NAME, this.metricCollectionCount.getValueAndReset());
            Metrics.MetricPublisherPublishMessage msg = builder.build();
            this.queue.offer(msg);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    MetricsCollector.this.gatherMetrics(timeBucketSizeInSecs);
                }
            };
            this.runnableToGatherMetrics.registerTimerEvent(Duration.ofSeconds(timeBucketSizeInSecs), r);
        }
    }

    private void gatherOneMetric(String metricName, Metrics.MetricPublisherPublishMessage.Builder builder) {
        Object metricValue = this.metrics.get(metricName).getValueAndReset();
        if (metricValue == null) {
            return;
        }
        if (metricValue instanceof Map) {
            for (Map.Entry entry : ((Map)metricValue).entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                this.addDataToMetricPublisher(builder, metricName + "/" + entry.getKey().toString(), entry.getValue());
            }
        } else if (metricValue instanceof Collection) {
            int index = 0;
            for (Object value : (Collection)metricValue) {
                this.addDataToMetricPublisher(builder, metricName + "/" + index++, value);
            }
        } else {
            this.addDataToMetricPublisher(builder, metricName, metricValue);
        }
    }
}

