/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.topology;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.hooks.ITaskHook;
import org.apache.heron.api.hooks.info.BoltAckInfo;
import org.apache.heron.api.hooks.info.BoltExecuteInfo;
import org.apache.heron.api.hooks.info.BoltFailInfo;
import org.apache.heron.api.hooks.info.EmitInfo;
import org.apache.heron.api.hooks.info.SpoutAckInfo;
import org.apache.heron.api.hooks.info.SpoutFailInfo;
import org.apache.heron.api.metric.CombinedMetric;
import org.apache.heron.api.metric.ICombiner;
import org.apache.heron.api.metric.IMetric;
import org.apache.heron.api.metric.IReducer;
import org.apache.heron.api.metric.ReducedMetric;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.common.basics.TypeUtils;
import org.apache.heron.common.utils.metrics.MetricsCollector;
import org.apache.heron.common.utils.topology.GeneralTopologyContextImpl;

public class TopologyContextImpl
extends GeneralTopologyContextImpl
implements TopologyContext {
    private final int myTaskId;
    private final Map<String, Object> taskData;
    private final MetricsCollector metricsCollector;
    private final List<ITaskHook> taskHooks;

    public TopologyContextImpl(Map<String, Object> clusterConfig, TopologyAPI.Topology topology, Map<Integer, String> taskToComponentMap, int myTaskId, MetricsCollector metricsCollector) {
        super(clusterConfig, topology, taskToComponentMap);
        this.metricsCollector = metricsCollector;
        this.myTaskId = myTaskId;
        this.taskData = new HashMap<String, Object>();
        this.taskHooks = new LinkedList<ITaskHook>();
        List<String> taskHooksClassNames = TypeUtils.getListOfStrings(clusterConfig.get("topology.auto.task.hooks"));
        if (taskHooksClassNames != null) {
            for (String className : taskHooksClassNames) {
                ITaskHook taskHook;
                try {
                    taskHook = (ITaskHook)Class.forName(className).newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex + " ITaskHook class must be in class path.");
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex + " ITaskHook class must be concrete.");
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex + " ITaskHook class must have a no-arg constructor.");
                }
                this.taskHooks.add(taskHook);
            }
        }
    }

    public void invokeHookPrepare() {
        for (ITaskHook taskHook : this.taskHooks) {
            taskHook.prepare(this.getTopologyConfig(), this);
        }
    }

    public void invokeHookCleanup() {
        for (ITaskHook taskHook : this.taskHooks) {
            taskHook.cleanup();
        }
    }

    public void invokeHookEmit(List<Object> values, String stream, Collection<Integer> outTasks) {
        if (this.taskHooks.size() != 0) {
            EmitInfo emitInfo = new EmitInfo(values, stream, this.getThisTaskId(), outTasks);
            for (ITaskHook taskHook : this.taskHooks) {
                taskHook.emit(emitInfo);
            }
        }
    }

    public void invokeHookSpoutAck(Object messageId, Duration completeLatency) {
        if (this.taskHooks.size() != 0) {
            SpoutAckInfo ackInfo = new SpoutAckInfo(messageId, this.getThisTaskId(), completeLatency);
            for (ITaskHook taskHook : this.taskHooks) {
                taskHook.spoutAck(ackInfo);
            }
        }
    }

    public void invokeHookSpoutFail(Object messageId, Duration failLatency) {
        if (this.taskHooks.size() != 0) {
            SpoutFailInfo failInfo = new SpoutFailInfo(messageId, this.getThisTaskId(), failLatency);
            for (ITaskHook taskHook : this.taskHooks) {
                taskHook.spoutFail(failInfo);
            }
        }
    }

    public void invokeHookBoltExecute(Tuple tuple, Duration executeLatency) {
        if (this.taskHooks.size() != 0) {
            BoltExecuteInfo executeInfo = new BoltExecuteInfo(tuple, this.getThisTaskId(), executeLatency);
            for (ITaskHook taskHook : this.taskHooks) {
                taskHook.boltExecute(executeInfo);
            }
        }
    }

    public void invokeHookBoltAck(Tuple tuple, Duration processLatency) {
        if (this.taskHooks.size() != 0) {
            BoltAckInfo ackInfo = new BoltAckInfo(tuple, this.getThisTaskId(), processLatency);
            for (ITaskHook taskHook : this.taskHooks) {
                taskHook.boltAck(ackInfo);
            }
        }
    }

    public void invokeHookBoltFail(Tuple tuple, Duration failLatency) {
        if (this.taskHooks.size() != 0) {
            BoltFailInfo failInfo = new BoltFailInfo(tuple, this.getThisTaskId(), failLatency);
            for (ITaskHook taskHook : this.taskHooks) {
                taskHook.boltFail(failInfo);
            }
        }
    }

    @Override
    public int getThisTaskId() {
        return this.myTaskId;
    }

    @Override
    public String getThisComponentId() {
        return this.getComponentId(this.myTaskId);
    }

    @Override
    public Fields getThisOutputFields(String streamId) {
        return this.getComponentOutputFields(this.getThisComponentId(), streamId);
    }

    @Override
    public Set<String> getThisStreams() {
        return this.getComponentStreams(this.getThisComponentId());
    }

    @Override
    public int getThisTaskIndex() {
        List<Integer> allTasks = this.getComponentTasks(this.getThisComponentId());
        int retVal = 0;
        for (Integer tsk : allTasks) {
            if (tsk >= this.myTaskId) continue;
            ++retVal;
        }
        return retVal;
    }

    @Override
    public Map<TopologyAPI.StreamId, TopologyAPI.Grouping> getThisSources() {
        return this.getSources(this.getThisComponentId());
    }

    @Override
    public Map<String, Map<String, TopologyAPI.Grouping>> getThisTargets() {
        return this.getTargets(this.getThisComponentId());
    }

    @Override
    public void setTaskData(String name, Object data) {
        this.taskData.put(name, data);
    }

    @Override
    public Object getTaskData(String name) {
        return this.taskData.get(name);
    }

    @Override
    public <T extends IMetric<U>, U> T registerMetric(String name, T metric, int timeBucketSizeInSecs) {
        this.metricsCollector.registerMetric(name, metric, timeBucketSizeInSecs);
        return metric;
    }

    @Override
    public <T, U, V> ReducedMetric<T, U, V> registerMetric(String name, IReducer<T, U, V> reducer, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new ReducedMetric<T, U, V>(reducer), timeBucketSizeInSecs);
    }

    @Override
    public <T> CombinedMetric<T> registerMetric(String name, ICombiner<T> combiner, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new CombinedMetric<T>(combiner), timeBucketSizeInSecs);
    }

    @Override
    public void addTaskHook(ITaskHook hook) {
        this.taskHooks.add(hook);
    }

    @Override
    public Collection<ITaskHook> getHooks() {
        return this.taskHooks;
    }
}

