/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.common.utils.tuple;

import java.util.List;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.api.topology.TopologyContext;
import org.apache.heron.api.tuple.Fields;
import org.apache.heron.api.tuple.Tuple;
import org.apache.heron.proto.system.HeronTuples;

public class TupleImpl
implements Tuple {
    private static final long serialVersionUID = -5524957157094337394L;
    private final Fields fields;
    private final TopologyAPI.StreamId stream;
    private final long tupleKey;
    private final List<HeronTuples.RootId> roots;
    private final long creationTime;
    private final int sourceTaskId;
    private List<Object> values;

    public TupleImpl(TopologyContext context, TopologyAPI.StreamId stream, long tupleKey, List<HeronTuples.RootId> roots, List<Object> values, int sourceTaskId) {
        this(context, stream, tupleKey, roots, values, System.nanoTime(), true, sourceTaskId);
    }

    public TupleImpl(TopologyContext context, TopologyAPI.StreamId stream, long tupleKey, List<HeronTuples.RootId> roots, List<Object> values, long creationTime, boolean isCheckRequired, int sourceTaskId) {
        this.stream = stream;
        this.tupleKey = tupleKey;
        this.roots = roots;
        this.values = values;
        this.creationTime = creationTime;
        this.sourceTaskId = sourceTaskId;
        this.fields = context.getComponentOutputFields(this.stream.getComponentName(), this.stream.getId());
        if (isCheckRequired && values.size() != this.fields.size()) {
            throw new IllegalArgumentException("Tuple created with wrong number of fields. Expected " + this.fields.size() + " fields but got " + values.size() + " fields");
        }
    }

    public List<HeronTuples.RootId> getRoots() {
        return this.roots;
    }

    public long getTupleKey() {
        return this.tupleKey;
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public int fieldIndex(String field) {
        return this.getFields().fieldIndex(field);
    }

    @Override
    public boolean contains(String field) {
        return this.getFields().contains(field);
    }

    @Override
    public Object getValue(int i) {
        return this.values.get(i);
    }

    @Override
    public String getString(int i) {
        return (String)this.values.get(i);
    }

    @Override
    public Integer getInteger(int i) {
        return (Integer)this.values.get(i);
    }

    @Override
    public Long getLong(int i) {
        return (Long)this.values.get(i);
    }

    @Override
    public Boolean getBoolean(int i) {
        return (Boolean)this.values.get(i);
    }

    @Override
    public Short getShort(int i) {
        return (Short)this.values.get(i);
    }

    @Override
    public Byte getByte(int i) {
        return (Byte)this.values.get(i);
    }

    @Override
    public Double getDouble(int i) {
        return (Double)this.values.get(i);
    }

    @Override
    public Float getFloat(int i) {
        return (Float)this.values.get(i);
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.values.get(i);
    }

    @Override
    public Object getValueByField(String field) {
        return this.values.get(this.fieldIndex(field));
    }

    @Override
    public String getStringByField(String field) {
        return (String)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Integer getIntegerByField(String field) {
        return (Integer)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Long getLongByField(String field) {
        return (Long)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Boolean getBooleanByField(String field) {
        return (Boolean)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Short getShortByField(String field) {
        return (Short)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Byte getByteByField(String field) {
        return (Byte)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Double getDoubleByField(String field) {
        return (Double)this.values.get(this.fieldIndex(field));
    }

    @Override
    public Float getFloatByField(String field) {
        return (Float)this.values.get(this.fieldIndex(field));
    }

    @Override
    public byte[] getBinaryByField(String field) {
        return (byte[])this.values.get(this.fieldIndex(field));
    }

    @Override
    public List<Object> getValues() {
        return this.values;
    }

    @Override
    public Fields getFields() {
        return this.fields;
    }

    @Override
    public List<Object> select(Fields selector) {
        return this.getFields().select(selector, this.values);
    }

    @Override
    public TopologyAPI.StreamId getSourceGlobalStreamId() {
        return this.stream;
    }

    @Override
    public String getSourceComponent() {
        return this.stream.getComponentName();
    }

    @Override
    public int getSourceTask() {
        return this.sourceTaskId;
    }

    @Override
    public String getSourceStreamId() {
        return this.stream.getId();
    }

    public String toString() {
        return "source: " + this.getSourceComponent() + ", stream: " + this.getSourceStreamId() + ", " + this.values.toString();
    }

    public boolean equals(Object other) {
        return this == other;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public void resetValues() {
        this.values = null;
    }

    public long getCreationTime() {
        return this.creationTime;
    }
}

