/*
 * Decompiled with CFR 0.152.
 */
package org.apache.heron.simulator.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.heron.api.generated.TopologyAPI;
import org.apache.heron.proto.system.HeronTuples;

public class TupleCache {
    private final Map<Integer, TupleList> cache = new HashMap<Integer, TupleList>();

    protected TupleList get(int destTaskId) {
        TupleList list = this.cache.get(destTaskId);
        if (list == null) {
            list = new TupleList();
            this.cache.put(destTaskId, list);
        }
        return list;
    }

    public long addDataTuple(int srcTaskId, int destTaskId, TopologyAPI.StreamId streamId, HeronTuples.HeronDataTuple tuple, boolean isAnchored) {
        return this.get(destTaskId).addDataTuple(srcTaskId, streamId, tuple, isAnchored);
    }

    public void addAckTuple(int srcTaskId, int taskId, HeronTuples.AckTuple tuple) {
        this.get(taskId).addAckTuple(srcTaskId, tuple);
    }

    public void addFailTuple(int srcTaskId, int taskId, HeronTuples.AckTuple tuple) {
        this.get(taskId).addFailTuple(srcTaskId, tuple);
    }

    public void addEmitTuple(int srcTaskId, int taskId, HeronTuples.AckTuple tuple) {
        this.get(taskId).addEmitTuple(srcTaskId, tuple);
    }

    public Map<Integer, List<HeronTuples.HeronTupleSet>> getCache() {
        HashMap<Integer, List<HeronTuples.HeronTupleSet>> res = new HashMap<Integer, List<HeronTuples.HeronTupleSet>>();
        for (Map.Entry<Integer, TupleList> entry : this.cache.entrySet()) {
            res.put(entry.getKey(), entry.getValue().getTuplesList());
        }
        return res;
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void clear() {
        this.cache.clear();
    }

    protected static class TupleList {
        private final List<HeronTuples.HeronTupleSet> tuples = new LinkedList<HeronTuples.HeronTupleSet>();
        private final Random random = new Random();
        private HeronTuples.HeronTupleSet.Builder current;

        public long addDataTuple(int srcTaskId, TopologyAPI.StreamId streamId, HeronTuples.HeronDataTuple tuple, boolean isAnchored) {
            if (this.current == null || this.current.hasControl() || this.current.getSrcTaskId() != srcTaskId || !this.current.getDataBuilder().getStream().getComponentName().equals(streamId.getComponentName()) || !this.current.getDataBuilder().getStream().getId().equals(streamId.getId())) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
                this.current.getDataBuilder().setStream(streamId);
                this.current.setSrcTaskId(srcTaskId);
            }
            long tupleKey = -1L;
            if (isAnchored) {
                tupleKey = this.random.nextLong();
                this.current.getDataBuilder().addTuples(HeronTuples.HeronDataTuple.newBuilder().mergeFrom(tuple).setKey(tupleKey));
            } else {
                this.current.getDataBuilder().addTuples(tuple);
            }
            return tupleKey;
        }

        public void addAckTuple(int srcTaskId, HeronTuples.AckTuple tuple) {
            if (this.current == null || this.current.hasData() || this.current.getSrcTaskId() != srcTaskId || this.current.getControlBuilder().getFailsCount() > 0 || this.current.getControlBuilder().getEmitsCount() > 0) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
                this.current.setSrcTaskId(srcTaskId);
            }
            this.current.getControlBuilder().addAcks(tuple);
        }

        public void addFailTuple(int srcTaskId, HeronTuples.AckTuple tuple) {
            if (this.current == null || this.current.hasData() || this.current.getSrcTaskId() != srcTaskId || this.current.getControlBuilder().getAcksCount() > 0 || this.current.getControlBuilder().getEmitsCount() > 0) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
                this.current.setSrcTaskId(srcTaskId);
            }
            this.current.getControlBuilder().addFails(tuple);
        }

        public void addEmitTuple(int srcTaskId, HeronTuples.AckTuple tuple) {
            if (this.current == null || this.current.hasData() || this.current.getSrcTaskId() != srcTaskId || this.current.getControlBuilder().getAcksCount() > 0 || this.current.getControlBuilder().getFailsCount() > 0) {
                if (this.current != null) {
                    this.tuples.add(this.current.build());
                }
                this.current = HeronTuples.HeronTupleSet.newBuilder();
                this.current.setSrcTaskId(srcTaskId);
            }
            this.current.getControlBuilder().addEmits(tuple);
        }

        public List<HeronTuples.HeronTupleSet> getTuplesList() {
            if (this.current != null) {
                this.tuples.add(this.current.build());
                this.current = null;
            }
            return this.tuples;
        }

        public void clear() {
            this.current = null;
            this.tuples.clear();
        }
    }
}

