/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpState;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.protocol.HttpContext;

public class ResponseProcessCookies
implements HttpResponseInterceptor {
    private static final Log LOG = LogFactory.getLog((Class)ResponseProcessCookies.class);

    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        HttpState state = (HttpState)context.getAttribute("http.state");
        if (state == null) {
            LOG.info((Object)"HTTP state not available in HTTP context");
            return;
        }
        CookieSpec cookieSpec = (CookieSpec)context.getAttribute("http.cookie-spec");
        if (cookieSpec == null) {
            LOG.info((Object)"CookieSpec not available in HTTP context");
            return;
        }
        CookieOrigin cookieOrigin = (CookieOrigin)context.getAttribute("http.cookie-origin");
        if (cookieOrigin == null) {
            LOG.info((Object)"CookieOrigin not available in HTTP context");
            return;
        }
        Header[] headers = response.getHeaders("Set-Cookie");
        ResponseProcessCookies.processCookies(headers, cookieSpec, cookieOrigin, state);
    }

    private static void processCookies(Header[] headers, CookieSpec cookieSpec, CookieOrigin cookieOrigin, HttpState state) {
        for (int i = 0; i < headers.length; ++i) {
            Header header = headers[i];
            try {
                Cookie[] cookies = cookieSpec.parse(header, cookieOrigin);
                for (int c = 0; c < cookies.length; ++c) {
                    Cookie cookie = cookies[c];
                    try {
                        cookieSpec.validate(cookie, cookieOrigin);
                        state.addCookie(cookie);
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)("Cookie accepted: \"" + cookie + "\". "));
                        continue;
                    }
                    catch (MalformedCookieException ex) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)("Cookie rejected: \"" + cookie + "\". " + ex.getMessage()));
                    }
                }
                continue;
            }
            catch (MalformedCookieException ex) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)("Invalid cookie header: \"" + header + "\". " + ex.getMessage()));
            }
        }
    }
}

