/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.net.InetAddress;
import java.util.Date;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.conn.HttpRoutedConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpec;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.cookie.IgnoreSpecFactory;
import org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.http.impl.cookie.RFC2109SpecFactory;
import org.apache.http.impl.cookie.RFC2965SpecFactory;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRequestAddCookies {
    private HttpHost target;
    private CookieStore cookieStore;
    private CookieSpecRegistry cookieSpecRegistry;

    @Before
    public void setUp() {
        this.target = new HttpHost("localhost.local", 80);
        this.cookieStore = new BasicCookieStore();
        BasicClientCookie2 cookie1 = new BasicClientCookie2("name1", "value1");
        cookie1.setVersion(1);
        cookie1.setDomain("localhost.local");
        cookie1.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie1);
        BasicClientCookie2 cookie2 = new BasicClientCookie2("name2", "value2");
        cookie2.setVersion(1);
        cookie2.setDomain("localhost.local");
        cookie2.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie2);
        this.cookieSpecRegistry = new CookieSpecRegistry();
        this.cookieSpecRegistry.register("best-match", (CookieSpecFactory)new BestMatchSpecFactory());
        this.cookieSpecRegistry.register("compatibility", (CookieSpecFactory)new BrowserCompatSpecFactory());
        this.cookieSpecRegistry.register("netscape", (CookieSpecFactory)new NetscapeDraftSpecFactory());
        this.cookieSpecRegistry.register("rfc2109", (CookieSpecFactory)new RFC2109SpecFactory());
        this.cookieSpecRegistry.register("rfc2965", (CookieSpecFactory)new RFC2965SpecFactory());
        this.cookieSpecRegistry.register("ignoreCookies", (CookieSpecFactory)new IgnoreSpecFactory());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process(null, (HttpContext)context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, null);
    }

    @Test
    public void testAddCookies() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)2L, (long)headers1.length);
        Assert.assertEquals((Object)"$Version=1; name1=\"value1\"", (Object)headers1[0].getValue());
        Assert.assertEquals((Object)"$Version=1; name2=\"value2\"", (Object)headers1[1].getValue());
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
        CookieOrigin cookieOrigin = (CookieOrigin)context.getAttribute("http.cookie-origin");
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)this.target.getPort(), (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/", (Object)cookieOrigin.getPath());
        Assert.assertFalse((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testCookiesForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)0L, (long)headers1.length);
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    @Test
    public void testNoCookieStore() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", null);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)0L, (long)headers1.length);
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    @Test
    public void testNoCookieSpecRegistry() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", null);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)0L, (long)headers1.length);
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    @Test
    public void testNoTargetHost() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", null);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)0L, (long)headers1.length);
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    @Test
    public void testNoHttpConnection() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", null);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)0L, (long)headers1.length);
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    @Test
    public void testAddCookiesUsingExplicitCookieSpec() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.getParams().setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        CookieSpec cookieSpec = (CookieSpec)context.getAttribute("http.cookie-spec");
        Assert.assertTrue((boolean)(cookieSpec instanceof BrowserCompatSpec));
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)1L, (long)headers1.length);
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)headers1[0].getValue());
    }

    @Test(expected=HttpException.class)
    public void testAuthScopeInvalidRequestURI() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "crap:");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
    }

    @Test
    public void testAuthScopeRemotePortWhenDirect() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff");
        this.target = new HttpHost("localhost.local");
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)conn.getRemoteAddress()).thenReturn((Object)InetAddress.getByName("localhost"));
        Mockito.when((Object)conn.getRemotePort()).thenReturn((Object)1234);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        CookieOrigin cookieOrigin = (CookieOrigin)context.getAttribute("http.cookie-origin");
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)1234L, (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/stuff", (Object)cookieOrigin.getPath());
        Assert.assertFalse((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testAuthDefaultHttpPortWhenProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff");
        this.target = new HttpHost("localhost.local");
        HttpRoute route = new HttpRoute(this.target, null, new HttpHost("localhost", 8888), false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)conn.getRemotePort()).thenReturn((Object)1234);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        CookieOrigin cookieOrigin = (CookieOrigin)context.getAttribute("http.cookie-origin");
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)80L, (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/stuff", (Object)cookieOrigin.getPath());
        Assert.assertFalse((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testAuthDefaultHttpsPortWhenProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/stuff");
        this.target = new HttpHost("localhost", -1, "https");
        HttpRoute route = new HttpRoute(this.target, null, new HttpHost("localhost", 8888), true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)conn.getRemoteAddress()).thenReturn((Object)InetAddress.getByName("localhost"));
        Mockito.when((Object)conn.getRemotePort()).thenReturn((Object)1234);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        CookieOrigin cookieOrigin = (CookieOrigin)context.getAttribute("http.cookie-origin");
        Assert.assertNotNull((Object)cookieOrigin);
        Assert.assertEquals((Object)this.target.getHostName(), (Object)cookieOrigin.getHost());
        Assert.assertEquals((long)443L, (long)cookieOrigin.getPort());
        Assert.assertEquals((Object)"/stuff", (Object)cookieOrigin.getPath());
        Assert.assertTrue((boolean)cookieOrigin.isSecure());
    }

    @Test
    public void testExcludeExpiredCookies() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicClientCookie2 cookie3 = new BasicClientCookie2("name3", "value3");
        cookie3.setVersion(1);
        cookie3.setDomain("localhost.local");
        cookie3.setPath("/");
        cookie3.setExpiryDate(new Date(System.currentTimeMillis() - 86400000L));
        this.cookieStore.addCookie((Cookie)cookie3);
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)2L, (long)headers1.length);
        Assert.assertEquals((Object)"$Version=1; name1=\"value1\"", (Object)headers1[0].getValue());
        Assert.assertEquals((Object)"$Version=1; name2=\"value2\"", (Object)headers1[1].getValue());
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    @Test
    public void testNoMatchingCookies() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.cookieStore.clear();
        BasicClientCookie cookie3 = new BasicClientCookie("name3", "value3");
        cookie3.setDomain("www.somedomain.com");
        cookie3.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie3);
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)0L, (long)headers1.length);
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)0L, (long)headers2.length);
    }

    private BasicClientCookie makeCookie(String name, String value, String domain, String path) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        cookie.setDomain(domain);
        cookie.setPath(path);
        return cookie;
    }

    @Test
    public void testCookieOrder() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/foobar/yada/yada");
        this.cookieStore.clear();
        this.cookieStore.addCookie((Cookie)this.makeCookie("nomatch", "value", "localhost.local", "/noway"));
        this.cookieStore.addCookie((Cookie)this.makeCookie("name2", "value", "localhost.local", "/foobar/yada"));
        this.cookieStore.addCookie((Cookie)this.makeCookie("name3", "value", "localhost.local", "/foobar"));
        this.cookieStore.addCookie((Cookie)this.makeCookie("name1", "value", "localhost.local", "/foobar/yada/yada"));
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)1L, (long)headers1.length);
        Assert.assertEquals((Object)"name1=value; name2=value; name3=value", (Object)headers1[0].getValue());
    }

    @Test
    public void testAddSpecVersionHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.cookieStore.clear();
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value1");
        cookie1.setVersion(0);
        cookie1.setDomain("localhost.local");
        cookie1.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie1);
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "value2");
        cookie2.setVersion(0);
        cookie2.setDomain("localhost.local");
        cookie2.setPath("/");
        this.cookieStore.addCookie((Cookie)cookie2);
        HttpRoute route = new HttpRoute(this.target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        Mockito.when((Object)conn.isSecure()).thenReturn((Object)Boolean.FALSE);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.cookie-store", (Object)this.cookieStore);
        context.setAttribute("http.cookiespec-registry", (Object)this.cookieSpecRegistry);
        RequestAddCookies interceptor = new RequestAddCookies();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers1 = request.getHeaders("Cookie");
        Assert.assertNotNull((Object)headers1);
        Assert.assertEquals((long)1L, (long)headers1.length);
        Assert.assertEquals((Object)"name1=value1; name2=value2", (Object)headers1[0].getValue());
        Header[] headers2 = request.getHeaders("Cookie2");
        Assert.assertNotNull((Object)headers2);
        Assert.assertEquals((long)1L, (long)headers2.length);
        Assert.assertEquals((Object)"$Version=1", (Object)headers2[0].getValue());
    }
}

