/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.protocol.ResponseAuthCache;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;

public class TestResponseAuthCache {
    private HttpHost target;
    private HttpHost proxy;
    private Credentials creds1;
    private Credentials creds2;
    private AuthScope authscope1;
    private AuthScope authscope2;
    private BasicScheme authscheme1;
    private BasicScheme authscheme2;
    private AuthState targetState;
    private AuthState proxyState;

    @Before
    public void setUp() throws Exception {
        this.target = new HttpHost("localhost", 80);
        this.proxy = new HttpHost("localhost", 8080);
        this.creds1 = new UsernamePasswordCredentials("user1", "secret1");
        this.creds2 = new UsernamePasswordCredentials("user2", "secret2");
        this.authscope1 = new AuthScope(this.target.getHostName(), this.target.getPort());
        this.authscope2 = new AuthScope(this.proxy.getHostName(), this.proxy.getPort());
        this.authscheme1 = new BasicScheme();
        this.authscheme2 = new BasicScheme();
        this.targetState = new AuthState();
        this.proxyState = new AuthState();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testResponseParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process(null, (HttpContext)context);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testContextParameterCheck() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, null);
    }

    @Test
    public void testTargetAndProxyAuthCaching() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.authscheme1.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm"));
        this.authscheme2.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=auth-realm"));
        this.targetState.setAuthScheme((AuthScheme)this.authscheme1);
        this.targetState.setCredentials(this.creds1);
        this.targetState.setAuthScope(this.authscope1);
        this.proxyState.setAuthScheme((AuthScheme)this.authscheme2);
        this.proxyState.setCredentials(this.creds2);
        this.proxyState.setAuthScope(this.authscope2);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNotNull((Object)authCache);
        Assert.assertSame((Object)this.authscheme1, (Object)authCache.get(this.target));
        Assert.assertSame((Object)this.authscheme2, (Object)authCache.get(this.proxy));
    }

    @Test
    public void testNoAuthStateInitialized() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNull((Object)authCache);
    }

    @Test
    public void testNoAuthSchemeSelected() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNull((Object)authCache);
    }

    @Test
    public void testAuthSchemeNotCompleted() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.targetState.setAuthScheme((AuthScheme)this.authscheme1);
        this.targetState.setCredentials(this.creds1);
        this.targetState.setAuthScope(this.authscope1);
        this.proxyState.setAuthScheme((AuthScheme)this.authscheme2);
        this.proxyState.setCredentials(this.creds2);
        this.proxyState.setAuthScope(this.authscope2);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNull((Object)authCache);
    }

    @Test
    public void testNotChallenged() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.authscheme1.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm"));
        this.authscheme2.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=auth-realm"));
        this.targetState.setAuthScheme((AuthScheme)this.authscheme1);
        this.targetState.setCredentials(this.creds1);
        this.targetState.setAuthScope(null);
        this.proxyState.setAuthScheme((AuthScheme)this.authscheme2);
        this.proxyState.setCredentials(this.creds2);
        this.proxyState.setAuthScope(null);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNotNull((Object)authCache);
        Assert.assertNull((Object)authCache.get(this.target));
        Assert.assertNull((Object)authCache.get(this.proxy));
    }

    @Test
    public void testInvalidateCachingOnAuthFailure() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        this.authscheme1.processChallenge((Header)new BasicHeader("WWW-Authenticate", "BASIC realm=auth-realm"));
        this.authscheme2.processChallenge((Header)new BasicHeader("Proxy-Authenticate", "BASIC realm=auth-realm"));
        this.targetState.setAuthScheme((AuthScheme)this.authscheme1);
        this.targetState.setCredentials(null);
        this.targetState.setAuthScope(this.authscope1);
        this.proxyState.setAuthScheme((AuthScheme)this.authscheme2);
        this.proxyState.setCredentials(null);
        this.proxyState.setAuthScope(this.authscope2);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.target_host", (Object)this.target);
        context.setAttribute("http.proxy_host", (Object)this.proxy);
        context.setAttribute("http.auth.target-scope", (Object)this.targetState);
        context.setAttribute("http.auth.proxy-scope", (Object)this.proxyState);
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(this.target, (AuthScheme)this.authscheme1);
        authCache.put(this.proxy, (AuthScheme)this.authscheme2);
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        ResponseAuthCache interceptor = new ResponseAuthCache();
        interceptor.process((HttpResponse)response, (HttpContext)context);
        Assert.assertNull((Object)authCache.get(this.target));
        Assert.assertNull((Object)authCache.get(this.proxy));
    }
}

