/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestUriEscapes
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    private void doTest(String uri, boolean relative) throws Exception {
        HttpResponse response;
        InetSocketAddress address = this.localServer.getServiceAddress();
        int port = address.getPort();
        String host = address.getHostName();
        UriListeningService listener = new UriListeningService();
        this.localServer.register("*", listener);
        DefaultHttpClient client = new DefaultHttpClient();
        if (!relative) {
            String request = "http://" + host + ":" + port + uri;
            HttpGet httpget = new HttpGet(request);
            response = client.execute((HttpUriRequest)httpget);
            EntityUtils.consume((HttpEntity)response.getEntity());
        } else {
            HttpHost target = new HttpHost(host, port);
            HttpGet httpget = new HttpGet(uri);
            response = client.execute(target, (HttpRequest)httpget);
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)uri, (Object)listener.getRequestedUri());
    }

    @Test
    public void testEscapedAmpersandInQueryAbsolute() throws Exception {
        this.doTest("/path/a=b&c=%26d", false);
    }

    @Test
    public void testEscapedAmpersandInQueryRelative() throws Exception {
        this.doTest("/path/a=b&c=%26d", true);
    }

    @Test
    public void testPlusInPathAbsolute() throws Exception {
        this.doTest("/path+go", false);
    }

    @Test
    public void testPlusInPathRelative() throws Exception {
        this.doTest("/path+go", true);
    }

    @Test
    public void testEscapedSpaceInPathAbsolute() throws Exception {
        this.doTest("/path%20go?a=b&c=d", false);
    }

    @Test
    public void testEscapedSpaceInPathRelative() throws Exception {
        this.doTest("/path%20go?a=b&c=d", true);
    }

    @Test
    public void testEscapedAmpersandInPathAbsolute() throws Exception {
        this.doTest("/this%26that?a=b&c=d", false);
    }

    @Test
    public void testEscapedAmpersandInPathRelative() throws Exception {
        this.doTest("/this%26that?a=b&c=d", true);
    }

    @Test
    public void testEscapedSpaceInQueryAbsolute() throws Exception {
        this.doTest("/path?a=b&c=d%20e", false);
    }

    @Test
    public void testEscapedSpaceInQueryRelative() throws Exception {
        this.doTest("/path?a=b&c=d%20e", true);
    }

    @Test
    public void testPlusInQueryAbsolute() throws Exception {
        this.doTest("/path?a=b&c=d+e", false);
    }

    @Test
    public void testPlusInQueryRelative() throws Exception {
        this.doTest("/path?a=b&c=d+e", true);
    }

    private static class UriListeningService
    implements HttpRequestHandler {
        private volatile String requestedUri;

        private UriListeningService() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            this.requestedUri = request.getRequestLine().getUri();
            response.setStatusLine(ver, 200);
            StringEntity entity = new StringEntity("Response Body");
            response.setEntity((HttpEntity)entity);
        }

        public String getRequestedUri() {
            return this.requestedUri;
        }
    }
}

