/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSSLSocketFactory
extends BasicServerTestBase {
    private SSLContext serverSSLContext;
    private SSLContext clientSSLContext;

    private KeyManagerFactory createKeyManagerFactory() throws NoSuchAlgorithmException {
        String algo = KeyManagerFactory.getDefaultAlgorithm();
        try {
            return KeyManagerFactory.getInstance(algo);
        }
        catch (NoSuchAlgorithmException ex) {
            return KeyManagerFactory.getInstance("SunX509");
        }
    }

    private TrustManagerFactory createTrustManagerFactory() throws NoSuchAlgorithmException {
        String algo = TrustManagerFactory.getDefaultAlgorithm();
        try {
            return TrustManagerFactory.getInstance(algo);
        }
        catch (NoSuchAlgorithmException ex) {
            return TrustManagerFactory.getInstance("SunX509");
        }
    }

    @Before
    public void setUp() throws Exception {
        ClassLoader cl = this.getClass().getClassLoader();
        URL url = cl.getResource("test.keystore");
        KeyStore keystore = KeyStore.getInstance("jks");
        char[] pwd = "nopassword".toCharArray();
        keystore.load(url.openStream(), pwd);
        TrustManagerFactory tmf = this.createTrustManagerFactory();
        tmf.init(keystore);
        TrustManager[] tm = tmf.getTrustManagers();
        KeyManagerFactory kmfactory = this.createKeyManagerFactory();
        kmfactory.init(keystore, pwd);
        KeyManager[] km = kmfactory.getKeyManagers();
        this.serverSSLContext = SSLContext.getInstance("TLS");
        this.serverSSLContext.init(km, tm, null);
        this.clientSSLContext = SSLContext.getInstance("TLS");
        this.clientSSLContext.init(null, tm, null);
        this.localServer = new LocalTestServer(this.serverSSLContext);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    protected HttpHost getServerHttp() {
        InetSocketAddress address = this.localServer.getServiceAddress();
        return new HttpHost(address.getHostName(), address.getPort(), "https");
    }

    @Test
    public void testBasicSSL() throws Exception {
        TestX509HostnameVerifier hostVerifier = new TestX509HostnameVerifier();
        SSLSocketFactory socketFactory = new SSLSocketFactory(this.clientSSLContext, (X509HostnameVerifier)hostVerifier);
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getConnectionManager().getSchemeRegistry().register(https);
        HttpHost target = this.getServerHttp();
        HttpGet httpget = new HttpGet("/random/100");
        HttpResponse response = httpclient.execute(target, (HttpRequest)httpget);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)hostVerifier.isFired());
    }

    @Test(expected=SSLPeerUnverifiedException.class)
    public void testSSLTrustVerification() throws Exception {
        SSLContext defaultsslcontext = SSLContext.getInstance("TLS");
        defaultsslcontext.init(null, null, null);
        SSLSocketFactory socketFactory = new SSLSocketFactory(defaultsslcontext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getConnectionManager().getSchemeRegistry().register(https);
        HttpHost target = this.getServerHttp();
        HttpGet httpget = new HttpGet("/random/100");
        httpclient.execute(target, (HttpRequest)httpget);
    }

    @Test
    public void testSSLTrustVerificationOverride() throws Exception {
        SSLContext defaultsslcontext = SSLContext.getInstance("TLS");
        defaultsslcontext.init(null, null, null);
        SSLSocketFactory socketFactory = new SSLSocketFactory(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return chain.length == 1;
            }
        }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)socketFactory);
        DefaultHttpClient httpclient = new DefaultHttpClient();
        httpclient.getConnectionManager().getSchemeRegistry().register(https);
        HttpHost target = this.getServerHttp();
        HttpGet httpget = new HttpGet("/random/100");
        HttpResponse response = httpclient.execute(target, (HttpRequest)httpget);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    static class TestX509HostnameVerifier
    implements X509HostnameVerifier {
        private boolean fired = false;

        TestX509HostnameVerifier() {
        }

        public boolean verify(String host, SSLSession session) {
            return true;
        }

        public void verify(String host, SSLSocket ssl) throws IOException {
            this.fired = true;
        }

        public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
        }

        public void verify(String host, X509Certificate cert) throws SSLException {
        }

        public boolean isFired() {
            return this.fired;
        }
    }
}

