/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.RFC2617Scheme;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.junit.Assert;
import org.junit.Test;

public class TestRFC2617Scheme {
    @Test
    public void testProcessChallenge() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("WWW-Authenticate", "Test realm=\"realm1\", test, test1 =  stuff, test2 =  \"stuff, stuff\", test3=\"crap");
        authscheme.processChallenge((Header)header);
        Assert.assertEquals((Object)"test", (Object)authscheme.getSchemeName());
        Assert.assertEquals((Object)"realm1", (Object)authscheme.getParameter("realm"));
        Assert.assertEquals(null, (Object)authscheme.getParameter("test"));
        Assert.assertEquals((Object)"stuff", (Object)authscheme.getParameter("test1"));
        Assert.assertEquals((Object)"stuff, stuff", (Object)authscheme.getParameter("test2"));
        Assert.assertEquals((Object)"\"crap", (Object)authscheme.getParameter("test3"));
    }

    @Test
    public void testProcessChallengeWithLotsOfBlanks() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append(" WWW-Authenticate:    Test       realm=\"realm1\"");
        BufferedHeader header = new BufferedHeader(buffer);
        authscheme.processChallenge((Header)header);
        Assert.assertEquals((Object)"test", (Object)authscheme.getSchemeName());
        Assert.assertEquals((Object)"realm1", (Object)authscheme.getParameter("realm"));
    }

    @Test(expected=MalformedChallengeException.class)
    public void testInvalidHeader() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("whatever", "Test realm=\"realm1\"");
        authscheme.processChallenge((Header)header);
    }

    @Test(expected=MalformedChallengeException.class)
    public void testEmptyHeader() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("WWW-Authenticate", "Test    ");
        authscheme.processChallenge((Header)header);
    }

    @Test(expected=MalformedChallengeException.class)
    public void testInvalidHeaderValue() throws Exception {
        TestAuthScheme authscheme = new TestAuthScheme();
        BasicHeader header = new BasicHeader("whatever", "whatever");
        authscheme.processChallenge((Header)header);
    }

    static class TestAuthScheme
    extends RFC2617Scheme {
        TestAuthScheme() {
        }

        public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
            return null;
        }

        public String getSchemeName() {
            return "test";
        }

        public boolean isComplete() {
            return false;
        }

        public boolean isConnectionBased() {
            return false;
        }
    }
}

