/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRequestWrapper
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    @Test
    public void testRequestURIRewriting() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        DefaultHttpClient client = new DefaultHttpClient();
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port + "/path";
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)(reqWrapper instanceof RequestWrapper));
        Assert.assertEquals((Object)"/path", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testRequestURIRewritingEmptyPath() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        DefaultHttpClient client = new DefaultHttpClient();
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)(reqWrapper instanceof RequestWrapper));
        Assert.assertEquals((Object)"/", (Object)reqWrapper.getRequestLine().getUri());
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

