/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.GetConnThread;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.EntityUtils;

public class ExecReqThread
extends GetConnThread {
    protected final ClientConnectionManager conn_manager;
    protected final RequestSpec request_spec;
    protected volatile HttpResponse response;
    protected volatile byte[] response_data;

    public ExecReqThread(ClientConnectionManager mgr, HttpRoute route, long timeout, RequestSpec reqspec) {
        super(mgr, route, timeout);
        this.conn_manager = mgr;
        this.request_spec = reqspec;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public byte[] getResponseData() {
        return this.response_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        super.run();
        if (this.connection == null) {
            return;
        }
        try {
            this.request_spec.context.setAttribute("http.connection", (Object)this.connection);
            this.doOpenConnection();
            HttpRequest request = (HttpRequest)this.request_spec.context.getAttribute("http.request");
            this.request_spec.executor.preProcess(request, this.request_spec.processor, this.request_spec.context);
            this.response = this.request_spec.executor.execute(request, (HttpClientConnection)this.connection, this.request_spec.context);
            this.request_spec.executor.postProcess(this.response, this.request_spec.processor, this.request_spec.context);
            this.doConsumeResponse();
        }
        catch (Throwable dart) {
            dart.printStackTrace(System.out);
            if (this.exception != null) {
                this.exception = dart;
            }
        }
        finally {
            this.conn_manager.releaseConnection(this.connection, -1L, null);
        }
    }

    protected void doOpenConnection() throws Exception {
        this.connection.open(this.conn_route, this.request_spec.context, this.request_spec.params);
    }

    protected void doConsumeResponse() throws Exception {
        if (this.response.getEntity() != null) {
            this.response_data = EntityUtils.toByteArray((HttpEntity)this.response.getEntity());
        }
    }

    public static class RequestSpec {
        public HttpRequestExecutor executor;
        public HttpProcessor processor;
        public HttpContext context;
        public HttpParams params;
    }
}

