/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.util.concurrent.TimeUnit;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.conn.ClientConnAdapterMockup;
import org.apache.http.impl.conn.GetConnThread;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.junit.Assert;
import org.junit.Test;

public class TestTSCCMNoServer {
    private static ManagedClientConnection getConnection(ClientConnectionManager mgr, HttpRoute route, long timeout, TimeUnit unit) throws ConnectionPoolTimeoutException, InterruptedException {
        ClientConnectionRequest connRequest = mgr.requestConnection(route, null);
        return connRequest.getConnection(timeout, unit);
    }

    private static ManagedClientConnection getConnection(ClientConnectionManager mgr, HttpRoute route) throws ConnectionPoolTimeoutException, InterruptedException {
        ClientConnectionRequest connRequest = mgr.requestConnection(route, null);
        return connRequest.getConnection(0L, null);
    }

    public ThreadSafeClientConnManager createTSCCM(SchemeRegistry schreg) {
        if (schreg == null) {
            schreg = this.createSchemeRegistry();
        }
        return new ThreadSafeClientConnManager(schreg);
    }

    public HttpParams createDefaultParams() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        return params;
    }

    public SchemeRegistry createSchemeRegistry() {
        SchemeRegistry schreg = new SchemeRegistry();
        schreg.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        return schreg;
    }

    @Test
    public void testConstructor() {
        SchemeRegistry schreg = this.createSchemeRegistry();
        ThreadSafeClientConnManager mgr = new ThreadSafeClientConnManager(schreg);
        Assert.assertNotNull((Object)mgr);
        mgr.shutdown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalConstructor() {
        new ThreadSafeClientConnManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testGetConnection() throws InterruptedException, ConnectionPoolTimeoutException {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertNotNull((Object)conn);
        Assert.assertNull((Object)conn.getRoute());
        Assert.assertFalse((boolean)conn.isOpen());
        mgr.releaseConnection(conn, -1L, null);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, null);
        }
        finally {
            mgr.shutdown();
        }
    }

    @Test
    public void testMaxConnTotal() throws InterruptedException, ConnectionPoolTimeoutException {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(2);
        mgr.setDefaultMaxPerRoute(1);
        HttpHost target1 = new HttpHost("www.test1.invalid", 80, "http");
        HttpRoute route1 = new HttpRoute(target1, null, false);
        HttpHost target2 = new HttpHost("www.test2.invalid", 80, "http");
        HttpRoute route2 = new HttpRoute(target2, null, false);
        ManagedClientConnection conn1 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1);
        Assert.assertNotNull((Object)conn1);
        ManagedClientConnection conn2 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2);
        Assert.assertNotNull((Object)conn2);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 100L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn2, -1L, null);
        conn2 = null;
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 100L, TimeUnit.MILLISECONDS);
        }
        catch (ConnectionPoolTimeoutException cptx) {
            Assert.fail((String)("connection should have been available: " + (Object)((Object)cptx)));
        }
        mgr.shutdown();
    }

    @Test
    public void testMaxConnPerHost() throws Exception {
        HttpHost target1 = new HttpHost("www.test1.invalid", 80, "http");
        HttpRoute route1 = new HttpRoute(target1, null, false);
        HttpHost target2 = new HttpHost("www.test2.invalid", 80, "http");
        HttpRoute route2 = new HttpRoute(target2, null, false);
        HttpHost target3 = new HttpHost("www.test3.invalid", 80, "http");
        HttpRoute route3 = new HttpRoute(target3, null, false);
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(100);
        mgr.setDefaultMaxPerRoute(1);
        mgr.setMaxForRoute(route2, 2);
        mgr.setMaxForRoute(route3, 3);
        ManagedClientConnection conn1 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        ManagedClientConnection conn2 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        ManagedClientConnection conn3 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn3);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        conn1 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 10L, TimeUnit.MILLISECONDS);
        conn2 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 10L, TimeUnit.MILLISECONDS);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        conn1 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1, 10L, TimeUnit.MILLISECONDS);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        try {
            mgr.releaseConnection(null, -1L, null);
            Assert.fail((String)"null connection adapter not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            mgr.releaseConnection((ManagedClientConnection)new ClientConnAdapterMockup(null), -1L, null);
            Assert.fail((String)"foreign connection adapter not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        mgr.shutdown();
    }

    @Test
    public void testReleaseConnection() throws Exception {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(3);
        mgr.setDefaultMaxPerRoute(1);
        HttpHost target1 = new HttpHost("www.test1.invalid", 80, "http");
        HttpRoute route1 = new HttpRoute(target1, null, false);
        HttpHost target2 = new HttpHost("www.test2.invalid", 80, "http");
        HttpRoute route2 = new HttpRoute(target2, null, false);
        HttpHost target3 = new HttpHost("www.test3.invalid", 80, "http");
        HttpRoute route3 = new HttpRoute(target3, null, false);
        ManagedClientConnection conn1 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1, 10L, TimeUnit.MILLISECONDS);
        ManagedClientConnection conn2 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 10L, TimeUnit.MILLISECONDS);
        ManagedClientConnection conn3 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn1);
        Assert.assertNotNull((Object)conn2);
        Assert.assertNotNull((Object)conn3);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn2, -1L, null);
        conn2 = null;
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        conn2 = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route2, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((Object)conn2);
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route3, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"ConnectionPoolTimeoutException should have been thrown");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.shutdown();
    }

    @Test
    public void testDeleteClosedConnections() throws InterruptedException, ConnectionPoolTimeoutException {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route);
        Assert.assertEquals((String)"connectionsInPool", (long)mgr.getConnectionsInPool(), (long)1L);
        Assert.assertEquals((String)"connectionsInPool(host)", (long)mgr.getConnectionsInPool(route), (long)1L);
        mgr.releaseConnection(conn, -1L, null);
        Assert.assertEquals((String)"connectionsInPool", (long)mgr.getConnectionsInPool(), (long)1L);
        Assert.assertEquals((String)"connectionsInPool(host)", (long)mgr.getConnectionsInPool(route), (long)1L);
        mgr.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)"connectionsInPool", (long)mgr.getConnectionsInPool(), (long)0L);
        Assert.assertEquals((String)"connectionsInPool(host)", (long)mgr.getConnectionsInPool(route), (long)0L);
        mgr.shutdown();
    }

    @Test
    public void testShutdown() throws Exception {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(1);
        mgr.setDefaultMaxPerRoute(1);
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 1L, TimeUnit.MILLISECONDS);
        GetConnThread gct = new GetConnThread((ClientConnectionManager)mgr, route, 0L);
        gct.start();
        Thread.sleep(100L);
        mgr.shutdown();
        mgr.releaseConnection(conn, -1L, null);
        gct.join(10000L);
        Assert.assertNull((String)"thread should not have obtained connection", (Object)gct.getConnection());
        Assert.assertNotNull((String)"thread should have gotten an exception", (Object)gct.getException());
        Assert.assertSame((String)"thread got wrong exception", IllegalStateException.class, gct.getException().getClass());
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 1L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"shut-down manager does not raise exception");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
    }

    @Test
    public void testInterruptThread() throws Exception {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(1);
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 1L, TimeUnit.MILLISECONDS);
        GetConnThread gct = new GetConnThread((ClientConnectionManager)mgr, route, 0L);
        gct.start();
        Thread.sleep(100L);
        gct.interrupt();
        gct.join(10000L);
        Assert.assertNotNull((String)"thread should have gotten an exception", (Object)gct.getException());
        Assert.assertSame((String)"thread got wrong exception", InterruptedException.class, gct.getException().getClass());
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have gotten a timeout");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn, -1L, null);
        conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((String)"should have gotten a connection", (Object)conn);
        mgr.shutdown();
    }

    @Test
    public void testReusePreference() throws Exception {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(1);
        HttpHost target1 = new HttpHost("www.test1.invalid", 80, "http");
        HttpRoute route1 = new HttpRoute(target1, null, false);
        HttpHost target2 = new HttpHost("www.test2.invalid", 80, "http");
        HttpRoute route2 = new HttpRoute(target2, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route1, 1L, TimeUnit.MILLISECONDS);
        GetConnThread gct1 = new GetConnThread((ClientConnectionManager)mgr, route1, 1000L);
        GetConnThread gct2 = new GetConnThread((ClientConnectionManager)mgr, route2, 1000L);
        gct2.start();
        Thread.sleep(100L);
        gct1.start();
        Thread.sleep(100L);
        mgr.releaseConnection(conn, -1L, null);
        gct1.join(10000L);
        gct2.join(10000L);
        Assert.assertNotNull((String)"thread 1 should have gotten a connection", (Object)gct1.getConnection());
        Assert.assertNull((String)"thread 2 should NOT have gotten a connection", (Object)gct2.getConnection());
        mgr.shutdown();
    }

    @Test
    public void testAbortAfterRequestStarts() throws Exception {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(1);
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 1L, TimeUnit.MILLISECONDS);
        ClientConnectionRequest request = mgr.requestConnection(route, null);
        GetConnThread gct = new GetConnThread(request, route, 0L);
        gct.start();
        Thread.sleep(100L);
        request.abortRequest();
        gct.join(10000L);
        Assert.assertNotNull((String)"thread should have gotten an exception", (Object)gct.getException());
        Assert.assertSame((String)"thread got wrong exception", InterruptedException.class, gct.getException().getClass());
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have gotten a timeout");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn, -1L, null);
        conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((String)"should have gotten a connection", (Object)conn);
        mgr.shutdown();
    }

    @Test
    public void testAbortBeforeRequestStarts() throws Exception {
        ThreadSafeClientConnManager mgr = this.createTSCCM(null);
        mgr.setMaxTotal(1);
        HttpHost target = new HttpHost("www.test.invalid", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        ManagedClientConnection conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 1L, TimeUnit.MILLISECONDS);
        ClientConnectionRequest request = mgr.requestConnection(route, null);
        request.abortRequest();
        GetConnThread gct = new GetConnThread(request, route, 0L);
        gct.start();
        Thread.sleep(100L);
        gct.join(10000L);
        Assert.assertNotNull((String)"thread should have gotten an exception", (Object)gct.getException());
        Assert.assertSame((String)"thread got wrong exception", InterruptedException.class, gct.getException().getClass());
        try {
            TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"should have gotten a timeout");
        }
        catch (ConnectionPoolTimeoutException e) {
            // empty catch block
        }
        mgr.releaseConnection(conn, -1L, null);
        conn = TestTSCCMNoServer.getConnection((ClientConnectionManager)mgr, route, 10L, TimeUnit.MILLISECONDS);
        Assert.assertNotNull((String)"should have gotten a connection", (Object)conn);
        mgr.shutdown();
    }
}

