/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.Before;
import org.junit.Test;

public class TestHttpClientUtils
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.localServer = new LocalTestServer(httpproc, null);
    }

    @Test
    public void testCloseQuietlyClient() throws Exception {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }

    @Test
    public void testCloseQuietlyNullClient() throws Exception {
        HttpClient httpClient = null;
        HttpClientUtils.closeQuietly(httpClient);
    }

    @Test
    public void testCloseQuietlyClientTwice() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }

    @Test
    public void testCloseQuietlyResponse() throws Exception {
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpHost target = this.getServerHttp();
        HttpResponse response = httpClient.execute(target, (HttpRequest)new HttpGet("/"));
        HttpClientUtils.closeQuietly((HttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }

    @Test
    public void testCloseQuietlyResponseNull() throws Exception {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpResponse response = null;
        HttpClientUtils.closeQuietly(response);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }

    @Test
    public void testCloseQuietlyResponseTwice() throws Exception {
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpHost target = this.getServerHttp();
        HttpResponse response = httpClient.execute(target, (HttpRequest)new HttpGet("/"));
        HttpClientUtils.closeQuietly((HttpResponse)response);
        HttpClientUtils.closeQuietly((HttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }

    @Test
    public void testCloseQuietlyResponseAfterConsumeContent() throws Exception {
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionManager);
        HttpHost target = this.getServerHttp();
        HttpResponse response = httpClient.execute(target, (HttpRequest)new HttpGet("/"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpClientUtils.closeQuietly((HttpResponse)response);
        HttpClientUtils.closeQuietly((HttpClient)httpClient);
    }
}

