/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HTTP;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestURLEncodedUtils {
    private static final int[] SWISS_GERMAN_HELLO = new int[]{71, 114, 252, 101, 122, 105, 95, 122, 228, 109, 228};
    private static final int[] RUSSIAN_HELLO = new int[]{1042, 1089, 1077, 1084, 95, 1087, 1088, 1080, 1074, 1077, 1090};

    @Test
    public void testParseURI() throws Exception {
        List<NameValuePair> result = this.parse("", null);
        Assert.assertTrue((boolean)result.isEmpty());
        result = this.parse("Name0", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name0", null);
        result = this.parse("Name1=Value1", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name1", "Value1");
        result = this.parse("Name2=", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name2", "");
        result = this.parse("Name3", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name3", null);
        result = this.parse("Name4=Value+4%21", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name4", "Value 4!");
        result = this.parse("Name4=Value%2B4%21", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name4", "Value+4!");
        result = this.parse("Name4=Value+4%21+%214", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name4", "Value 4! !4");
        result = this.parse("Name5=aaa&Name6=bbb", null);
        Assert.assertEquals((long)2L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name5", "aaa");
        TestURLEncodedUtils.assertNameValuePair(result.get(1), "Name6", "bbb");
        result = this.parse("Name7=aaa&Name7=b%2Cb&Name7=ccc", null);
        Assert.assertEquals((long)3L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name7", "aaa");
        TestURLEncodedUtils.assertNameValuePair(result.get(1), "Name7", "b,b");
        TestURLEncodedUtils.assertNameValuePair(result.get(2), "Name7", "ccc");
        result = this.parse("Name8=xx%2C++yy++%2Czz", null);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair(result.get(0), "Name8", "xx,  yy  ,zz");
    }

    @Test
    public void testParseEntity() throws Exception {
        StringEntity entity = new StringEntity("Name1=Value1");
        entity.setContentType("application/x-www-form-urlencoded");
        List result = URLEncodedUtils.parse((HttpEntity)entity);
        Assert.assertEquals((long)1L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(0), "Name1", "Value1");
        entity.setContentType("text/test");
        Assert.assertTrue((boolean)URLEncodedUtils.parse((HttpEntity)entity).isEmpty());
    }

    private static String constructString(int[] unicodeChars) {
        StringBuffer buffer = new StringBuffer();
        if (unicodeChars != null) {
            for (int i = 0; i < unicodeChars.length; ++i) {
                buffer.append((char)unicodeChars[i]);
            }
        }
        return buffer.toString();
    }

    @Test
    public void testParseUTF8Entity() throws Exception {
        String ru_hello = TestURLEncodedUtils.constructString(RUSSIAN_HELLO);
        String ch_hello = TestURLEncodedUtils.constructString(SWISS_GERMAN_HELLO);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("russian", ru_hello));
        parameters.add(new BasicNameValuePair("swiss", ch_hello));
        String s = URLEncodedUtils.format(parameters, (Charset)Consts.UTF_8);
        Assert.assertEquals((Object)"russian=%D0%92%D1%81%D0%B5%D0%BC_%D0%BF%D1%80%D0%B8%D0%B2%D0%B5%D1%82&swiss=Gr%C3%BCezi_z%C3%A4m%C3%A4", (Object)s);
        StringEntity entity = new StringEntity(s, ContentType.create((String)"application/x-www-form-urlencoded", (Charset)Consts.UTF_8));
        List result = URLEncodedUtils.parse((HttpEntity)entity);
        Assert.assertEquals((long)2L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(0), "russian", ru_hello);
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(1), "swiss", ch_hello);
    }

    @Test
    public void testParseUTF8String() throws Exception {
        String ru_hello = TestURLEncodedUtils.constructString(RUSSIAN_HELLO);
        String ch_hello = TestURLEncodedUtils.constructString(SWISS_GERMAN_HELLO);
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("russian", ru_hello));
        parameters.add(new BasicNameValuePair("swiss", ch_hello));
        String s = URLEncodedUtils.format(parameters, (Charset)Consts.UTF_8);
        List result = URLEncodedUtils.parse((String)s, (Charset)Consts.UTF_8);
        Assert.assertEquals((long)2L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(0), "russian", ru_hello);
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(1), "swiss", ch_hello);
    }

    @Test
    public void testParseEntityDefaultContentType() throws Exception {
        String ch_hello = TestURLEncodedUtils.constructString(SWISS_GERMAN_HELLO);
        String us_hello = "hi there";
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("english", us_hello));
        parameters.add(new BasicNameValuePair("swiss", ch_hello));
        String s = URLEncodedUtils.format(parameters, (Charset)HTTP.DEF_CONTENT_CHARSET);
        Assert.assertEquals((Object)"english=hi+there&swiss=Gr%FCezi_z%E4m%E4", (Object)s);
        StringEntity entity = new StringEntity(s, ContentType.create((String)"application/x-www-form-urlencoded", (Charset)HTTP.DEF_CONTENT_CHARSET));
        List result = URLEncodedUtils.parse((HttpEntity)entity);
        Assert.assertEquals((long)2L, (long)result.size());
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(0), "english", us_hello);
        TestURLEncodedUtils.assertNameValuePair((NameValuePair)result.get(1), "swiss", ch_hello);
    }

    @Test
    public void testIsEncoded() throws Exception {
        StringEntity entity = new StringEntity("...");
        entity.setContentType("application/x-www-form-urlencoded");
        Assert.assertTrue((boolean)URLEncodedUtils.isEncoded((HttpEntity)entity));
        entity.setContentType("application/x-www-form-urlencoded; charset=US-ASCII");
        Assert.assertTrue((boolean)URLEncodedUtils.isEncoded((HttpEntity)entity));
        entity.setContentType("text/test");
        Assert.assertFalse((boolean)URLEncodedUtils.isEncoded((HttpEntity)entity));
    }

    @Test
    public void testFormat() throws Exception {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        Assert.assertEquals((long)0L, (long)URLEncodedUtils.format(params, (Charset)Consts.ASCII).length());
        params.clear();
        params.add(new BasicNameValuePair("Name0", null));
        Assert.assertEquals((Object)"Name0", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name1", "Value1"));
        Assert.assertEquals((Object)"Name1=Value1", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name2", ""));
        Assert.assertEquals((Object)"Name2=", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name4", "Value 4!"));
        Assert.assertEquals((Object)"Name4=Value+4%21", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name4", "Value+4!"));
        Assert.assertEquals((Object)"Name4=Value%2B4%21", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name4", "Value 4! !4"));
        Assert.assertEquals((Object)"Name4=Value+4%21+%214", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name5", "aaa"));
        params.add(new BasicNameValuePair("Name6", "bbb"));
        Assert.assertEquals((Object)"Name5=aaa&Name6=bbb", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name7", "aaa"));
        params.add(new BasicNameValuePair("Name7", "b,b"));
        params.add(new BasicNameValuePair("Name7", "ccc"));
        Assert.assertEquals((Object)"Name7=aaa&Name7=b%2Cb&Name7=ccc", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
        params.clear();
        params.add(new BasicNameValuePair("Name8", "xx,  yy  ,zz"));
        Assert.assertEquals((Object)"Name8=xx%2C++yy++%2Czz", (Object)URLEncodedUtils.format(params, (Charset)Consts.ASCII));
    }

    private List<NameValuePair> parse(String params, String encoding) {
        return URLEncodedUtils.parse((URI)URI.create("http://hc.apache.org/params?" + params), (String)encoding);
    }

    private static void assertNameValuePair(NameValuePair parameter, String expectedName, String expectedValue) {
        Assert.assertEquals((Object)parameter.getName(), (Object)expectedName);
        Assert.assertEquals((Object)parameter.getValue(), (Object)expectedValue);
    }
}

