/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import java.util.HashSet;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRouteDirector;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.conn.routing.RouteTracker;
import org.junit.Assert;
import org.junit.Test;

public class TestRouteTracker {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid");
    public static final HttpHost TARGET2 = new HttpHost("target2.test.invalid", 8080);
    public static final HttpHost PROXY1 = new HttpHost("proxy1.test.invalid");
    public static final HttpHost PROXY2 = new HttpHost("proxy2.test.invalid", 1080);
    public static final HttpHost PROXY3 = new HttpHost("proxy3.test.invalid", 88);
    public static final InetAddress LOCAL41;
    public static final InetAddress LOCAL42;
    public static final InetAddress LOCAL61;
    public static final InetAddress LOCAL62;

    @Test
    public void testCstrTargetLocal() {
        RouteTracker rt = new RouteTracker(TARGET1, null);
        Assert.assertEquals((String)"wrong target (target,null)", (Object)TARGET1, (Object)rt.getTargetHost());
        Assert.assertEquals((String)"wrong local address (target,null)", null, (Object)rt.getLocalAddress());
        Assert.assertEquals((String)"wrong hop count (target,null)", (long)0L, (long)rt.getHopCount());
        Assert.assertEquals((String)"wrong proxy (target,null)", null, (Object)rt.getProxyHost());
        Assert.assertEquals((String)"wrong route (target,null)", null, (Object)rt.toRoute());
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        rt = new RouteTracker(TARGET2, LOCAL61);
        Assert.assertEquals((String)"wrong target (target,local)", (Object)TARGET2, (Object)rt.getTargetHost());
        Assert.assertEquals((String)"wrong local address (target,local)", (Object)LOCAL61, (Object)rt.getLocalAddress());
        Assert.assertEquals((String)"wrong hop count (target,local)", (long)0L, (long)rt.getHopCount());
        Assert.assertEquals((String)"wrong proxy (target,local)", null, (Object)rt.getProxyHost());
        Assert.assertEquals((String)"wrong route (target,local)", null, (Object)rt.toRoute());
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        rt = null;
        try {
            new RouteTracker(null, LOCAL41);
            Assert.fail((String)"null target not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testCstrRoute() {
        HttpRoute r = new HttpRoute(TARGET1);
        RouteTracker rt = new RouteTracker(r);
        Assert.assertEquals((String)"wrong target (r1)", (Object)TARGET1, (Object)rt.getTargetHost());
        Assert.assertEquals((String)"wrong local address (r1)", null, (Object)rt.getLocalAddress());
        Assert.assertEquals((String)"wrong hop count (r1)", (long)0L, (long)rt.getHopCount());
        Assert.assertEquals((String)"wrong proxy (r1)", null, (Object)rt.getProxyHost());
        Assert.assertEquals((String)"wrong route (r1)", null, (Object)rt.toRoute());
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        r = new HttpRoute(TARGET2, LOCAL61, true);
        rt = new RouteTracker(r);
        Assert.assertEquals((String)"wrong target (r2)", (Object)TARGET2, (Object)rt.getTargetHost());
        Assert.assertEquals((String)"wrong local address (r2)", (Object)LOCAL61, (Object)rt.getLocalAddress());
        Assert.assertEquals((String)"wrong hop count (r2)", (long)0L, (long)rt.getHopCount());
        Assert.assertEquals((String)"wrong proxy (r2)", null, (Object)rt.getProxyHost());
        Assert.assertEquals((String)"wrong route (r2)", null, (Object)rt.toRoute());
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        r = new HttpRoute(TARGET1, LOCAL42, PROXY3, true);
        rt = new RouteTracker(r);
        Assert.assertEquals((String)"wrong target (r3)", (Object)TARGET1, (Object)rt.getTargetHost());
        Assert.assertEquals((String)"wrong local address (r3)", (Object)LOCAL42, (Object)rt.getLocalAddress());
        Assert.assertEquals((String)"wrong hop count (r3)", (long)0L, (long)rt.getHopCount());
        Assert.assertEquals((String)"wrong proxy (r3)", null, (Object)rt.getProxyHost());
        Assert.assertEquals((String)"wrong route (r3)", null, (Object)rt.toRoute());
        TestRouteTracker.checkCTLS(rt, false, false, false, false);
        rt = null;
        try {
            new RouteTracker(null);
            Assert.fail((String)"null route not detected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalArgs() {
        RouteTracker rt = new RouteTracker(TARGET2, null);
        try {
            rt.connectProxy(null, true);
            Assert.fail((String)"missing proxy argument not detected (connect/false)");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            rt.connectProxy(null, false);
            Assert.fail((String)"missing proxy argument not detected (connect/true)");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        rt.connectProxy(PROXY1, false);
        try {
            rt.tunnelProxy(null, false);
            Assert.fail((String)"missing proxy argument not detected (tunnel/false)");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            rt.tunnelProxy(null, true);
            Assert.fail((String)"missing proxy argument not detected (tunnel/true)");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            rt.getHopTarget(-1);
            Assert.fail((String)"negative hop index not detected");
        }
        catch (IllegalArgumentException iax) {
            // empty catch block
        }
        try {
            rt.getHopTarget(2);
            Assert.fail((String)"excessive hop index not detected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalStates() {
        RouteTracker rt = new RouteTracker(TARGET1, null);
        try {
            rt.tunnelTarget(false);
            Assert.fail((String)"unconnectedness not detected (tunnelTarget)");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
        try {
            rt.tunnelProxy(PROXY1, false);
            Assert.fail((String)"unconnectedness not detected (tunnelProxy)");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
        try {
            rt.layerProtocol(true);
            Assert.fail((String)"unconnectedness not detected (layerProtocol)");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
        rt.connectTarget(false);
        try {
            rt.connectTarget(false);
            Assert.fail((String)"connectedness not detected (connectTarget)");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
        try {
            rt.connectProxy(PROXY2, false);
            Assert.fail((String)"connectedness not detected (connectProxy)");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
        try {
            rt.tunnelTarget(false);
            Assert.fail((String)"unproxiedness not detected (tunnelTarget)");
        }
        catch (IllegalStateException isx) {
            // empty catch block
        }
        try {
            rt.tunnelProxy(PROXY1, false);
            Assert.fail((String)"unproxiedness not detected (tunnelProxy)");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testDirectRoutes() {
        BasicRouteDirector rd = new BasicRouteDirector();
        HttpRoute r = new HttpRoute(TARGET1, LOCAL41, false);
        RouteTracker rt = new RouteTracker(r);
        boolean complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 2);
        Assert.assertTrue((String)"incomplete route 1", (boolean)complete);
        r = new HttpRoute(TARGET2, LOCAL62, true);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 2);
        Assert.assertTrue((String)"incomplete route 2", (boolean)complete);
    }

    @Test
    public void testProxyRoutes() {
        BasicRouteDirector rd = new BasicRouteDirector();
        HttpRoute r = new HttpRoute(TARGET2, null, PROXY1, false);
        RouteTracker rt = new RouteTracker(r);
        boolean complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 2);
        Assert.assertTrue((String)"incomplete route 1", (boolean)complete);
        r = new HttpRoute(TARGET1, LOCAL61, PROXY3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 3);
        Assert.assertTrue((String)"incomplete route 2", (boolean)complete);
        r = new HttpRoute(TARGET1, LOCAL61, PROXY3, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 4);
        Assert.assertTrue((String)"incomplete route 3", (boolean)complete);
        r = new HttpRoute(TARGET1, LOCAL61, PROXY3, true);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 4);
        Assert.assertTrue((String)"incomplete route 4", (boolean)complete);
    }

    @Test
    public void testProxyChainRoutes() {
        BasicRouteDirector rd = new BasicRouteDirector();
        HttpHost[] proxies = new HttpHost[]{PROXY1, PROXY2};
        HttpRoute r = new HttpRoute(TARGET2, LOCAL42, proxies, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        RouteTracker rt = new RouteTracker(r);
        boolean complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 3);
        Assert.assertTrue((String)"incomplete route 1", (boolean)complete);
        proxies = new HttpHost[]{PROXY3, PROXY2};
        r = new HttpRoute(TARGET1, null, proxies, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 4);
        Assert.assertTrue((String)"incomplete route 2", (boolean)complete);
        proxies = new HttpHost[]{PROXY3, PROXY2, PROXY1};
        r = new HttpRoute(TARGET2, LOCAL61, proxies, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 6);
        Assert.assertTrue((String)"incomplete route 3", (boolean)complete);
        proxies = new HttpHost[]{PROXY1, PROXY3};
        r = new HttpRoute(TARGET1, LOCAL61, proxies, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        rt = new RouteTracker(r);
        complete = TestRouteTracker.checkVia(rt, r, (HttpRouteDirector)rd, 5);
        Assert.assertTrue((String)"incomplete route 4", (boolean)complete);
    }

    @Test
    public void testEqualsHashcodeCloneToString() throws CloneNotSupportedException {
        RouteTracker rt0 = new RouteTracker(TARGET1, null);
        RouteTracker rt1 = new RouteTracker(TARGET2, null);
        RouteTracker rt2 = new RouteTracker(TARGET1, null);
        RouteTracker rt3 = new RouteTracker(TARGET1, null);
        RouteTracker rt4 = new RouteTracker(TARGET1, LOCAL41);
        RouteTracker rt6 = new RouteTracker(TARGET1, LOCAL62);
        Assert.assertFalse((String)"rt0", (boolean)rt0.equals(null));
        Assert.assertTrue((String)"rt0", (boolean)rt0.equals((Object)rt0));
        Assert.assertFalse((String)"rt0", (boolean)rt0.equals((Object)rt0.toString()));
        Assert.assertFalse((String)"rt0 == rt4", (boolean)rt0.equals((Object)rt4));
        Assert.assertFalse((String)"rt0 == rt1", (boolean)rt0.equals((Object)rt1));
        Assert.assertTrue((String)"rt0 != rt2", (boolean)rt0.equals((Object)rt2));
        rt2.connectTarget(false);
        Assert.assertFalse((String)"rt0 == rt2", (boolean)rt0.equals((Object)rt2));
        Assert.assertTrue((String)"rt0 != rt3", (boolean)rt0.equals((Object)rt3));
        rt3.connectTarget(true);
        Assert.assertFalse((String)"rt0 == rt3", (boolean)rt0.equals((Object)rt3));
        Assert.assertFalse((String)"rt2 == rt3", (boolean)rt2.equals((Object)rt3));
        Assert.assertFalse((String)"rt4 == rt0", (boolean)rt4.equals((Object)rt0));
        Assert.assertFalse((String)"rt0 == rt6", (boolean)rt0.equals((Object)rt6));
        Assert.assertFalse((String)"rt6 == rt0", (boolean)rt6.equals((Object)rt0));
        Assert.assertFalse((String)"rt4 == rt6", (boolean)rt4.equals((Object)rt6));
        Assert.assertFalse((String)"rt6 == rt4", (boolean)rt6.equals((Object)rt4));
        Assert.assertFalse((String)"rt0 == rt4 (hashcode)", (rt0.hashCode() == rt4.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"rt0 == rt6 (hashcode)", (rt0.hashCode() == rt6.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"rt6 == rt4 (hashcode)", (rt6.hashCode() == rt4.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((String)"rt0 (clone)", (Object)rt0, (Object)rt0.clone());
        Assert.assertEquals((String)"rt4 (clone)", (Object)rt4, (Object)rt4.clone());
        Assert.assertEquals((String)"rt6 (clone)", (Object)rt6, (Object)rt6.clone());
        HashSet<RouteTracker> hs = new HashSet<RouteTracker>();
        HashSet<Integer> hc0 = new HashSet<Integer>();
        HashSet<Integer> hc4 = new HashSet<Integer>();
        HashSet<Integer> hc6 = new HashSet<Integer>();
        RouteTracker rt = null;
        Assert.assertTrue((boolean)hs.add(rt0));
        Assert.assertTrue((boolean)hs.add(rt4));
        Assert.assertTrue((boolean)hs.add(rt6));
        Assert.assertTrue((boolean)hc0.add(rt0.hashCode()));
        Assert.assertTrue((boolean)hc4.add(rt4.hashCode()));
        Assert.assertTrue((boolean)hc6.add(rt6.hashCode()));
        rt = (RouteTracker)rt0.clone();
        rt.connectTarget(false);
        Assert.assertTrue((boolean)hs.add(rt));
        Assert.assertTrue((boolean)hc0.add(rt.hashCode()));
        rt = (RouteTracker)rt0.clone();
        rt.connectTarget(true);
        Assert.assertTrue((boolean)hs.add(rt));
        Assert.assertTrue((boolean)hc0.add(rt.hashCode()));
        rt = (RouteTracker)rt4.clone();
        rt.connectProxy(PROXY1, false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.tunnelTarget(false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.layerProtocol(true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt = (RouteTracker)rt4.clone();
        rt.connectProxy(PROXY1, true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.tunnelTarget(true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt.layerProtocol(false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc4.add(rt.hashCode()));
        rt = (RouteTracker)rt6.clone();
        rt.connectProxy(PROXY1, false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelProxy(PROXY2, false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelTarget(false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.layerProtocol(true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt = (RouteTracker)rt6.clone();
        rt.connectProxy(PROXY1, true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelProxy(PROXY2, true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelTarget(true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.layerProtocol(false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt = (RouteTracker)rt6.clone();
        rt.connectProxy(PROXY2, false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        Assert.assertTrue((boolean)hc6.add(rt.hashCode()));
        rt.tunnelProxy(PROXY1, false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        rt.tunnelTarget(false);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        rt.layerProtocol(true);
        Assert.assertTrue((boolean)hs.add((RouteTracker)rt.clone()));
        HashSet<String> rtstrings = new HashSet<String>();
        for (RouteTracker current : hs) {
            String rts = TestRouteTracker.checkToString(current);
            Assert.assertTrue((String)("duplicate toString: " + rts), (boolean)rtstrings.add(rts));
        }
    }

    public static final void checkCTLS(RouteTracker rt, boolean c, boolean t, boolean l, boolean s) {
        String rts = rt.toString();
        Assert.assertEquals((String)("wrong flag connected: " + rts), (Object)c, (Object)rt.isConnected());
        Assert.assertEquals((String)("wrong flag tunnelled: " + rts), (Object)t, (Object)rt.isTunnelled());
        Assert.assertEquals((String)("wrong enum tunnelled: " + rts), (Object)(t ? RouteInfo.TunnelType.TUNNELLED : RouteInfo.TunnelType.PLAIN), (Object)rt.getTunnelType());
        Assert.assertEquals((String)("wrong flag layered: " + rts), (Object)l, (Object)rt.isLayered());
        Assert.assertEquals((String)("wrong enum layered: " + rts), (Object)(l ? RouteInfo.LayerType.LAYERED : RouteInfo.LayerType.PLAIN), (Object)rt.getLayerType());
        Assert.assertEquals((String)("wrong flag secure: " + rts), (Object)s, (Object)rt.isSecure());
    }

    public static final boolean checkVia(RouteTracker rt, HttpRoute r, HttpRouteDirector rd, int steps) {
        String msg = r.toString() + " @ " + rt.toString();
        boolean complete = false;
        while (!complete && steps > 0) {
            int action = rd.nextStep((RouteInfo)r, (RouteInfo)rt.toRoute());
            switch (action) {
                case 0: {
                    complete = true;
                    Assert.assertEquals((Object)r, (Object)rt.toRoute());
                    break;
                }
                case 1: {
                    boolean sec = r.isSecure();
                    rt.connectTarget(sec);
                    TestRouteTracker.checkCTLS(rt, true, false, false, sec);
                    Assert.assertEquals((String)("wrong hop count " + msg), (long)1L, (long)rt.getHopCount());
                    Assert.assertEquals((String)("wrong hop0 " + msg), (Object)r.getTargetHost(), (Object)rt.getHopTarget(0));
                    break;
                }
                case 2: {
                    boolean sec = false;
                    rt.connectProxy(r.getProxyHost(), false);
                    TestRouteTracker.checkCTLS(rt, true, false, false, false);
                    Assert.assertEquals((String)("wrong hop count " + msg), (long)2L, (long)rt.getHopCount());
                    Assert.assertEquals((String)("wrong hop0 " + msg), (Object)r.getProxyHost(), (Object)rt.getHopTarget(0));
                    Assert.assertEquals((String)("wrong hop1 " + msg), (Object)r.getTargetHost(), (Object)rt.getHopTarget(1));
                    break;
                }
                case 3: {
                    int hops = rt.getHopCount();
                    boolean sec = false;
                    rt.tunnelTarget(false);
                    TestRouteTracker.checkCTLS(rt, true, true, false, false);
                    Assert.assertEquals((String)("wrong hop count " + msg), (long)hops, (long)rt.getHopCount());
                    Assert.assertEquals((String)("wrong hop0 " + msg), (Object)r.getProxyHost(), (Object)rt.getHopTarget(0));
                    Assert.assertEquals((String)("wrong hopN " + msg), (Object)r.getTargetHost(), (Object)rt.getHopTarget(hops - 1));
                    break;
                }
                case 4: {
                    int hops = rt.getHopCount();
                    boolean sec = false;
                    HttpHost pxy = r.getHopTarget(hops - 1);
                    rt.tunnelProxy(pxy, false);
                    TestRouteTracker.checkCTLS(rt, true, false, false, false);
                    Assert.assertEquals((String)("wrong hop count " + msg), (long)(hops + 1), (long)rt.getHopCount());
                    Assert.assertEquals((String)("wrong hop0 " + msg), (Object)r.getProxyHost(), (Object)rt.getHopTarget(0));
                    Assert.assertEquals((String)("wrong hop" + hops + " " + msg), (Object)pxy, (Object)rt.getHopTarget(hops - 1));
                    Assert.assertEquals((String)("wrong hopN " + msg), (Object)r.getTargetHost(), (Object)rt.getHopTarget(hops));
                    break;
                }
                case 5: {
                    int hops = rt.getHopCount();
                    boolean tun = rt.isTunnelled();
                    boolean sec = r.isSecure();
                    rt.layerProtocol(sec);
                    TestRouteTracker.checkCTLS(rt, true, tun, true, sec);
                    Assert.assertEquals((String)("wrong hop count " + msg), (long)hops, (long)rt.getHopCount());
                    Assert.assertEquals((String)("wrong proxy " + msg), (Object)r.getProxyHost(), (Object)rt.getProxyHost());
                    Assert.assertEquals((String)("wrong target " + msg), (Object)r.getTargetHost(), (Object)rt.getTargetHost());
                    break;
                }
                default: {
                    Assert.fail((String)("unexpected action " + action + " from director, " + msg));
                }
            }
            --steps;
        }
        return complete;
    }

    public static final String checkToString(RouteTracker rt) {
        if (rt == null) {
            return null;
        }
        String rts = rt.toString();
        if (rt.getLocalAddress() != null) {
            String las = rt.getLocalAddress().toString();
            Assert.assertFalse((String)("no local address in toString(): " + rts), (rts.indexOf(las) < 0 ? 1 : 0) != 0);
        }
        for (int i = 0; i < rt.getHopCount(); ++i) {
            String hts = rt.getHopTarget(i).toString();
            Assert.assertFalse((String)("hop " + i + " (" + hts + ") missing in toString(): " + rts), (rts.indexOf(hts) < 0 ? 1 : 0) != 0);
        }
        return rts;
    }

    static {
        try {
            LOCAL41 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LOCAL42 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
            LOCAL61 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            LOCAL62 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

