/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.junit.Before;
import org.junit.Test;

public class TestIdleConnectionEviction
extends ServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
    }

    @Test
    public void testIdleConnectionEviction() throws Exception {
        int i;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager(schemeRegistry);
        cm.setDefaultMaxPerRoute(10);
        cm.setMaxTotal(50);
        DefaultHttpClient httpclient = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        IdleConnectionMonitor idleConnectionMonitor = new IdleConnectionMonitor((ClientConnectionManager)cm);
        idleConnectionMonitor.start();
        InetSocketAddress address = this.localServer.getServiceAddress();
        HttpHost target = new HttpHost(address.getHostName(), address.getPort());
        HttpGet httpget = new HttpGet("/random/1024");
        WorkerThread[] workers = new WorkerThread[5];
        for (i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)httpclient, target, (HttpUriRequest)httpget, 200);
        }
        for (i = 0; i < workers.length; ++i) {
            workers[i].start();
        }
        for (i = 0; i < workers.length; ++i) {
            workers[i].join();
            Exception ex = workers[i].getException();
            if (ex == null) continue;
            throw ex;
        }
        idleConnectionMonitor.shutdown();
    }

    public static class IdleConnectionMonitor
    extends Thread {
        private final ClientConnectionManager cm;
        private volatile boolean shutdown;

        public IdleConnectionMonitor(ClientConnectionManager cm) {
            this.cm = cm;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                while (!this.shutdown) {
                    IdleConnectionMonitor idleConnectionMonitor = this;
                    synchronized (idleConnectionMonitor) {
                        this.wait(250L);
                        this.cm.closeIdleConnections(1L, TimeUnit.MILLISECONDS);
                    }
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            IdleConnectionMonitor idleConnectionMonitor = this;
            synchronized (idleConnectionMonitor) {
                this.notifyAll();
            }
        }
    }

    static class WorkerThread
    extends Thread {
        private final HttpClient httpclient;
        private final HttpHost target;
        private final HttpUriRequest request;
        private final int count;
        private volatile Exception ex;

        public WorkerThread(HttpClient httpclient, HttpHost target, HttpUriRequest request, int count) {
            this.httpclient = httpclient;
            this.target = target;
            this.request = request;
            this.count = count;
        }

        public void run() {
            try {
                for (int i = 0; i < this.count; ++i) {
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)this.request);
                    int status = response.getStatusLine().getStatusCode();
                    if (status != 200) {
                        this.request.abort();
                        throw new ClientProtocolException("Unexpected status code: " + status);
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    Thread.sleep(10L);
                }
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        public Exception getException() {
            return this.ex;
        }
    }
}

