/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.localserver.ServerTestBase;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestLocalServer
extends ServerTestBase {
    @Test
    public void testEcho() throws Exception {
        String message = "Hello, world!";
        String charset = "UTF-8";
        HttpHost target = this.getServerHttp();
        HttpPost request = new HttpPost("/echo/");
        request.setHeader("Host", target.getHostName());
        request.setEntity((HttpEntity)new StringEntity("Hello, world!", "UTF-8"));
        DefaultHttpClientConnection conn = this.connectTo(target);
        this.httpContext.setAttribute("http.connection", (Object)conn);
        this.httpContext.setAttribute("http.target_host", (Object)target);
        this.httpContext.setAttribute("http.request", (Object)request);
        request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.defaultParams));
        this.httpExecutor.preProcess((HttpRequest)request, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        HttpResponse response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
        response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.defaultParams));
        this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
        Assert.assertEquals((String)"wrong status in response", (long)200L, (long)response.getStatusLine().getStatusCode());
        String received = EntityUtils.toString((HttpEntity)response.getEntity());
        conn.close();
        Assert.assertEquals((String)"wrong echo", (Object)"Hello, world!", (Object)received);
    }

    @Test
    public void testRandom() throws Exception {
        HttpHost target = this.getServerHttp();
        int[] sizes = new int[]{10, 2048, 4100, 0, -1};
        for (int i = 0; i < sizes.length; ++i) {
            String uri = "/random/" + sizes[i];
            if (sizes[i] < 0) {
                uri = uri + "/";
            }
            HttpGet request = new HttpGet(uri);
            DefaultHttpClientConnection conn = this.connectTo(target);
            this.httpContext.setAttribute("http.connection", (Object)conn);
            this.httpContext.setAttribute("http.target_host", (Object)target);
            this.httpContext.setAttribute("http.request", (Object)request);
            request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.defaultParams));
            this.httpExecutor.preProcess((HttpRequest)request, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
            HttpResponse response = this.httpExecutor.execute((HttpRequest)request, (HttpClientConnection)conn, (HttpContext)this.httpContext);
            response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.defaultParams));
            this.httpExecutor.postProcess(response, (HttpProcessor)this.httpProcessor, (HttpContext)this.httpContext);
            Assert.assertEquals((String)("(" + sizes[i] + ") wrong status in response"), (long)200L, (long)response.getStatusLine().getStatusCode());
            byte[] data = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            if (sizes[i] >= 0) {
                Assert.assertEquals((String)("(" + sizes[i] + ") wrong length of response"), (long)sizes[i], (long)data.length);
            }
            conn.close();
        }
    }
}

