/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.http.HttpHost;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.conn.GetConnThread;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class TestSpuriousWakeup {
    public static final HttpHost TARGET = new HttpHost("target.test.invalid");
    public static final HttpRoute ROUTE = new HttpRoute(TARGET);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpuriousWakeup() throws Exception {
        SchemeRegistry schreg = new SchemeRegistry();
        PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
        schreg.register(new Scheme("http", 80, (SchemeSocketFactory)sf));
        XTSCCM mgr = new XTSCCM(schreg);
        try {
            mgr.setMaxTotal(1);
            mgr.setDefaultMaxPerRoute(1);
            ClientConnectionRequest connRequest = mgr.requestConnection(ROUTE, null);
            ManagedClientConnection conn = connRequest.getConnection(0L, null);
            Assert.assertNotNull((Object)conn);
            GetConnThread gct = new GetConnThread((ClientConnectionManager)mgr, ROUTE, 0L);
            gct.start();
            Thread.sleep(100L);
            Assert.assertEquals((String)"thread not waiting", (Object)((Object)Thread.State.WAITING), (Object)((Object)gct.getState()));
            Lock lck = mgr.extendedCPBR.getLock();
            Condition cnd = mgr.extendedCPBR.newestWT.getCondition();
            for (int i = 0; i < 3; ++i) {
                if (i > 0) {
                    Thread.sleep(333L);
                }
                try {
                    lck.lock();
                    cnd.signalAll();
                }
                finally {
                    lck.unlock();
                }
                Thread.sleep(100L);
                Assert.assertEquals((String)("thread no longer waiting, iteration " + i), (Object)((Object)Thread.State.WAITING), (Object)((Object)gct.getState()));
            }
        }
        finally {
            mgr.shutdown();
        }
    }

    private static class XTSCCM
    extends ThreadSafeClientConnManager {
        protected XConnPoolByRoute extendedCPBR;

        public XTSCCM(SchemeRegistry schreg) {
            super(schreg);
        }

        protected ConnPoolByRoute createConnectionPool(long connTTL, TimeUnit connTTLUnit) {
            this.extendedCPBR = new XConnPoolByRoute(this.connOperator, (ConnPerRoute)this.connPerRoute, 20);
            return this.extendedCPBR;
        }
    }

    private static class XConnPoolByRoute
    extends ConnPoolByRoute {
        protected WaitingThread newestWT;

        public XConnPoolByRoute(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
            super(operator, connPerRoute, maxTotalConnections);
        }

        protected synchronized WaitingThread newWaitingThread(Condition cond, RouteSpecificPool rospl) {
            WaitingThread wt;
            this.newestWT = wt = super.newWaitingThread(cond, rospl);
            return wt;
        }
    }
}

