/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.conn.HttpRoutedConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRequestClientConnControl {
    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process(null, (HttpContext)context);
    }

    @Test
    public void testConnectionKeepAliveForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        BasicHttpContext context = new BasicHttpContext();
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((String)"Keep-Alive", (String)header1.getValue());
        Header header2 = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testConnectionKeepAliveForDirectRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        HttpHost target = new HttpHost("localhost", 80, "http");
        HttpRoute route = new HttpRoute(target, null, false);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        context.setAttribute("http.connection", (Object)conn);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((String)"Keep-Alive", (String)header1.getValue());
        Header header2 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testConnectionKeepAliveForTunneledRequests() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        HttpHost target = new HttpHost("localhost", 443, "https");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        context.setAttribute("http.connection", (Object)conn);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((String)"Keep-Alive", (String)header1.getValue());
        Header header2 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testProxyConnectionKeepAliveForRequestsOverProxy() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        BasicHttpContext context = new BasicHttpContext();
        HttpHost target = new HttpHost("localhost", 80, "http");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        context.setAttribute("http.connection", (Object)conn);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((String)"Keep-Alive", (String)header1.getValue());
        Header header2 = request.getFirstHeader("Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testPreserveCustomConnectionHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Connection", "Close");
        BasicHttpContext context = new BasicHttpContext();
        HttpHost target = new HttpHost("localhost", 443, "https");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        context.setAttribute("http.connection", (Object)conn);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((String)"Close", (String)header1.getValue());
        Header header2 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNull((Object)header2);
    }

    @Test
    public void testPreserveCustomProxyConnectionHeader() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("Proxy-Connection", "Close");
        BasicHttpContext context = new BasicHttpContext();
        HttpHost target = new HttpHost("localhost", 80, "http");
        HttpHost proxy = new HttpHost("localhost", 8080);
        HttpRoute route = new HttpRoute(target, null, proxy, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoutedConnection conn = (HttpRoutedConnection)Mockito.mock(HttpRoutedConnection.class);
        Mockito.when((Object)conn.getRoute()).thenReturn((Object)route);
        context.setAttribute("http.connection", (Object)conn);
        RequestClientConnControl interceptor = new RequestClientConnControl();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("Proxy-Connection");
        Assert.assertNotNull((Object)header1);
        Assert.assertEquals((String)"Close", (String)header1.getValue());
    }
}

