/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.protocol;

import java.util.ArrayList;
import junit.framework.Assert;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Test;

public class TestRequestDefaultHeaders {
    @Test(expected=IllegalArgumentException.class)
    public void testRequestParameterCheck() throws Exception {
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders();
        interceptor.process(null, (HttpContext)context);
    }

    @Test
    public void testNoDefaultHeadersForConnectRequest() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("CONNECT", "www.somedomain.com");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", "stuff"));
        request.getParams().setParameter("http.default-headers", defheaders);
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header header1 = request.getFirstHeader("custom");
        Assert.assertNull((Object)header1);
    }

    @Test
    public void testDefaultHeaders() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        request.addHeader("custom", "stuff");
        ArrayList<BasicHeader> defheaders = new ArrayList<BasicHeader>();
        defheaders.add(new BasicHeader("custom", "more stuff"));
        request.getParams().setParameter("http.default-headers", defheaders);
        BasicHttpContext context = new BasicHttpContext();
        RequestDefaultHeaders interceptor = new RequestDefaultHeaders();
        interceptor.process((HttpRequest)request, (HttpContext)context);
        Header[] headers = request.getHeaders("custom");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((int)2, (int)headers.length);
        Assert.assertEquals((String)"stuff", (String)headers[0].getValue());
        Assert.assertEquals((String)"more stuff", (String)headers[1].getValue());
    }
}

