/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.localserver.RandomHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TestConnectionReuse {
    protected LocalTestServer localServer;

    @After
    public void tearDown() throws Exception {
        if (this.localServer != null) {
            this.localServer.stop();
        }
    }

    @Test
    public void testReuseOfPersistentConnections() throws Exception {
        WorkerThread worker;
        int i;
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.localServer = new LocalTestServer(httpproc, null);
        this.localServer.register("/random/*", new RandomHandler());
        this.localServer.start();
        InetSocketAddress saddress = this.localServer.getServiceAddress();
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"TestAgent/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("http", 80, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(supportedSchemes);
        mgr.setMaxTotal(5);
        mgr.setDefaultMaxPerRoute(5);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        HttpHost target = new HttpHost(saddress.getHostName(), saddress.getPort(), "http");
        WorkerThread[] workers = new WorkerThread[10];
        for (i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)client, target, new URI("/random/2000"), 10, false);
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.start();
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            workers[i].join(10000L);
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        Assert.assertTrue((mgr.getTotalStats().getAvailable() > 0 ? 1 : 0) != 0);
        mgr.shutdown();
    }

    @Test
    public void testReuseOfClosedConnections() throws Exception {
        WorkerThread worker;
        int i;
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new AlwaysCloseConn());
        this.localServer = new LocalTestServer(httpproc, null);
        this.localServer.register("/random/*", new RandomHandler());
        this.localServer.start();
        InetSocketAddress saddress = this.localServer.getServiceAddress();
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"TestAgent/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("http", 80, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(supportedSchemes);
        mgr.setMaxTotal(5);
        mgr.setDefaultMaxPerRoute(5);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        HttpHost target = new HttpHost(saddress.getHostName(), saddress.getPort(), "http");
        WorkerThread[] workers = new WorkerThread[10];
        for (i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)client, target, new URI("/random/2000"), 10, false);
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.start();
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            workers[i].join(10000L);
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        mgr.shutdown();
    }

    @Test
    public void testReuseOfAbortedConnections() throws Exception {
        WorkerThread worker;
        int i;
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.localServer = new LocalTestServer(httpproc, null);
        this.localServer.register("/random/*", new RandomHandler());
        this.localServer.start();
        InetSocketAddress saddress = this.localServer.getServiceAddress();
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"TestAgent/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("http", 80, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(supportedSchemes);
        mgr.setMaxTotal(5);
        mgr.setDefaultMaxPerRoute(5);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        HttpHost target = new HttpHost(saddress.getHostName(), saddress.getPort(), "http");
        WorkerThread[] workers = new WorkerThread[10];
        for (i = 0; i < workers.length; ++i) {
            workers[i] = new WorkerThread((HttpClient)client, target, new URI("/random/2000"), 10, true);
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            worker.start();
        }
        for (i = 0; i < workers.length; ++i) {
            worker = workers[i];
            workers[i].join(10000L);
            Exception ex = worker.getException();
            if (ex == null) continue;
            throw ex;
        }
        Assert.assertEquals((long)0L, (long)mgr.getTotalStats().getAvailable());
        mgr.shutdown();
    }

    @Test
    public void testKeepAliveHeaderRespected() throws Exception {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseKeepAlive());
        this.localServer = new LocalTestServer(httpproc, null);
        this.localServer.register("/random/*", new RandomHandler());
        this.localServer.start();
        InetSocketAddress saddress = this.localServer.getServiceAddress();
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"TestAgent/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        SchemeRegistry supportedSchemes = new SchemeRegistry();
        PlainSocketFactory sf = PlainSocketFactory.getSocketFactory();
        supportedSchemes.register(new Scheme("http", 80, (SchemeSocketFactory)sf));
        PoolingClientConnectionManager mgr = new PoolingClientConnectionManager(supportedSchemes);
        mgr.setMaxTotal(1);
        mgr.setDefaultMaxPerRoute(1);
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)mgr, (HttpParams)params);
        HttpHost target = new HttpHost(saddress.getHostName(), saddress.getPort(), "http");
        HttpResponse response = client.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)this.localServer.getAcceptedConnectionCount());
        response = client.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)1L, (long)this.localServer.getAcceptedConnectionCount());
        Thread.sleep(1100L);
        response = client.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)2L, (long)this.localServer.getAcceptedConnectionCount());
        Thread.sleep(500L);
        response = client.execute(target, (HttpRequest)new HttpGet("/random/2000"));
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)1L, (long)mgr.getTotalStats().getAvailable());
        Assert.assertEquals((long)2L, (long)this.localServer.getAcceptedConnectionCount());
        mgr.shutdown();
    }

    private static class ResponseKeepAlive
    implements HttpResponseInterceptor {
        private ResponseKeepAlive() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header connection = response.getFirstHeader("Connection");
            if (connection != null && !connection.getValue().equalsIgnoreCase("Close")) {
                response.addHeader("Keep-Alive", "timeout=1");
            }
        }
    }

    private static class WorkerThread
    extends Thread {
        private final URI requestURI;
        private final HttpHost target;
        private final HttpClient httpclient;
        private final int repetitions;
        private final boolean forceClose;
        private volatile Exception exception;

        public WorkerThread(HttpClient httpclient, HttpHost target, URI requestURI, int repetitions, boolean forceClose) {
            this.httpclient = httpclient;
            this.requestURI = requestURI;
            this.target = target;
            this.repetitions = repetitions;
            this.forceClose = forceClose;
        }

        public void run() {
            try {
                for (int i = 0; i < this.repetitions; ++i) {
                    HttpGet httpget = new HttpGet(this.requestURI);
                    HttpResponse response = this.httpclient.execute(this.target, (HttpRequest)httpget);
                    if (this.forceClose) {
                        httpget.abort();
                        continue;
                    }
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
            catch (Exception ex) {
                this.exception = ex;
            }
        }

        public Exception getException() {
            return this.exception;
        }
    }

    private static class AlwaysCloseConn
    implements HttpResponseInterceptor {
        private AlwaysCloseConn() {
        }

        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setHeader("Connection", "Close");
        }
    }
}

