/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.mockup.SecureSocketFactoryMockup;
import org.junit.Assert;
import org.junit.Test;

public class TestScheme {
    @Test
    public void testConstructor() {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Assert.assertEquals((Object)"http", (Object)http.getName());
        Assert.assertEquals((long)80L, (long)http.getDefaultPort());
        Assert.assertFalse((boolean)http.isLayered());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)SecureSocketFactoryMockup.INSTANCE);
        Assert.assertEquals((Object)"https", (Object)https.getName());
        Assert.assertEquals((long)443L, (long)https.getDefaultPort());
        Assert.assertTrue((boolean)https.isLayered());
        Scheme hTtP = new Scheme("hTtP", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Assert.assertEquals((Object)"http", (Object)hTtP.getName());
        try {
            new Scheme(null, 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new Scheme("http", 80, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new Scheme("http", -1, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            new Scheme("http", 70000, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testRegisterUnregister() {
        SchemeRegistry schmreg = new SchemeRegistry();
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)SecureSocketFactoryMockup.INSTANCE);
        Scheme myhttp = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        HttpHost host = new HttpHost("www.test.invalid", -1, "http");
        HttpHost hosts = new HttpHost("www.test.invalid", -1, "https");
        Assert.assertNull((Object)schmreg.register(myhttp));
        Assert.assertNull((Object)schmreg.register(https));
        Assert.assertSame((Object)myhttp, (Object)schmreg.register(http));
        Assert.assertSame((Object)http, (Object)schmreg.getScheme("http"));
        Assert.assertSame((Object)http, (Object)schmreg.getScheme(host));
        Assert.assertSame((Object)https, (Object)schmreg.getScheme("https"));
        Assert.assertSame((Object)https, (Object)schmreg.getScheme(hosts));
        schmreg.unregister("http");
        schmreg.unregister("https");
        Assert.assertNull((Object)schmreg.get("http"));
        try {
            schmreg.getScheme("http");
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    @Test
    public void testIterator() {
        SchemeRegistry schmreg = new SchemeRegistry();
        List names = schmreg.getSchemeNames();
        Assert.assertNotNull((Object)names);
        Assert.assertTrue((boolean)names.isEmpty());
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)SecureSocketFactoryMockup.INSTANCE);
        schmreg.register(http);
        schmreg.register(https);
        names = schmreg.getSchemeNames();
        Assert.assertNotNull((Object)names);
        Assert.assertFalse((boolean)names.isEmpty());
        boolean flaghttp = false;
        boolean flaghttps = false;
        String name = (String)names.get(0);
        if ("http".equals(name)) {
            flaghttp = true;
        } else if ("https".equals(name)) {
            flaghttps = true;
        } else {
            Assert.fail((String)("unexpected name in iterator: " + name));
        }
        Assert.assertNotNull((Object)schmreg.get(name));
        schmreg.unregister(name);
        Assert.assertNull((Object)schmreg.get(name));
        name = (String)names.get(1);
        if ("http".equals(name)) {
            if (flaghttp) {
                Assert.fail((String)"name 'http' found twice");
            }
        } else if ("https".equals(name)) {
            if (flaghttps) {
                Assert.fail((String)"name 'https' found twice");
            }
        } else {
            Assert.fail((String)("unexpected name in iterator: " + name));
        }
        Assert.assertNotNull((Object)schmreg.get(name));
    }

    @Test
    public void testIllegalRegisterUnregister() {
        SchemeRegistry schmreg = new SchemeRegistry();
        try {
            schmreg.register(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            schmreg.unregister(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            schmreg.get(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            schmreg.getScheme((String)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            schmreg.getScheme((HttpHost)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testResolvePort() {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Assert.assertEquals((long)8080L, (long)http.resolvePort(8080));
        Assert.assertEquals((long)80L, (long)http.resolvePort(-1));
    }

    @Test
    public void testHashCode() {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme myhttp = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)SecureSocketFactoryMockup.INSTANCE);
        Assert.assertTrue((http.hashCode() != https.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((http.hashCode() == myhttp.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme myhttp = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Scheme https = new Scheme("https", 443, (SchemeSocketFactory)SecureSocketFactoryMockup.INSTANCE);
        Assert.assertFalse((boolean)http.equals((Object)https));
        Assert.assertFalse((boolean)http.equals(null));
        Assert.assertFalse((boolean)http.equals((Object)"http"));
        Assert.assertTrue((boolean)http.equals((Object)http));
        Assert.assertTrue((boolean)http.equals((Object)myhttp));
        Assert.assertFalse((boolean)http.equals((Object)https));
    }

    @Test
    public void testToString() {
        Scheme http = new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
        Assert.assertEquals((Object)"http:80", (Object)http.toString());
        Assert.assertEquals((Object)"http:80", (Object)http.toString());
    }
}

