/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.cookie;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.http.impl.cookie.RFC2109SpecFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.junit.Assert;
import org.junit.Test;

public class TestCookiePolicy {
    private static final String BROWSER_COMPATIBILITY = "BROWSER_COMPATIBILITY";
    private static final String NETSCAPE = "NETSCAPE";
    private static final String RFC_2109 = "RFC_2109";

    @Test
    public void testRegisterUnregisterCookieSpecFactory() {
        CookieSpecRegistry registry = new CookieSpecRegistry();
        List names = registry.getSpecNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)0L, (long)names.size());
        registry.register(BROWSER_COMPATIBILITY, (CookieSpecFactory)new BrowserCompatSpecFactory());
        registry.register(NETSCAPE, (CookieSpecFactory)new NetscapeDraftSpecFactory());
        registry.register(RFC_2109, (CookieSpecFactory)new RFC2109SpecFactory());
        registry.register(RFC_2109, (CookieSpecFactory)new RFC2109SpecFactory());
        registry.register(NETSCAPE, (CookieSpecFactory)new NetscapeDraftSpecFactory());
        names = registry.getSpecNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)3L, (long)names.size());
        HashSet m = new HashSet(names);
        Assert.assertTrue((boolean)m.contains(BROWSER_COMPATIBILITY.toLowerCase(Locale.ENGLISH)));
        Assert.assertTrue((boolean)m.contains(NETSCAPE.toLowerCase(Locale.ENGLISH)));
        Assert.assertTrue((boolean)m.contains(RFC_2109.toLowerCase(Locale.ENGLISH)));
        registry.unregister(NETSCAPE);
        registry.unregister(NETSCAPE);
        registry.unregister(RFC_2109);
        registry.unregister(BROWSER_COMPATIBILITY);
        registry.unregister("whatever");
        names = registry.getSpecNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)0L, (long)names.size());
    }

    @Test
    public void testGetNewCookieSpec() {
        CookieSpecRegistry registry = new CookieSpecRegistry();
        registry.register(BROWSER_COMPATIBILITY, (CookieSpecFactory)new BrowserCompatSpecFactory());
        registry.register(NETSCAPE, (CookieSpecFactory)new NetscapeDraftSpecFactory());
        registry.register(RFC_2109, (CookieSpecFactory)new RFC2109SpecFactory());
        Assert.assertNotNull((Object)registry.getCookieSpec(NETSCAPE));
        Assert.assertNotNull((Object)registry.getCookieSpec(RFC_2109));
        Assert.assertNotNull((Object)registry.getCookieSpec(BROWSER_COMPATIBILITY));
        try {
            registry.getCookieSpec("whatever");
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        BasicHttpParams params = new BasicHttpParams();
        Assert.assertNotNull((Object)registry.getCookieSpec(NETSCAPE, (HttpParams)params));
        Assert.assertNotNull((Object)registry.getCookieSpec(RFC_2109, (HttpParams)params));
        Assert.assertNotNull((Object)registry.getCookieSpec(BROWSER_COMPATIBILITY, (HttpParams)params));
        try {
            registry.getCookieSpec("whatever", (HttpParams)params);
            Assert.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidInput() {
        CookieSpecRegistry registry = new CookieSpecRegistry();
        try {
            registry.register(null, null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            registry.register("whatever", null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            registry.unregister(null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            registry.getCookieSpec((String)null);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

