/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeFactory;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAuthenticationStrategy {
    @Test(expected=IllegalArgumentException.class)
    public void testIsAuthenticationRequestedInvalidInput() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost host = new HttpHost("localhost", 80);
        BasicHttpContext context = new BasicHttpContext();
        authStrategy.isAuthenticationRequested(host, null, (HttpContext)context);
    }

    @Test
    public void testTargetAuthRequested() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost host = new HttpHost("localhost", 80);
        BasicHttpContext context = new BasicHttpContext();
        Assert.assertTrue((boolean)authStrategy.isAuthenticationRequested(host, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testProxyAuthRequested() throws Exception {
        ProxyAuthenticationStrategy authStrategy = new ProxyAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 407, "UNAUTHORIZED");
        HttpHost host = new HttpHost("localhost", 80);
        BasicHttpContext context = new BasicHttpContext();
        Assert.assertTrue((boolean)authStrategy.isAuthenticationRequested(host, (HttpResponse)response, (HttpContext)context));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetChallengesInvalidInput() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost host = new HttpHost("localhost", 80);
        BasicHttpContext context = new BasicHttpContext();
        authStrategy.getChallenges(host, null, (HttpContext)context);
    }

    @Test
    public void testGetChallenges() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpContext context = new BasicHttpContext();
        HttpHost host = new HttpHost("localhost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        BasicHeader h1 = new BasicHeader("WWW-Authenticate", "  Basic  realm=\"test\"");
        BasicHeader h2 = new BasicHeader("WWW-Authenticate", "\t\tDigest   realm=\"realm1\", nonce=\"1234\"");
        BasicHeader h3 = new BasicHeader("WWW-Authenticate", "WhatEver realm=\"realm1\", stuff=\"1234\"");
        response.addHeader((Header)h1);
        response.addHeader((Header)h2);
        response.addHeader((Header)h3);
        Map challenges = authStrategy.getChallenges(host, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)challenges);
        Assert.assertEquals((long)3L, (long)challenges.size());
        Assert.assertSame((Object)h1, challenges.get("basic"));
        Assert.assertSame((Object)h2, challenges.get("digest"));
        Assert.assertSame((Object)h3, challenges.get("whatever"));
    }

    @Test
    public void testSelectInvalidInput() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HashMap challenges = new HashMap();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost authhost = new HttpHost("locahost", 80);
        BasicHttpContext context = new BasicHttpContext();
        try {
            authStrategy.select(null, authhost, (HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            authStrategy.select(challenges, null, (HttpResponse)response, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            authStrategy.select(challenges, authhost, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            authStrategy.select(challenges, authhost, (HttpResponse)response, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testSelectNoSchemeRegistry() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost authhost = new HttpHost("locahost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        challenges.put("digest", new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        Queue options = authStrategy.select(challenges, authhost, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((long)0L, (long)options.size());
    }

    @Test
    public void testSelectNoCredentialsProvider() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost authhost = new HttpHost("locahost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        challenges.put("digest", new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("basic", (AuthSchemeFactory)new BasicSchemeFactory());
        authSchemeRegistry.register("digest", (AuthSchemeFactory)new DigestSchemeFactory());
        context.setAttribute("http.authscheme-registry", (Object)authSchemeRegistry);
        Queue options = authStrategy.select(challenges, authhost, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((long)0L, (long)options.size());
    }

    @Test
    public void testNoCredentials() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost authhost = new HttpHost("locahost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=\"realm1\""));
        challenges.put("digest", new BasicHeader("WWW-Authenticate", "Digest realm=\"realm2\", nonce=\"1234\""));
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("basic", (AuthSchemeFactory)new BasicSchemeFactory());
        authSchemeRegistry.register("digest", (AuthSchemeFactory)new DigestSchemeFactory());
        context.setAttribute("http.authscheme-registry", (Object)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        context.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
        Queue options = authStrategy.select(challenges, authhost, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((long)0L, (long)options.size());
    }

    @Test
    public void testCredentialsFound() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=\"realm1\""));
        challenges.put("digest", new BasicHeader("WWW-Authenticate", "Digest realm=\"realm2\", nonce=\"1234\""));
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("basic", (AuthSchemeFactory)new BasicSchemeFactory());
        authSchemeRegistry.register("digest", (AuthSchemeFactory)new DigestSchemeFactory());
        context.setAttribute("http.authscheme-registry", (Object)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope("somehost", 80, "realm2"), (Credentials)new UsernamePasswordCredentials("user", "pwd"));
        context.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
        Queue options = authStrategy.select(challenges, authhost, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((long)1L, (long)options.size());
        AuthOption option = (AuthOption)options.remove();
        Assert.assertTrue((boolean)(option.getAuthScheme() instanceof DigestScheme));
    }

    @Test
    public void testUnsupportedScheme() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=\"realm1\""));
        challenges.put("digest", new BasicHeader("WWW-Authenticate", "Digest realm=\"realm2\", nonce=\"1234\""));
        challenges.put("whatever", new BasicHeader("WWW-Authenticate", "Whatever realm=\"realm3\""));
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("basic", (AuthSchemeFactory)new BasicSchemeFactory());
        authSchemeRegistry.register("digest", (AuthSchemeFactory)new DigestSchemeFactory());
        context.setAttribute("http.authscheme-registry", (Object)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope("somehost", 80), (Credentials)new UsernamePasswordCredentials("user", "pwd"));
        context.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
        Queue options = authStrategy.select(challenges, authhost, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((long)2L, (long)options.size());
        AuthOption option1 = (AuthOption)options.remove();
        Assert.assertTrue((boolean)(option1.getAuthScheme() instanceof DigestScheme));
        AuthOption option2 = (AuthOption)options.remove();
        Assert.assertTrue((boolean)(option2.getAuthScheme() instanceof BasicScheme));
    }

    @Test
    public void testCustomAuthPreference() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.getParams().setParameter("http.auth.target-scheme-pref", Arrays.asList("Basic"));
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicHttpContext context = new BasicHttpContext();
        HashMap<String, BasicHeader> challenges = new HashMap<String, BasicHeader>();
        challenges.put("basic", new BasicHeader("WWW-Authenticate", "Basic realm=\"realm1\""));
        challenges.put("digest", new BasicHeader("WWW-Authenticate", "Digest realm=\"realm2\", nonce=\"1234\""));
        AuthSchemeRegistry authSchemeRegistry = new AuthSchemeRegistry();
        authSchemeRegistry.register("basic", (AuthSchemeFactory)new BasicSchemeFactory());
        authSchemeRegistry.register("digest", (AuthSchemeFactory)new DigestSchemeFactory());
        context.setAttribute("http.authscheme-registry", (Object)authSchemeRegistry);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope("somehost", 80), (Credentials)new UsernamePasswordCredentials("user", "pwd"));
        context.setAttribute("http.auth.credentials-provider", (Object)credentialsProvider);
        Queue options = authStrategy.select(challenges, authhost, (HttpResponse)response, (HttpContext)context);
        Assert.assertNotNull((Object)options);
        Assert.assertEquals((long)1L, (long)options.size());
        AuthOption option1 = (AuthOption)options.remove();
        Assert.assertTrue((boolean)(option1.getAuthScheme() instanceof BasicScheme));
    }

    @Test
    public void testAuthSucceededInvalidInput() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("locahost", 80);
        BasicScheme authScheme = new BasicScheme();
        BasicHttpContext context = new BasicHttpContext();
        try {
            authStrategy.authSucceeded(null, (AuthScheme)authScheme, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            authStrategy.authSucceeded(authhost, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            authStrategy.authSucceeded(authhost, (AuthScheme)authScheme, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testAuthSucceeded() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicScheme authScheme = new BasicScheme();
        authScheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", "Basic realm=test"));
        AuthCache authCache = (AuthCache)Mockito.mock(AuthCache.class);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        authStrategy.authSucceeded(authhost, (AuthScheme)authScheme, (HttpContext)context);
        ((AuthCache)Mockito.verify((Object)authCache)).put(authhost, (AuthScheme)authScheme);
    }

    @Test
    public void testAuthSucceededNoCache() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicScheme authScheme = new BasicScheme();
        authScheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", "Basic realm=test"));
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", null);
        authStrategy.authSucceeded(authhost, (AuthScheme)authScheme, (HttpContext)context);
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        Assert.assertNotNull((Object)authCache);
    }

    @Test
    public void testAuthScemeNotCompleted() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicScheme authScheme = new BasicScheme();
        AuthCache authCache = (AuthCache)Mockito.mock(AuthCache.class);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        authStrategy.authSucceeded(authhost, (AuthScheme)authScheme, (HttpContext)context);
        ((AuthCache)Mockito.verify((Object)authCache, (VerificationMode)Mockito.never())).put(authhost, (AuthScheme)authScheme);
    }

    @Test
    public void testAuthScemeNonCacheable() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("somehost", 80);
        AuthScheme authScheme = (AuthScheme)Mockito.mock(AuthScheme.class);
        Mockito.when((Object)authScheme.isComplete()).thenReturn((Object)true);
        Mockito.when((Object)authScheme.getSchemeName()).thenReturn((Object)"whatever");
        AuthCache authCache = (AuthCache)Mockito.mock(AuthCache.class);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        authStrategy.authSucceeded(authhost, authScheme, (HttpContext)context);
        ((AuthCache)Mockito.verify((Object)authCache, (VerificationMode)Mockito.never())).put(authhost, authScheme);
    }

    @Test
    public void testAuthFailedInvalidInput() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("locahost", 80);
        BasicScheme authScheme = new BasicScheme();
        BasicHttpContext context = new BasicHttpContext();
        try {
            authStrategy.authFailed(null, (AuthScheme)authScheme, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        try {
            authStrategy.authFailed(authhost, (AuthScheme)authScheme, null);
            Assert.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
    }

    @Test
    public void testAuthFailed() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicScheme authScheme = new BasicScheme();
        authScheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", "Basic realm=test"));
        AuthCache authCache = (AuthCache)Mockito.mock(AuthCache.class);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        authStrategy.authFailed(authhost, (AuthScheme)authScheme, (HttpContext)context);
        ((AuthCache)Mockito.verify((Object)authCache)).remove(authhost);
    }

    @Test
    public void testAuthFailedNoCache() throws Exception {
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        HttpHost authhost = new HttpHost("somehost", 80);
        BasicScheme authScheme = new BasicScheme();
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.auth.auth-cache", null);
        authStrategy.authFailed(authhost, (AuthScheme)authScheme, (HttpContext)context);
    }
}

