/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.AutoRetryHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestAutoRetryHttpClient {
    private AutoRetryHttpClient impl;
    private HttpClient mockBackend;
    private HttpHost host;

    @Before
    public void setUp() {
        this.mockBackend = (HttpClient)Mockito.mock(HttpClient.class);
        this.host = new HttpHost("foo.example.com");
    }

    @Test
    public void testDefaultRetryConfig() {
        DefaultServiceUnavailableRetryStrategy retryStrategy = new DefaultServiceUnavailableRetryStrategy();
        BasicHttpContext context = new BasicHttpContext();
        BasicHttpResponse response1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 503, "Oppsie");
        Assert.assertTrue((boolean)retryStrategy.retryRequest((HttpResponse)response1, 1, (HttpContext)context));
        BasicHttpResponse response2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 502, "Oppsie");
        Assert.assertFalse((boolean)retryStrategy.retryRequest((HttpResponse)response2, 1, (HttpContext)context));
        Assert.assertEquals((long)1000L, (long)retryStrategy.getRetryInterval());
    }

    @Test
    public void testNoAutoRetry() throws IOException {
        DefaultServiceUnavailableRetryStrategy retryStrategy = new DefaultServiceUnavailableRetryStrategy(2, 100);
        this.impl = new AutoRetryHttpClient(this.mockBackend, (ServiceUnavailableRetryStrategy)retryStrategy);
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpResponse resp1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 500, "Internal Server Error");
        BasicHttpResponse resp2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.mockBackend.execute(this.host, (HttpRequest)req1, (HttpContext)null)).thenReturn((Object)resp1).thenReturn((Object)resp2);
        HttpResponse result = this.impl.execute(this.host, (HttpRequest)req1);
        ((HttpClient)Mockito.verify((Object)this.mockBackend, (VerificationMode)Mockito.times((int)1))).execute(this.host, (HttpRequest)req1, (HttpContext)null);
        Assert.assertEquals((Object)resp1, (Object)result);
        Assert.assertEquals((long)500L, (long)result.getStatusLine().getStatusCode());
    }

    @Test
    public void testMultipleAutoRetry() throws IOException {
        DefaultServiceUnavailableRetryStrategy retryStrategy = new DefaultServiceUnavailableRetryStrategy(5, 100);
        this.impl = new AutoRetryHttpClient(this.mockBackend, (ServiceUnavailableRetryStrategy)retryStrategy);
        BasicHttpRequest req1 = new BasicHttpRequest("GET", "/", (ProtocolVersion)HttpVersion.HTTP_1_1);
        BasicHttpResponse resp1 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 503, "Service Unavailable");
        BasicHttpResponse resp2 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 503, "Service Unavailable");
        BasicHttpResponse resp3 = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.mockBackend.execute(this.host, (HttpRequest)req1, (HttpContext)null)).thenReturn((Object)resp1).thenReturn((Object)resp2).thenReturn((Object)resp3);
        HttpResponse result = this.impl.execute(this.host, (HttpRequest)req1);
        ((HttpClient)Mockito.verify((Object)this.mockBackend, (VerificationMode)Mockito.times((int)3))).execute(this.host, (HttpRequest)req1, (HttpContext)null);
        Assert.assertEquals((Object)resp3, (Object)result);
        Assert.assertEquals((long)200L, (long)result.getStatusLine().getStatusCode());
    }
}

