/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.localserver.BasicAuthTokenExtractor;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.localserver.RequestBasicAuth;
import org.apache.http.localserver.ResponseBasicUnauthorized;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpExpectationVerifier;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClientAuthentication
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestBasicAuth());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseBasicUnauthorized());
        this.localServer = new LocalTestServer(httpproc, null);
        this.httpclient = new DefaultHttpClient();
    }

    @Test
    public void testBasicAuthenticationNoCreds() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider(null);
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpGet httpget = new HttpGet("/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
        AuthScope authscope = credsProvider.getAuthScope();
        Assert.assertNotNull((Object)authscope);
        Assert.assertEquals((Object)"test realm", (Object)authscope.getRealm());
    }

    @Test
    public void testBasicAuthenticationFailure() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "all-wrong"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpGet httpget = new HttpGet("/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
        AuthScope authscope = credsProvider.getAuthScope();
        Assert.assertNotNull((Object)authscope);
        Assert.assertEquals((Object)"test realm", (Object)authscope.getRealm());
    }

    @Test
    public void testBasicAuthenticationSuccess() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpGet httpget = new HttpGet("/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
        AuthScope authscope = credsProvider.getAuthScope();
        Assert.assertNotNull((Object)authscope);
        Assert.assertEquals((Object)"test realm", (Object)authscope.getRealm());
    }

    @Test
    public void testBasicAuthenticationSuccessOnNonRepeatablePutExpectContinue() throws Exception {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestBasicAuth());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseBasicUnauthorized());
        this.localServer = new LocalTestServer(httpproc, null, null, new AuthExpectationVerifier(), null, null);
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpPut httpput = new HttpPut("/");
        httpput.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), -1L));
        httpput.getParams().setBooleanParameter("http.protocol.expect-continue", true);
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpput);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
    }

    @Test(expected=ClientProtocolException.class)
    public void testBasicAuthenticationFailureOnNonRepeatablePutDontExpectContinue() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpPut httpput = new HttpPut("/");
        httpput.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), -1L));
        httpput.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpput);
            Assert.fail((String)"ClientProtocolException should have been thrown");
        }
        catch (ClientProtocolException ex) {
            Throwable cause = ex.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof NonRepeatableRequestException));
            throw ex;
        }
    }

    @Test
    public void testBasicAuthenticationSuccessOnRepeatablePost() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpPost httppost = new HttpPost("/");
        httppost.setEntity((HttpEntity)new StringEntity("some important stuff", Consts.ASCII));
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httppost);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
        AuthScope authscope = credsProvider.getAuthScope();
        Assert.assertNotNull((Object)authscope);
        Assert.assertEquals((Object)"test realm", (Object)authscope.getRealm());
    }

    @Test(expected=ClientProtocolException.class)
    public void testBasicAuthenticationFailureOnNonRepeatablePost() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpPost httppost = new HttpPost("/");
        httppost.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}), -1L));
        try {
            this.httpclient.execute(this.getServerHttp(), (HttpRequest)httppost);
            Assert.fail((String)"ClientProtocolException should have been thrown");
        }
        catch (ClientProtocolException ex) {
            Throwable cause = ex.getCause();
            Assert.assertNotNull((Object)cause);
            Assert.assertTrue((boolean)(cause instanceof NonRepeatableRequestException));
            throw ex;
        }
    }

    @Test
    public void testBasicAuthenticationCredentialsCaching() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("test", "test"));
        TestTargetAuthenticationStrategy authStrategy = new TestTargetAuthenticationStrategy();
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        this.httpclient.setTargetAuthenticationStrategy((AuthenticationStrategy)authStrategy);
        BasicHttpContext context = new BasicHttpContext();
        HttpHost targethost = this.getServerHttp();
        HttpGet httpget = new HttpGet("/");
        HttpResponse response1 = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        HttpEntity entity1 = response1.getEntity();
        Assert.assertEquals((long)200L, (long)response1.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity1);
        EntityUtils.consume((HttpEntity)entity1);
        HttpResponse response2 = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        HttpEntity entity2 = response1.getEntity();
        Assert.assertEquals((long)200L, (long)response2.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity2);
        EntityUtils.consume((HttpEntity)entity2);
        Assert.assertEquals((long)1L, (long)authStrategy.getCount());
    }

    @Test
    public void testAuthenticationUserinfoInRequestSuccess() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        HttpHost target = this.getServerHttp();
        HttpGet httpget = new HttpGet("http://test:test@" + target.toHostString() + "/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
    }

    @Test
    public void testAuthenticationUserinfoInRequestFailure() throws Exception {
        this.localServer.register("*", new AuthHandler());
        this.localServer.start();
        HttpHost target = this.getServerHttp();
        HttpGet httpget = new HttpGet("http://test:all-wrong@" + target.toHostString() + "/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)401L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
    }

    @Test
    public void testPreemptiveAuthentication() throws Exception {
        CountingAuthHandler requestHandler = new CountingAuthHandler();
        this.localServer.register("*", requestHandler);
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpHost targethost = this.getServerHttp();
        BasicHttpContext context = new BasicHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targethost, (AuthScheme)new BasicScheme());
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        HttpGet httpget = new HttpGet("/");
        HttpResponse response1 = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        HttpEntity entity1 = response1.getEntity();
        Assert.assertEquals((long)200L, (long)response1.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity1);
        EntityUtils.consume((HttpEntity)entity1);
        Assert.assertEquals((long)1L, (long)requestHandler.getCount());
    }

    @Test
    public void testPreemptiveAuthenticationFailure() throws Exception {
        CountingAuthHandler requestHandler = new CountingAuthHandler();
        this.localServer.register("*", requestHandler);
        this.localServer.start();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials("test", "stuff"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpHost targethost = this.getServerHttp();
        BasicHttpContext context = new BasicHttpContext();
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targethost, (AuthScheme)new BasicScheme());
        context.setAttribute("http.auth.auth-cache", (Object)authCache);
        HttpGet httpget = new HttpGet("/");
        HttpResponse response1 = this.httpclient.execute(targethost, (HttpRequest)httpget, (HttpContext)context);
        HttpEntity entity1 = response1.getEntity();
        Assert.assertEquals((long)401L, (long)response1.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity1);
        EntityUtils.consume((HttpEntity)entity1);
        Assert.assertEquals((long)1L, (long)requestHandler.getCount());
    }

    @Test
    public void testAuthenticationTargetAsProxy() throws Exception {
        this.localServer.register("*", new ProxyAuthHandler());
        this.localServer.start();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        this.httpclient.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpGet httpget = new HttpGet("/");
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)407L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)entity);
    }

    static class ProxyAuthHandler
    implements HttpRequestHandler {
        ProxyAuthHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String creds = (String)context.getAttribute("creds");
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(407);
            } else {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("success", Consts.ASCII);
                response.setEntity((HttpEntity)entity);
            }
        }
    }

    static class CountingAuthHandler
    implements HttpRequestHandler {
        private AtomicLong count = new AtomicLong();

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            this.count.incrementAndGet();
            String creds = (String)context.getAttribute("creds");
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(401);
            } else {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("success", Consts.ASCII);
                response.setEntity((HttpEntity)entity);
            }
        }

        public long getCount() {
            return this.count.get();
        }
    }

    static class TestTargetAuthenticationStrategy
    extends TargetAuthenticationStrategy {
        private AtomicLong count = new AtomicLong();

        public boolean isAuthenticationRequested(HttpHost host, HttpResponse response, HttpContext context) {
            boolean res = super.isAuthenticationRequested(host, response, context);
            if (res) {
                this.count.incrementAndGet();
            }
            return res;
        }

        public long getCount() {
            return this.count.get();
        }
    }

    static class TestCredentialsProvider
    implements CredentialsProvider {
        private final Credentials creds;
        private AuthScope authscope;

        TestCredentialsProvider(Credentials creds) {
            this.creds = creds;
        }

        public void clear() {
        }

        public Credentials getCredentials(AuthScope authscope) {
            this.authscope = authscope;
            return this.creds;
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
        }

        public AuthScope getAuthScope() {
            return this.authscope;
        }
    }

    static class AuthExpectationVerifier
    implements HttpExpectationVerifier {
        private final BasicAuthTokenExtractor authTokenExtractor = new BasicAuthTokenExtractor();

        public void verify(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException {
            String creds = this.authTokenExtractor.extract(request);
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(401);
            } else {
                response.setStatusCode(100);
            }
        }
    }

    static class AuthHandler
    implements HttpRequestHandler {
        AuthHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String creds = (String)context.getAttribute("creds");
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(401);
            } else {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("success", Consts.ASCII);
                response.setEntity((HttpEntity)entity);
            }
        }
    }
}

