/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.NonRepeatableRequestException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.localserver.BasicServerTestBase;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDefaultClientRequestDirector
extends BasicServerTestBase {
    @Before
    public void setUp() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.registerDefaultHandlers();
        this.localServer.start();
        this.httpclient = new DefaultHttpClient();
    }

    @Test
    public void testDefaultHostAtClientLevel() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        HttpHost target = new HttpHost("localhost", port);
        this.httpclient.getParams().setParameter("http.default-host", (Object)target);
        String s = "/path";
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testDefaultHostHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)("localhost:" + port), (Object)headers[0].getValue());
    }

    @Test
    public void testVirtualHostHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        String virtHost = "virtual";
        httpget.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtHost, port));
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)(virtHost + ":" + port), (Object)headers[0].getValue());
    }

    @Test
    public void testVirtualHostPortHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        String virtHost = "virtual";
        int virtPort = 9876;
        httpget.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtHost, virtPort));
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)(virtHost + ":" + virtPort), (Object)headers[0].getValue());
    }

    @Test
    public void testClientLevelVirtualHostHeader() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        String virtHost = "virtual";
        this.httpclient.getParams().setParameter("http.virtual-host", (Object)new HttpHost(virtHost, port));
        HttpResponse response = this.httpclient.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Header[] headers = reqWrapper.getHeaders("host");
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.length);
        Assert.assertEquals((Object)(virtHost + ":" + port), (Object)headers[0].getValue());
    }

    @Test
    public void testDefaultHostAtRequestLevel() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        HttpHost target1 = new HttpHost("whatever", 80);
        HttpHost target2 = new HttpHost("localhost", port);
        this.httpclient.getParams().setParameter("http.default-host", (Object)target1);
        String s = "/path";
        HttpGet httpget = new HttpGet(s);
        httpget.getParams().setParameter("http.default-host", (Object)target2);
        HttpResponse response = this.httpclient.execute((HttpUriRequest)httpget);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
    }

    @Test
    public void testAutoGeneratedHeaders() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        FaultyHttpClient client = new FaultyHttpClient();
        client.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader("my-header", "stuff");
            }
        });
        client.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return true;
            }
        });
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpGet httpget = new HttpGet(s);
        HttpResponse response = client.execute(this.getServerHttp(), (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertTrue((boolean)(reqWrapper instanceof RequestWrapper));
        Header[] myheaders = reqWrapper.getHeaders("my-header");
        Assert.assertNotNull((Object)myheaders);
        Assert.assertEquals((long)1L, (long)myheaders.length);
    }

    @Test(expected=ClientProtocolException.class)
    public void testNonRepeatableEntity() throws Exception {
        int port = this.localServer.getServiceAddress().getPort();
        this.localServer.register("*", new SimpleService());
        String failureMsg = "a message showing that this failed";
        FaultyHttpClient client = new FaultyHttpClient(failureMsg);
        client.setHttpRequestRetryHandler(new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                return true;
            }
        });
        BasicHttpContext context = new BasicHttpContext();
        String s = "http://localhost:" + port;
        HttpPost httppost = new HttpPost(s);
        httppost.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9}), -1L));
        try {
            client.execute(this.getServerHttp(), (HttpRequest)httppost, (HttpContext)context);
        }
        catch (ClientProtocolException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof NonRepeatableRequestException));
            NonRepeatableRequestException nonRepeat = (NonRepeatableRequestException)ex.getCause();
            Assert.assertTrue((boolean)(nonRepeat.getCause() instanceof IOException));
            Assert.assertEquals((Object)failureMsg, (Object)nonRepeat.getCause().getMessage());
            throw ex;
        }
    }

    @Test
    public void testDefaultPortVirtualHost() throws Exception {
        this.localServer.register("*", new SimpleService());
        this.httpclient = new DefaultHttpClient();
        HttpHost target = this.getServerHttp();
        HttpHost hostHost = new HttpHost(target.getHostName(), -1, target.getSchemeName());
        this.httpclient.getParams().setParameter("http.default-host", (Object)target);
        this.httpclient.getParams().setParameter("http.virtual-host", (Object)hostHost);
        HttpGet httpget = new HttpGet("/stuff");
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = this.httpclient.execute(null, (HttpRequest)httpget, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
    }

    @Test
    public void testRelativeRequestURIWithFragment() throws Exception {
        this.localServer.register("*", new SimpleService());
        HttpHost target = this.getServerHttp();
        HttpGet httpget = new HttpGet("/stuff#blahblah");
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest request = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((Object)"/stuff", (Object)request.getRequestLine().getUri());
    }

    @Test
    public void testAbsoluteRequestURIWithFragment() throws Exception {
        this.localServer.register("*", new SimpleService());
        HttpHost target = this.getServerHttp();
        URI uri = new URIBuilder().setHost(target.getHostName()).setPort(target.getPort()).setScheme(target.getSchemeName()).setPath("/stuff").setFragment("blahblah").build();
        HttpGet httpget = new HttpGet(uri);
        BasicHttpContext context = new BasicHttpContext();
        HttpResponse response = this.httpclient.execute((HttpUriRequest)httpget, (HttpContext)context);
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest request = (HttpRequest)context.getAttribute("http.request");
        Assert.assertEquals((Object)"/stuff", (Object)request.getRequestLine().getUri());
    }

    private static class FaultyHttpClient
    extends DefaultHttpClient {
        private final String failureMsg;

        public FaultyHttpClient() {
            this("Oppsie");
        }

        public FaultyHttpClient(String failureMsg) {
            this.failureMsg = failureMsg;
        }

        protected HttpRequestExecutor createRequestExecutor() {
            return new FaultyHttpRequestExecutor(this.failureMsg);
        }
    }

    private static class FaultyHttpRequestExecutor
    extends HttpRequestExecutor {
        private static final String MARKER = "marker";
        private final String failureMsg;

        public FaultyHttpRequestExecutor(String failureMsg) {
            this.failureMsg = failureMsg;
        }

        public HttpResponse execute(HttpRequest request, HttpClientConnection conn, HttpContext context) throws IOException, HttpException {
            HttpResponse response = super.execute(request, conn, context);
            Object marker = context.getAttribute(MARKER);
            if (marker == null) {
                context.setAttribute(MARKER, (Object)Boolean.TRUE);
                throw new IOException(this.failureMsg);
            }
            return response;
        }
    }

    private static class SimpleService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            response.setStatusCode(200);
            StringEntity entity = new StringEntity("Whatever");
            response.setEntity((HttpEntity)entity);
        }
    }
}

